/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.opservice.IOpService;
import kd.fi.cas.business.opservice.factory.AgentPayBillFactory;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.opplugin.CommonOpServicePlugIn;
import kd.fi.cas.validator.AgentPayBillWriteValidator;
import kd.fi.cas.validator.AgentPayUnAuditValidator;

public class AgentPayUnAuditOp
extends CommonOpServicePlugIn {
    @Override
    protected IOpService registerService() {
        return AgentPayBillFactory.getUnAuditService();
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AgentPayUnAuditValidator());
        e.addValidator((AbstractValidator)new AgentPayBillWriteValidator(WriteBackOperateEnum.UNAUDITVALIDATE));
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String sql;
        int[] result;
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List pks = Arrays.stream(dataEntities).map(d -> d.getString("id")).collect(Collectors.toList());
        if (!(CollectionUtils.isEmpty(pks) || (result = DB.executeBatch((DBRoute)DBRouteConst.cas, (String)(sql = "update T_CAS_AgentPayBill set fbillstatus = ? where fid in (" + String.join((CharSequence)",", pks) + ") and fbillstatus = ?"), Collections.singletonList(new Object[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.AUDIT.getValue()}))).length >= 1 && result[0] == pks.size())) {
            throw new KDBizException(new PaymentErrorCode().STATUS_CANNOT_UNAUDIT(), new Object[0]);
        }
    }
}

