/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.service.BankStatementDownloadService;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BankStatementDownloadOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject data = e.getDataEntities()[0];
        ArrayList<Long> orgIDs = new ArrayList<Long>();
        DynamicObjectCollection orgCol = data.getDynamicObjectCollection("org");
        for (DynamicObject org : orgCol) {
            orgIDs.add(org.getLong("fbasedataid_id"));
        }
        DynamicObjectCollection accts = data.getDynamicObjectCollection("accountbank");
        ArrayList<Long> acctIDs = new ArrayList<Long>(accts.size());
        for (int i = 0; i < accts.size(); ++i) {
            acctIDs.add(((DynamicObject)accts.get(i)).getLong(2));
        }
        Date beginDate = data.getDate("begindate");
        Date endDate = data.getDate("enddate");
        endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        String noCasInitTips = this.getCasInitTips(orgIDs);
        ArrayList ids = new ArrayList(10);
        BankStatementDownloadService service = new BankStatementDownloadService();
        ids.addAll(service.download(orgIDs, acctIDs, beginDate, endDate));
        if (ids.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(noCasInitTips);
            sb.append(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u5185\u6ca1\u6709\u4ea4\u6613\u660e\u7ec6\u53ef\u4e0b\u8f7d\u4e3a\u5bf9\u8d26\u5355\u3002", (String)"BankStatementDownloadOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            this.operationResult.setMessage(sb.toString());
            this.operationResult.setSuccess(false);
        } else {
            this.operationResult.setMessage(noCasInitTips);
            this.operationResult.setSuccess(true);
            this.operationResult.setSuccessPkIds(ids);
        }
    }

    private String getCasInitTips(List<Long> orgIDs) {
        Map casInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(new HashSet<Long>(orgIDs));
        HashSet<Long> noCasInit = new HashSet<Long>();
        String noCasInitTips = "";
        if (EmptyUtil.isNoEmpty((Object)casInitMap)) {
            for (long item : orgIDs) {
                DynamicObject casInit = (DynamicObject)casInitMap.get(String.valueOf(item));
                if (!EmptyUtil.isEmpty((DynamicObject)casInit) && !EmptyUtil.isEmpty((DynamicObject)casInit.getDynamicObject("startperiod")) && casInit.getBoolean("isfinishinit")) continue;
                noCasInit.add(item);
            }
            if (EmptyUtil.isNoEmpty(noCasInit)) {
                QFilter qFilter = new QFilter("id", "in", noCasInit);
                DynamicObjectCollection bosOrgs = QueryServiceHelper.query((String)"bos_org", (String)"name, number", (QFilter[])qFilter.toArray());
                StringBuilder sb = new StringBuilder();
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bosOrgs)) {
                    for (DynamicObject item : bosOrgs) {
                        sb.append(item.getString("name"));
                        sb.append(",");
                    }
                }
                if (EmptyUtil.isNoEmpty((Object)sb)) {
                    String temp = ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u7ec4\u7ec7 %s \u7684\u51fa\u7eb3\u521d\u59cb\u5316\u518d\u4e0b\u8f7d\u94f6\u884c\u5bf9\u8d26\u5355\u3002\r\n", (String)"BankStatementDownloadOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    noCasInitTips = String.format(temp, sb.substring(0, sb.length() - 1));
                }
            }
        }
        return noCasInitTips;
    }
}

