/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.BankStatementManualSaveValidator;
import org.apache.commons.lang.StringUtils;

public class BankStatementManualSaveOP
extends AbstractOperationServicePlugIn {
    private Map<Long, List<DynamicObject>> periodCache = new HashMap<Long, List<DynamicObject>>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new BankStatementManualSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = this.getOption().getVariableValue("add");
        if (key != null) {
            String[] keys = key.split(",");
            boolean isBlending = false;
            for (int i = 0; i < keys.length; ++i) {
                QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(keys[i])).and(new QFilter("ischeck", "=", (Object)"1"));
                boolean exists = QueryServiceHelper.exists((String)"cas_bankstatement", (QFilter[])new QFilter[]{filter});
                if (!exists) continue;
                isBlending = true;
                break;
            }
            if (isBlending) {
                this.getOption().setVariableValue("msg", ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u52fe\u5bf9\u3002\u65e0\u6cd5\u91cd\u590d\u4fdd\u5b58\u3002", (String)"BankStatementManualSaveOP_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                this.getOption().setVariableValue("key", null);
                return;
            }
            Object[] pkIds = new Long[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                pkIds[i] = Long.parseLong(keys[i]);
            }
            BalanceModelLogHelper.doBalanceModelLog(new HashSet<Long>(Arrays.asList(pkIds)), (String)"cas_bankstatement", (OperateType)OperateType.DELETE);
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement"), (Object[])pkIds);
        }
        DynamicObject[] dynamicObjects = this.transformBill(e);
        List<String> result = this.saveAndDispose(dynamicObjects);
        this.getOption().setVariableValue("key", StringUtils.join(result, (String)","));
        this.getOption().setVariableValue("msg", null);
        ArrayList<String> objectList = new ArrayList<String>(result);
        this.getOperationResult().setSuccessPkIds(objectList);
    }

    private DynamicObject[] transformBill(BeginOperationTransactionArgs e) {
        DynamicObject[] de = e.getDataEntities();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement");
        DynamicObjectCollection entryentitys = de[0].getDynamicObjectCollection("entryentity");
        DynamicObject[] dataEntities = new DynamicObject[entryentitys.size()];
        String[] genStringIds = DB.genStringIds((String)"T_cas_BankStatement", (int)(de.length * entryentitys.size()));
        String source = this.getOption().getVariableValue("source");
        String isModify = this.getOption().getVariableValue("isModify");
        if (EmptyUtil.isNotEmpty((String)isModify) && "true".equals(isModify)) {
            Map<Object, Object> bankStatementMap = new HashMap(16);
            List bankStatementIds = entryentitys.stream().map(o -> o.getLong("bankstatementid")).collect(Collectors.toList());
            DynamicObject[] bankStatements = BusinessDataServiceHelper.load((Object[])bankStatementIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement"));
            bankStatementMap = Arrays.stream(bankStatements).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
            for (int i = 0; i < entryentitys.size(); ++i) {
                DynamicObject entrydy = (DynamicObject)entryentitys.get(i);
                DynamicObject bankState = (DynamicObject)bankStatementMap.get(entrydy.getLong("bankstatementid"));
                DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"sortno", (Object)entrydy.getLong("sortno"));
                this.setEntryValues(entrydy, bankState);
                dataEntities[i] = bankState;
            }
        } else {
            boolean checkFlag;
            List sortNoList = entryentitys.stream().map(o -> o.getLong("sortno")).filter(c -> c != 0L).collect(Collectors.toList());
            boolean needReSort = sortNoList.size() < 1;
            boolean bl = checkFlag = sortNoList.size() > 0 && sortNoList.size() < entryentitys.size();
            if (checkFlag) {
                String accountNumber = de[0].getDynamicObject("accountbank").getString("bankaccountnumber");
                String currencyNumber = de[0].getDynamicObject("currency").getString("number");
                String errMsg = String.format(ResManager.loadKDString((String)"\u8d26\u6237\u201c%1$s\u201d\uff08%2$s\uff09\u672c\u6b21\u5bfc\u5165\u6570\u636e\u4e2d\u53ea\u6709\u90e8\u5206\u586b\u5199\u4e86\u6392\u5e8f\u53f7\uff0c\u8bf7\u5168\u90e8\u586b\u5199\u6392\u5e8f\u53f7\u540e\u518d\u5bfc\u5165\uff1b\u4e5f\u53ef\u4ee5\u5168\u90e8\u6e05\u7a7a\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u6839\u636e\u6570\u636e\u5bfc\u5165\u65f6\u95f4\u8fdb\u884c\u6392\u5e8f\u3002", (String)"BankStatementManualSaveOP_2", (String)"", (Object[])new Object[0]), accountNumber, currencyNumber);
                throw new KDBizException(errMsg);
            }
            int count = 0;
            for (DynamicObject dynamicObject : de) {
                DynamicObject casRecEdc = this.recDecPeriod(dynamicObject);
                for (int i = 0; i < entryentitys.size(); ++i) {
                    DynamicObject entrydy = (DynamicObject)entryentitys.get(i);
                    DynamicObject bankState = new DynamicObject((DynamicObjectType)entityType);
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"org", (Object)dynamicObject.get("org"));
                    String number = genStringIds[count++];
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"billno", (Object)number);
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"accountbank", (Object)dynamicObject.get("accountbank"));
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"currency", (Object)dynamicObject.get("currency"));
                    DynamicObject period = this.getPeriod(dynamicObject.getLong("org.id"), entrydy.getDate("bizdate"));
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"period", (Object)period);
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"settlementtype", null);
                    Long sortNo = needReSort ? new Timestamp(System.currentTimeMillis()).getTime() * 100000L + (long)count % 100000L : entrydy.getLong("sortno");
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"sortno", (Object)sortNo);
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"vouchernumber", null);
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"biztype", null);
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"ischeck", (Object)0);
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"source", (Object)(EmptyUtil.isEmpty((String)source) ? Integer.valueOf(4) : source));
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"sourcebillid", (Object)dynamicObject.get("id"));
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"createtime", (Object)new Date());
                    this.setEntryValues(entrydy, bankState);
                    DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"transtime", (Object)(EmptyUtil.isEmpty((Object)entrydy.get("transtime")) ? entrydy.get("bizdate") : entrydy.get("transtime")));
                    this.setValid(bankState, dynamicObject, casRecEdc, entrydy);
                    dataEntities[i] = bankState;
                }
            }
        }
        return dataEntities;
    }

    private void setEntryValues(DynamicObject entrydy, DynamicObject bankState) {
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"billstatus", (Object)"B");
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"bizdate", (Object)entrydy.get("bizdate"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"description", (Object)entrydy.get("description"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"settlementnumber", (Object)entrydy.get("settlementnumber"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"debitamount", (Object)entrydy.get("debitamount"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"creditamount", (Object)entrydy.get("creditamount"));
        int direction = entrydy.getBigDecimal("debitamount").doubleValue() != 0.0 ? 1 : 2;
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"direction", (Object)direction);
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"balanceamt", (Object)entrydy.get("balanceamt"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"tradenumber", (Object)entrydy.get("tradenumber"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"cashier", (Object)entrydy.get("cashier"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"oppunit", (Object)entrydy.get("oppunitname"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"oppaccountnumber", (Object)entrydy.get("oppaccountnumber"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"oppbank", (Object)entrydy.get("oppbank"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"bankcheckflag", (Object)entrydy.get("bankcheckflag"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"bankvouvherno", (Object)entrydy.get("bankvouvherno"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"bankdetailno", (Object)entrydy.get("bankdetailno"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"vouchernumber", (Object)entrydy.get("vouchernumber"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"ratesdate", (Object)entrydy.get("ratesdate"));
    }

    private DynamicObject recDecPeriod(DynamicObject dynamicObject) {
        DynamicObject account = dynamicObject.getDynamicObject("accountbank");
        DynamicObject accountOrg = account.getDynamicObject("openorg");
        QFilter filterRecEdc = new QFilter("org", "=", accountOrg.getPkValue());
        DynamicObject casRecEdc = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod, startperiod", (QFilter[])new QFilter[]{filterRecEdc});
        return casRecEdc;
    }

    private void setValid(DynamicObject bankState, DynamicObject dynamicObject, DynamicObject casRecEdc, DynamicObject entrydy) {
        if (EmptyUtil.isEmpty((DynamicObject)casRecEdc)) {
            DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"isvalid", (Object)true);
            return;
        }
        DynamicObject period = this.getPeriod(dynamicObject.getLong("org.id"), entrydy.getDate("bizdate"));
        if (PeriodHelper.before((DynamicObject)period, (DynamicObject)casRecEdc.getDynamicObject("recperiod"))) {
            DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"isvalid", (Object)false);
            return;
        }
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"isvalid", (Object)true);
    }

    private List<String> saveAndDispose(DynamicObject[] bankStates) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            Object[] result = SaveServiceHelper.save((DynamicObject[])bankStates);
            BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])bankStates, (OperateType)OperateType.ADD);
            final ArrayList<String> savedPks = new ArrayList<String>(result.length);
            for (int j = 0; j < result.length; ++j) {
                DynamicObject obj = (DynamicObject)result[j];
                savedPks.add(obj.getString("id"));
            }
            TX.addCommitListener((CommitListener)new CommitListener(){

                public void onEnded(boolean rollbacked) {
                    ThreadPools.executeOnceIncludeRequestContext((String)ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u7535\u5b50\u5f52\u6863", (String)"BankStatementManualSaveOP_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), () -> OperateServiceHelper.execOperateWithoutThrow((String)"audit", (String)"cas_bankstatement", (Object[])savedPks.toArray(), (OperateOption)OperateOption.create()));
                }
            });
            ArrayList<String> arrayList = savedPks;
            return arrayList;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private DynamicObject getPeriod(Long orgId, Date bizDate) {
        List<DynamicObject> periodList = this.periodCache.get(orgId);
        if (periodList != null) {
            for (DynamicObject period : periodList) {
                if (EmptyUtil.isEmpty((DynamicObject)period)) continue;
                Date beginDate = period.getDate("begindate");
                Date endDate = period.getDate("enddate");
                if (bizDate.compareTo(beginDate) < 0 || bizDate.compareTo(endDate) > 0) continue;
                return period;
            }
        }
        DynamicObject period = PeriodHelper.getPeriodByDate((long)orgId, (Date)bizDate);
        if (periodList == null) {
            periodList = new ArrayList<DynamicObject>();
            this.periodCache.put(orgId, periodList);
        }
        periodList.add(period);
        return period;
    }
}

