/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.factory.BankVCCheckServiceContext;
import kd.fi.cas.business.pojo.BankVCCheckInfo;
import kd.fi.cas.validator.BankVCAutoCheckValidator;

public class BankVCAutoCheckOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BankVCAutoCheckOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        BankVCAutoCheckValidator v = new BankVCAutoCheckValidator();
        v.setEntityKey("cas_bankvccheck");
        e.addValidator((AbstractValidator)v);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject data = dataEntities[i];
            long orgId = data.getLong("org.id");
            DynamicObject checkScheme = BusinessDataServiceHelper.loadSingle((String)"cas_checkscheme", (String)"id,org,ischeckflag,issettlenum4schedule,isbizdate,isdatediff,issettlementtype,issettlenum4auto,isdescription,isoppunit,datediffcount", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            checkScheme.set("org", (Object)orgId);
            BankVCCheckInfo checkInfo = new BankVCCheckInfo();
            checkInfo.setOrgId(orgId);
            checkInfo.setAccountBankId(data.getLong("accountbank.id"));
            checkInfo.setCurrencyId(data.getLong("currency.id"));
            checkInfo.setBeginDate(data.getDate("bizdate"));
            checkInfo.setEndDate(data.getDate("bizdateend"));
            checkInfo.setCheckType("checktype");
            checkInfo.setCheckScheme(checkScheme);
            StringBuilder stringBuilder = new StringBuilder();
            logger.info(stringBuilder.append("\u81ea\u52a8\u5bf9\u8d26\u2014\u2014\u5f00\u59cb\u6267\u884c\u5bf9\u8d26\u65b9\u6cd5doCheck\uff1a").append(checkInfo).toString());
            BankVCCheckServiceContext checkContext = new BankVCCheckServiceContext(checkInfo);
            checkContext.doCheck();
            logger.info("\u81ea\u52a8\u5bf9\u8d26\u2014\u2014docheck\u65b9\u6cd5\u6267\u884c\u5b8c\u6210");
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("accountbank.id");
        e.getFieldKeys().add("currency.id");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("bizdateend");
        e.getFieldKeys().add("org.name");
    }
}

