/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.validator.CancelMatchValidator;
import kd.fi.cas.validator.common.TxLockValidator;
import org.apache.commons.lang3.StringUtils;

public class CancelMatchOp
extends AbstractOperationServicePlugIn {
    private static final List<String> MATCH_RECEIVED_WAY_LIST = Arrays.asList(ReceredWayEnum.AUTOMATCH.getValue(), ReceredWayEnum.HANDMATCH.getValue(), ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.REVERSEMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue(), ReceredWayEnum.BEIPAY.getValue());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("matchflag");
        fieldKeys.add("sourcebilltype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TxLockValidator());
        e.addValidator((AbstractValidator)new CancelMatchValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperationResult result;
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List idList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] transDetails = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id,receredway,debitamount,creditamount,recedbillentry,recedbillentry.e_recedbillid", (QFilter[])new QFilter("recedbillentry.e_recedbillid", "in", idList).and(new QFilter("recedbillentry.e_recedbilltype", "=", (Object)dataEntities[0].getDataEntityType().getName())).toArray());
        Object[] matchReceivedPayId = Arrays.stream(transDetails).filter(d -> MATCH_RECEIVED_WAY_LIST.contains(d.getString("receredway"))).map(d -> d.getLong("id")).distinct().toArray();
        StringBuilder message = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.operationResult.getMessage())) {
            message.append(this.operationResult.getMessage()).append("\r\n");
        }
        if (matchReceivedPayId.length != 0 && !(result = OperateServiceHelper.executeOperate((String)"cancelmatch", (String)"bei_intelpay", (Object[])matchReceivedPayId, (OperateOption)OperateOption.create())).isSuccess()) {
            this.operationResult.getAllErrorOrValidateInfo().addAll(result.getAllErrorOrValidateInfo());
            this.operationResult.setShowMessage(true);
            if (StringUtils.isNotBlank((CharSequence)result.getMessage())) {
                message.append(result.getMessage()).append("\r\n");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage(message.substring(0, message.length() - 2));
        }
    }
}

