/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class CasPayApplyFillDraftBillEntryOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CasPayApplyFillDraftBillEntryOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("billno");
        list.add("id");
        list.add("cas_payinfo");
        list.add(String.join((CharSequence)".", "cas_payinfo", "entry_settletnumber"));
        list.add(String.join((CharSequence)".", "cas_payinfo", "entry_draftbill"));
        list.add(String.join((CharSequence)".", "cas_payinfo", "entry_paystatus"));
        list.add(String.join((CharSequence)".", "cas_payinfo", "entry_invalid"));
        list.add("cas_draftinfo");
        list.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "srcbillindex"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "srcbillid"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "srcbilltype"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "paybillcurrency"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("beginOperationTransaction to fillBillDraftInfoEntry start");
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.fillBillDraftInfoEntry(dataEntities);
        logger.info("beginOperationTransaction to fillBillDraftInfoEntry end");
    }

    private void fillBillDraftInfoEntry(DynamicObject[] datas) {
        ArrayList<DynamicObject> listArr = new ArrayList<DynamicObject>(8);
        for (DynamicObject data : datas) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_payinfo");
            DynamicObjectCollection cas_draftinfoEntry = data.getDynamicObjectCollection("cas_draftinfo");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) || !EmptyUtil.isEmpty((DynamicObjectCollection)cas_draftinfoEntry) && cas_draftinfoEntry.size() != 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject payInfoData = (DynamicObject)entrys.get(i);
                long srcbillid = payInfoData.getLong("id");
                DynamicObjectCollection newDrafts = payInfoData.getDynamicObjectCollection("entry_draftbill");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)newDrafts) || newDrafts.size() <= 0) continue;
                for (DynamicObject newDraft : newDrafts) {
                    DynamicObject fbasedataid = newDraft.getDynamicObject("fbasedataid");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
                    DynamicObject cas_draftinfo = cas_draftinfoEntry.addNew();
                    cas_draftinfo.set("transamount", (Object)fbasedataid.getBigDecimal("amount"));
                    cas_draftinfo.set("paybillcurrency", (Object)fbasedataid.getDynamicObject("currency").getLong("id"));
                    cas_draftinfo.set("draftbillinfo", (Object)fbasedataid);
                    cas_draftinfo.set("srcbillindex", (Object)(i + 1));
                    cas_draftinfo.set("srcbillid", (Object)srcbillid);
                    cas_draftinfo.set("srcbilltype", (Object)"cas_payapplybill");
                }
            }
            listArr.add(data);
        }
        if (listArr.size() > 0) {
            logger.info("listArr size is" + listArr.size());
            SaveServiceHelper.save((DynamicObject[])listArr.toArray(new DynamicObject[0]));
            logger.info("listArr save end");
        } else {
            logger.info("need not to save");
        }
    }
}

