/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.init.CashMgtInitAction;
import kd.fi.cas.validator.CashMgtInitFinishInitValidator;

public class CashMgtInitFinishInitOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(CashMgtInitFinishInitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("startperiod");
        fieldKeys.add("entrycash");
        fieldKeys.add("entrybank");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("currentperiod");
        fieldKeys.add("isfinishinit");
        fieldKeys.add("entrycash.cash_accountcash");
        fieldKeys.add("entrycash.cash_currency");
        fieldKeys.add("entrycash.cash_yearcredit");
        fieldKeys.add("entrycash.cash_yeardebit");
        fieldKeys.add("entrycash.cash_balance");
        fieldKeys.add("entrybank.bank_accountbank");
        fieldKeys.add("entrybank.bank_currency");
        fieldKeys.add("entrybank.bank_journalbalance");
        fieldKeys.add("entrybank.bank_journaldebit");
        fieldKeys.add("entrybank.bank_journalcredit");
        fieldKeys.add("entrybank.bank_journalbalanceadj");
        fieldKeys.add("entrybank.bank_statementbalanceadj");
        fieldKeys.add("entrybank.bank_journalsumbalanceadj");
        fieldKeys.add("entrybank.bank_equal");
        fieldKeys.add("entrybank.bank_statementbalance");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] cashMgtInits;
        super.endOperationTransaction(e);
        for (DynamicObject cashMgtInit : cashMgtInits = e.getDataEntities()) {
            DynamicObjectHelper.setValue((DynamicObject)cashMgtInit, (String)"isfinishinit", (Object)1);
            DynamicObjectHelper.setValue((DynamicObject)cashMgtInit, (String)"currentperiod", (Object)cashMgtInit.get("startperiod"));
        }
        BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])cashMgtInits, (OperateType)OperateType.ADD);
        CashMgtInitAction cashMgtInitAction = CashMgtInitAction.getInstance();
        cashMgtInitAction.execute(cashMgtInits);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        CashMgtInitFinishInitValidator v = new CashMgtInitFinishInitValidator();
        v.setEntityKey("cas_cashmgtinit");
        e.addValidator((AbstractValidator)v);
        super.onAddValidators(e);
    }
}

