/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.VoucherCheckHepler;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.writeback.PaymentSaveOrSubmitWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.info.WriteBackTaskInfo;

public class ExchangeBillCancelExchangeOp
extends AbstractOperationServicePlugIn {
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private List<DynamicObject> srcBillList = new ArrayList<DynamicObject>(0);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.getSelector());
    }

    private List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("billno");
        list.add("billstatus");
        list.add("sourcebilltype");
        return list;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject exchangeBill = dataEntity.getDataEntity();
                    String billStatus = exchangeBill.getString("billstatus");
                    if (!"F".equals(billStatus)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5151\u6362\u624d\u80fd\u53d6\u6d88\u5151\u6362\u3002", (String)"ExchangeBillCancelExchangeOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                    ExchangeBillCancelExchangeOp.this.journalServiceAdapter.validateCancelBook(exchangeBill);
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] exchangeBills;
        super.endOperationTransaction(e);
        for (DynamicObject exchangeBill : exchangeBills = e.getDataEntities()) {
            this.journalServiceAdapter.cancelBook(exchangeBill);
            exchangeBill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])exchangeBills);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        this.srcBillList = ((Stream)Arrays.stream(infos).parallel()).filter(d -> CasHelper.isNotEmpty((Object)d.getString("sourcebilltype"))).collect(Collectors.toList());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)info.getDataEntityType().getName(), (String)"billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) continue;
            VoucherCheckHepler.doCancelCoucherCheck((DynamicObject)info);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (this.srcBillList.size() > 0) {
            ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(e.getDataEntities().length);
            for (DynamicObject bill : this.srcBillList) {
                WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
                taskInfo.setBillId((Long)bill.getPkValue());
                taskInfo.setDataEntity(bill.getDataEntityType().getName());
                taskInfo.setSourceEntity(bill.getString("sourcebilltype"));
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("operate", "cancelexchange");
                taskInfo.setParam(param);
                taskInfos.add(taskInfo);
            }
            WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.CANCELEXCHANGE, PaymentSaveOrSubmitWriteBackConsumer.class);
        }
    }
}

