/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.business.opservice.impl.BillPropertyValueHandle;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.validator.ExchangeBillWriteBackValidator;
import kd.fi.cas.validator.OrgFinishinitValidator;

public class ExchangeBillSaveOp
extends AbstractOperationServicePlugIn {
    private List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>(30);
        list.add("billno");
        list.add("billstatus");
        list.add("bizdate");
        list.add("sellinglocalamount");
        list.add("buyinglocalamount");
        list.add("exchangegainorloss");
        list.add("commissionlocalamount");
        list.add("paycommissionaccount");
        list.add("sellingaccount");
        list.add("org");
        list.add("buyingcurrency");
        list.add("sellingcurrency");
        list.add("commissioncurrency");
        list.add("basecurrency");
        list.add("buyingexchangerate");
        list.add("sellingexchangerate");
        list.add("commissionexchangerate");
        list.add("quotation");
        list.add("salequotation");
        list.add("otherquotation");
        list.add("exratetable");
        list.add("exratedate");
        list.add("sourcebilltype");
        return list;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.getSelector());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new OrgFinishinitValidator());
        e.getValidators().add(new ExchangeBillWriteBackValidator(WriteBackOperateEnum.SAVEVALIDATE));
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject exchangeBill = dataEntity.getDataEntity();
                    String sourceBillType = exchangeBill.getString("sourcebilltype");
                    DynamicObject exrateTable = exchangeBill.getDynamicObject("exratetable");
                    if (sourceBillType != null || exrateTable != null) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u7387\u8868\u201d\u3002", (String)"ExchangeBillSaveOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            new BillPropertyValueHandle(info);
        }
    }
}

