/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.validator.FundFlowItemDeleteValidator;

public class FundFlowItemDeleteOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        FundFlowItemDeleteValidator v = new FundFlowItemDeleteValidator();
        v.setEntityKey("cas_fundflowitem");
        e.addValidator((AbstractValidator)v);
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("longnumber");
        e.getFieldKeys().add("level");
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("property");
        e.getFieldKeys().add("direction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        TXHandle h = TX.beginNew();
        try {
            String sql;
            DynamicObject[] datas = e.getDataEntities();
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_fundflowitem");
            DynamicObjectCollection newDatas = new DynamicObjectCollection((DynamicObjectType)entityType, null);
            ArrayList<Long> idpk = new ArrayList<Long>(datas.length);
            ArrayList<SqlParameter[]> deleteParams = new ArrayList<SqlParameter[]>(datas.length);
            ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(datas.length);
            for (DynamicObject data : datas) {
                String parentlongnuberStr;
                QFilter fiterOne;
                DynamicObjectCollection subFFItems;
                DynamicObject parentFFItem = data.getDynamicObject("parent");
                String longnuberStr = data.getString("longnumber") + ".%";
                DynamicObjectCollection allSubFfiDos = QueryServiceHelper.query((String)"cas_fundflowitem", (String)"id,number,longnumber", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)longnuberStr)});
                idpk.add(data.getLong("id"));
                for (DynamicObject subItem : allSubFfiDos) {
                    idpk.add(subItem.getLong("id"));
                }
                DynamicObjectCollection referedByPa = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{new QFilter("fundflowitem", "in", idpk)});
                DynamicObjectCollection referedByRe = QueryServiceHelper.query((String)"cas_recbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("entry.e_fundflowitem", "in", idpk)});
                DynamicObjectCollection referedByAg = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id", (QFilter[])new QFilter[]{new QFilter("entry.e_fundflowitem", "in", idpk)});
                if (!(referedByPa != null && referedByPa.size() > 0 || referedByRe != null && referedByRe.size() > 0 || referedByAg != null && referedByAg.size() > 0)) {
                    for (DynamicObject subItem : allSubFfiDos) {
                        if (newDatas.indexOf((Object)subItem) >= 0) continue;
                        newDatas.add((Object)subItem);
                    }
                }
                if (newDatas != null && newDatas.size() > 0) {
                    for (DynamicObject newItem : newDatas) {
                        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FID", -5, newItem.getPkValue())};
                        deleteParams.add(params);
                    }
                }
                if (parentFFItem == null || (subFFItems = QueryServiceHelper.query((String)"cas_fundflowitem", (String)"*", (QFilter[])new QFilter[]{fiterOne = new QFilter("longnumber", "like", (Object)(parentlongnuberStr = parentFFItem.getString("longnumber") + ".%"))})).size() >= 1) continue;
                SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)parentFFItem.getLong("id"))};
                updateParams.add(params);
            }
            if (deleteParams.size() > 0) {
                sql = "delete from T_CAS_FundFlowItem where FID = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, deleteParams);
            }
            if (updateParams.size() > 0) {
                sql = "update T_CAS_FundFlowItem set fisleaf = 1 where FID = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, updateParams);
            }
        }
        finally {
            h.end();
        }
    }
}

