/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.PayPushIfmCancelValidator;

public class PayPushIfmCancelOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PayPushIfmCancelOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PayPushIfmCancelValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("paymenttype");
        lst.add("inneraccount");
        lst.add("inneraccount");
        lst.add("billstatus");
        lst.add("paymentchannel");
        lst.add("sourcebilltype");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs a) {
        DynamicObject[] infos;
        super.beginOperationTransaction(a);
        ArrayList<Long> pkIds = new ArrayList<Long>(10);
        for (DynamicObject transBill : infos = a.getDataEntities()) {
            pkIds.add(transBill.getLong("id"));
        }
        DynamicObject[] transBills = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        StringJoiner errorMsg = new StringJoiner("\r\n");
        try {
            List billnos = Arrays.stream(transBills).map(e -> e.get("billno").toString()).collect(Collectors.toList());
            Map lockResultMap = MutexServiceHelper.batchRequest(billnos, (String)"fi-cas-pushIfmCancel", (String)"pushIfmCancel");
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e %s \u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PayPushInnerRecOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e %s \u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PayPushInnerRecOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
            }
            this.dealPushCancel(transBills, errorMsg);
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"fi-cas-pushIfmCancel", (String)"pushIfmCancel");
        }
        if (errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
    }

    private void dealPushCancel(DynamicObject[] dataEntities, StringJoiner msgList) {
        for (DynamicObject trans : dataEntities) {
            try {
                DynamicObject[] rec;
                Object[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id ", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)trans.getLong("id"))});
                if (!EmptyUtil.isNoEmpty((Object[])recBills)) continue;
                List ids = Arrays.stream(recBills).map(e -> e.getLong("id")).collect(Collectors.toList());
                for (DynamicObject dynamicObject : rec = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"))) {
                    DynamicObject recType = dynamicObject.getDynamicObject("receivingtype");
                    if (recType == null || !"108".equals(recType.getString("biztype"))) continue;
                    OperateServiceHelper.execOperate((String)"delete", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create(), (boolean)true);
                }
            }
            catch (Exception e2) {
                logger.error((Throwable)e2);
                msgList.add(String.format("%s:" + e2, trans.get("billno")));
            }
        }
    }
}

