/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.business.opservice.IOpService;
import kd.fi.cas.business.opservice.factory.PaymentBillFactory;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.params.ParamMap;
import kd.fi.cas.validator.BillAutoAuditValidator;
import kd.fi.cas.validator.CommonOpValidator;
import kd.fi.cas.validator.PayBillWriteValidator;
import kd.fi.cas.validator.PaymentBillIsFreezeValidator;
import kd.fi.cas.validator.paymentbill.PaymentAuditValidator;
import kd.fi.cas.validator.paymentbill.PaymentLCOpenValidator;

public class PaymentAuditOp
extends AbstractOperationServicePlugIn {
    private IOpService iSerivce = PaymentBillFactory.getAuditService();
    private ParamMap param = new ParamMap();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.addAll(this.iSerivce.getSelector());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PaymentAuditValidator());
        e.addValidator((AbstractValidator)new PaymentLCOpenValidator());
        this.iSerivce.prepare(e.getDataEntities(), this.param);
        e.getValidators().add(new CommonOpValidator(this.iSerivce, "cas_paybill", ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5ba1\u6838", (String)"PaymentAuditOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0])));
        e.addValidator((AbstractValidator)new PaymentBillIsFreezeValidator());
        if (!CasHelper.isEmpty(this.getOption().getVariables().get("gl_intellexecschema"))) {
            e.addValidator((AbstractValidator)new BillAutoAuditValidator());
        }
        e.addValidator((AbstractValidator)new PayBillWriteValidator(WriteBackOperateEnum.AUDITVALIDATE));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObjectCollection entryList = info.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryList) {
                BigDecimal ePayableAmt = entry.getBigDecimal("e_payableamt");
                BigDecimal eSettledamt = entry.getBigDecimal("e_settledamt");
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unsettledamt", (Object)ePayableAmt.subtract(eSettledamt));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            this.iSerivce.process(info);
        }
    }
}

