/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.VoucherCheckHepler;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.opservice.helper.PaymentSaleServiceHelper;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.bean.LockResult;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.util.DraftBillUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.PayBillWriteValidator;
import kd.fi.cas.validator.PaymentCancelPayNewValidator;
import kd.fi.cas.validator.PaymentCancelPayRecValidator;
import kd.fi.cas.validator.PaymentCancelPayValidator;
import org.apache.commons.lang3.StringUtils;

public class PaymentCancelPayOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PaymentCancelPayOp.class);
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private DraftLockServiceHelper draftLockServiceHelper;
    private Map<Long, Set<Long>> recIdAndReleaIdMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Set<Long>> payIdAndDraftIdSetMap = new HashMap<Long, Set<Long>>(8);
    private Set<Long> dealReleRecIdSet = new HashSet<Long>(16);
    private Map<Long, Long> releaIdAndPayIdMap = new HashMap<Long, Long>(16);
    private Set<Long> ids;
    private Set<Long> sourceIds = new HashSet<Long>();
    private DynamicObject[] srcPayBills;
    private Map<String, Object> orgSysMap;
    private Map<Long, List<Long>> reverseVoucherMap = new HashMap<Long, List<Long>>();
    private Map<Long, DynamicObject> redPayBillMap = new HashMap<Long, DynamicObject>();
    private Set<Long> releatedEndorsedPayBillSet = new HashSet<Long>();
    Set<Long> clearDraftPayIdSet = new HashSet<Long>(16);
    private Map<Long, Set<Long>> payCdmPayMap;
    private Map<Long, Set<Long>> payCdmTransMap;
    private Map<Long, Set<Long>> payRecMap;
    private PaymentCancelPayNewValidator payNewValidator = new PaymentCancelPayNewValidator(this.journalServiceAdapter);

    public PaymentCancelPayOp() {
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("billno");
        list.add("billstatus");
        list.add("bizdate");
        list.add("sourcetype");
        list.add("sourcebilltype");
        list.add("sourcebillid");
        list.add("cashier");
        list.add("paydate");
        list.add("iscommitbe");
        list.add("bankpayingid");
        list.add("entrance");
        list.add("paymenttype");
        list.add("isvoucher");
        list.add("applyorg");
        list.add("entrustorg");
        list.add("e_settledamt");
        list.add("e_sourcebillid");
        list.add("e_sourcebillentryid");
        list.add("e_actamt");
        list.add("e_sourcebillid");
        list.add("e_corebillid");
        list.add("e_corebillentryid");
        list.add("e_corebilltype");
        list.add("e_payableamt");
        list.add("draftbill");
        list.add("settletype");
        list.add("isvoucher");
        list.add("conbillid");
        list.add("conbillentryid");
        list.add("fee");
        list.add("hotaccount");
        list.add("org");
        list.add("settletype");
        list.add(String.join((CharSequence)".", "settletype", "settlementtype"));
        list.add("settletnumber");
        list.add("billtype");
        list.add("paymentidentify");
        list.add("singlestream");
        list.add("basecurrency");
        list.add("feepaydate");
        list.add("payeracctbank");
        list.add("payee");
        list.add("acctstatus");
        list.add("payeetype");
        list.add("bankcheckflag_tag");
        list.add("sourcebilltype");
        list.add("entry");
        list.add(String.join((CharSequence)".", "entry", "e_sourcebillid"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
        list.add(String.join((CharSequence)".", "entry", "e_scheid"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        validators.add(new PaymentCancelPayValidator());
        validators.add(new PaymentCancelPayRecValidator());
        validators.add(this.payNewValidator);
        e.addValidator((AbstractValidator)new PayBillWriteValidator(WriteBackOperateEnum.CANCELPAYVALIDATE));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] paybills = e.getDataEntities();
        this.ids = Arrays.stream(paybills).map(d -> d.getLong("id")).collect(Collectors.toSet());
        HashSet orgIds = new HashSet();
        Arrays.stream(paybills).forEach(d -> {
            if (EmptyUtil.isNoEmpty((Long)d.getDynamicObject("org").getLong("id"))) {
                orgIds.add(d.getDynamicObject("org").getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("applyorg")) && "cas_paybill".equals(d.getString("sourcebilltype"))) {
                this.sourceIds.add(d.getLong("sourcebillid"));
            }
        });
        this.orgSysMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs116");
        Object voucerOp = this.getOption().getVariables().get("voucerOp");
        for (DynamicObject paybill : paybills) {
            int orgSysParam;
            long id = paybill.getLong("id");
            long orgId = paybill.getDynamicObject("org").getLong("id");
            int n = orgSysParam = EmptyUtil.isEmpty((Object)this.orgSysMap.get(String.valueOf(orgId))) ? 0 : Integer.parseInt((String)this.orgSysMap.get(String.valueOf(orgId)));
            if (1 == orgSysParam) {
                Set voucherIds = DapVoucherUtil.getBuildVch(Collections.singleton(paybill.getLong("id")), (String)"cas_paybill");
                List rvIds = VoucherBookHelper.reverseVoucher((Set)voucherIds, voucerOp);
                this.reverseVoucherMap.put(id, rvIds);
                continue;
            }
            if (2 != orgSysParam) continue;
            DynamicObject redPayBill = PayBillHepler.dealReverse((DynamicObject)paybill);
            CasBotpHelper.saveRelation((String)"cas_paybill", (Long)paybill.getLong("id"), (String)"cas_paybill", (Long)redPayBill.getLong("id"));
            this.redPayBillMap.put(id, redPayBill);
        }
        if (this.sourceIds.size() > 0) {
            this.srcPayBills = BusinessDataServiceHelper.load((Object[])this.sourceIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        }
        this.dealFeePayBills(paybills);
        this.payCdmPayMap = this.payNewValidator.getPayCdmPayMap();
        this.payCdmTransMap = this.payNewValidator.getPayCdmTranMap();
        this.payRecMap = this.payNewValidator.getPayRecMap();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String isreleacancel;
        super.beginOperationTransaction(e);
        DynamicObject[] paybills = e.getDataEntities();
        Map variables = this.getOption().getVariables();
        if (EmptyUtil.isNoEmpty((Object)variables) && variables.size() > 0 && EmptyUtil.isEmpty((String)(isreleacancel = (String)variables.get("isreleacancel")))) {
            this.recIdAndReleaIdMap = DraftHelper.getBatchDealCasBillId((DynamicObject[])paybills, this.dealReleRecIdSet, this.releaIdAndPayIdMap, this.payIdAndDraftIdSetMap);
        }
        this.batchCancelProcess(paybills, this.reverseVoucherMap);
        boolean isFromBillData = this.isFromCdm();
        for (DynamicObject paybill : e.getDataEntities()) {
            try (TXHandle tx = TX.requiresNew();){
                CasBotpHelper.deleteRation((DBRoute)DBRouteConst.TMC, (String)"cdm_receivablebill", (Long[])new Long[0], (Long)paybill.getLong("id"));
                DynamicObject settleType = paybill.getDynamicObject("settletype");
                if (!EmptyUtil.isNoEmpty((DynamicObject)settleType) || isFromBillData) continue;
                String settlementtype = settleType.getString("settlementtype");
                CasBotpHelper.deleteRation((DBRoute)DBRouteConst.TMC, (String)"cdm_payablebill", (Long[])new Long[0], (Long)paybill.getLong("id"));
            }
        }
        ArrayList<DynamicObject> writeBackBills = new ArrayList<DynamicObject>();
        for (DynamicObject info : paybills) {
            if (!"cas_payapplybill".equals(info.getString("sourcebilltype")) && !PayBillHepler.isLCSettlement((DynamicObject)info)) continue;
            writeBackBills.add(info);
        }
        if (EmptyUtil.isNoEmpty(writeBackBills)) {
            PayBillHepler.batchPayApplyBillWriteBackArrival((DynamicObject[])writeBackBills.toArray(new DynamicObject[0]), (WriteBackOperateEnum)WriteBackOperateEnum.CANCELPAY, PaymentDisposeConsumer.class);
        }
        ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(paybills.length);
        for (DynamicObject payBill : paybills) {
            WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
            taskInfo.setBillId((Long)payBill.getPkValue());
            taskInfo.setDataEntity(payBill.getDataEntityType().getName());
            taskInfo.setSourceEntity("ap_settle");
            taskInfos.add(taskInfo);
        }
        WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.CANCELPAY, PaymentDisposeConsumer.class);
    }

    private void batchCancelProcess(DynamicObject[] paybills, Map<Long, List<Long>> reverseVoucherMap) {
        String cancelvalid = (String)this.getOption().getVariables().get("cancelvalid");
        if (EmptyUtil.isEmpty((String)cancelvalid)) {
            try {
                this.batchCancelSrcPayProcess(this.srcPayBills);
                this.batchCancelPayProcess(paybills);
            }
            catch (Exception e) {
                HashSet<Long> reverVouIds = new HashSet<Long>();
                if (reverseVoucherMap.size() > 0) {
                    Collection<List<Long>> values = reverseVoucherMap.values();
                    for (List<Long> value : values) {
                        if (!CasHelper.isNotEmpty(value)) continue;
                        reverVouIds.addAll(value);
                    }
                }
                if (reverVouIds.size() > 0) {
                    OperateServiceHelper.execOperate((String)"delete", (String)"gl_voucher", (Object[])reverVouIds.toArray(), (OperateOption)OperateOption.create());
                }
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        QFilter[] filters;
        DynamicObjectCollection arBills;
        super.afterExecuteOperationTransaction(e);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", this.ids)});
        Map<Long, String> statusMap = bills.parallelStream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getString("billstatus")));
        this.batchCancelSettle(e.getDataEntities(), this.redPayBillMap);
        ArrayList<DynamicObject> cancelCheckBills = new ArrayList<DynamicObject>();
        for (DynamicObject info : e.getDataEntities()) {
            String status = statusMap.get(info.getLong("id"));
            if (!BillStatusEnum.AUDIT.getValue().equals(status)) continue;
            cancelCheckBills.add(info);
        }
        Set srcBillNos = ((Stream)Arrays.stream(e.getDataEntities()).parallel()).map(d -> d.getString("billno")).collect(Collectors.toSet());
        if (ArrayUtils.isNotEmpty((Object[])this.srcPayBills)) {
            Set srcPayBillNos = ((Stream)Arrays.stream(this.srcPayBills).parallel()).map(d -> d.getString("billno")).collect(Collectors.toSet());
            srcBillNos.addAll(srcPayBillNos);
        }
        if (EmptyUtil.isNoEmpty(srcBillNos) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(arBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id", (QFilter[])(filters = new QFilter[]{new QFilter("sourcebillno", "in", srcBillNos)}))))) {
            Object[] arBillIds = (Long[])arBills.parallelStream().map(d -> d.getLong("id")).toArray(Long[]::new);
            OperateOption create = OperateOption.create();
            create.setVariableValue("app", "cas");
            OperateServiceHelper.execOperate((String)"delete", (String)"ar_finarbill", (Object[])arBillIds, (OperateOption)create);
        }
        if (EmptyUtil.isNoEmpty(cancelCheckBills)) {
            VoucherCheckHepler.batchoCancelCoucherCheck(cancelCheckBills);
        }
        OperateServiceHelper.execOperate((String)"delpurpay", (String)"cas_paybill", (DynamicObject[])e.getDataEntities(), (OperateOption)OperateOption.create());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        PaymentSaleServiceHelper.convertPur((DynamicObject[])e.getDataEntities(), (boolean)false);
        Map variables = this.getOption().getVariables();
        boolean isEmptyParams = EmptyUtil.isEmpty((Object)variables);
        boolean isNotReleaCancel = true;
        if (!isEmptyParams) {
            String isreleacancel = (String)variables.get("isreleacancel");
            isNotReleaCancel = EmptyUtil.isEmpty((String)isreleacancel) || !"y".equals(isreleacancel);
        }
        logger.info("is from isreleacancel");
        List<DynamicObject> recDyList = Arrays.stream(e.getDataEntities()).collect(Collectors.toList());
        if (isEmptyParams || isNotReleaCancel) {
            if (EmptyUtil.isNoEmpty(this.dealReleRecIdSet) && this.dealReleRecIdSet.size() > 0) {
                DynamicObject[] releaRecBillArr = BusinessDataServiceHelper.load((Object[])this.dealReleRecIdSet.toArray(), (DynamicObjectType)recDyList.get(0).getDynamicObjectType());
                recDyList.addAll(Arrays.stream(releaRecBillArr).collect(Collectors.toList()));
            }
            this.updateCancelCompleteDraftBill(recDyList);
        } else if (!isNotReleaCancel) {
            this.updatePayBillInfo(recDyList);
        }
    }

    private void updateCancelCompleteDraftBill(List<DynamicObject> payBills) {
        List resultList;
        HashSet<Long> allPayBillWhenPaySet = new HashSet<Long>();
        ArrayList<DraftLockInfo> lockDraftAmountLockInfos = new ArrayList<DraftLockInfo>(10);
        Map params = this.getOption().getVariables();
        boolean isFromDraw = StringUtils.isNotEmpty((CharSequence)((CharSequence)params.get("fromdraw")));
        boolean isFrompaydraft = StringUtils.isNotEmpty((CharSequence)((CharSequence)params.get("isfrompaydraft")));
        boolean isFrombilldelete = StringUtils.isNotEmpty((CharSequence)((CharSequence)params.get("isfrombilldelete")));
        logger.info("deal billlog start:isFromDraw:" + isFromDraw + ",isFrompaydraft:" + isFrompaydraft + ",isFrombilldelete:" + isFrombilldelete);
        HashMap needUpdatePayDraftBillMap = new HashMap(8);
        HashMap needUpdateRecDraftBillMap = new HashMap(8);
        for (DynamicObject payBill : payBills) {
            long paybillId;
            DynamicObject settleType = payBill.getDynamicObject("settletype");
            boolean isDraftSettleType = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            String sourcebilltype = payBill.getString("sourcebilltype");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            logger.info("isDraftSettleType\uff1a" + isDraftSettleType + ",checkDraft:" + checkDraft + ",isFromcdm:" + isFromcdm + ",isFrombilldelete :" + isFrombilldelete + ",billno is:" + payBill.getString("billno"));
            if (!isDraftSettleType && !checkDraft || isFromcdm || isFrombilldelete) {
                logger.info("is not draftType or is from cdm" + payBill.getString("billno"));
                continue;
            }
            Set<Object> needLockDraftIds = new HashSet(8);
            HashMap draftIdDealAmountMap = new HashMap(8);
            HashMap draftIdLogIdMap = new HashMap(8);
            Set<Object> logIds = new HashSet(8);
            DynamicObjectCollection draftInfoEntrys = payBill.getDynamicObjectCollection("cas_draftinfo");
            logger.info("\u6765\u6e90\u4e0b\u6e38\u4e1a\u52a1\u5904\u7406\u5355\u64cd\u4f5c\uff1a{}", (Object)isFromDraw);
            HashSet<String> rptypeSet = new HashSet<String>(8);
            if (isFromDraw) {
                boolean isGroupPay;
                if (EmptyUtil.isEmpty((DynamicObjectCollection)draftInfoEntrys)) {
                    HashSet draftBillSet = new HashSet();
                    DynamicObjectCollection newDrafts = payBill.getDynamicObjectCollection("draftbill");
                    boolean bl = isGroupPay = newDrafts.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> o.getDynamicObject("fbasedataid").getString("rptype")).distinct().count() > 1L;
                    if (!isGroupPay) {
                        logger.info("\u6765\u6e90\u4e0b\u6e38\u4e1a\u52a1\u5904\u7406\u5355\u64cd\u4f5c\uff1a\u5982\u786e\u8ba4\u5b8c\u6210\u7b49\uff0c\u5e76\u4e14\u975e\u7ec4\u5408\u4ed8\u6b3e\uff08\u7ec4\u5408\u4ed8\u6b3e\u5e94\u4ed8\u7968\u636e+\u5e94\u6536\u7968\u636e\uff09");
                        continue;
                    }
                    newDrafts.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).filter(o -> DraftBillUtils.isPayBill((String)o.getDynamicObject("fbasedataid").getString("rptype"))).forEach(o -> draftBillSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
                    DynamicObject[] draftArr = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", needLockDraftIds)});
                    draftIdDealAmountMap = Arrays.stream(draftArr).collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getBigDecimal("amount"), (o1, o2) -> o1, HashMap::new));
                    needLockDraftIds = draftBillSet;
                } else {
                    boolean bl = isGroupPay = draftInfoEntrys.stream().map(draft -> draft.getDynamicObject("draftbillinfo").getString("rptype")).distinct().count() > 1L;
                    if (!isGroupPay) {
                        logger.info("\u6765\u6e90\u4e0b\u6e38\u4e1a\u52a1\u5904\u7406\u5355\u64cd\u4f5c\uff1a\u5982\u786e\u8ba4\u5b8c\u6210\u7b49\uff0c\u5e76\u4e14\u975e\u7ec4\u5408\u4ed8\u6b3e\uff08\u7ec4\u5408\u4ed8\u6b3e\u5e94\u4ed8\u7968\u636e+\u5e94\u6536\u7968\u636e\uff09");
                        continue;
                    }
                    needLockDraftIds = draftInfoEntrys.stream().filter(this::isPayBill).map(v -> v.getDynamicObject("draftbillinfo").getLong("id")).collect(Collectors.toSet());
                    draftIdDealAmountMap = draftInfoEntrys.stream().filter(this::isPayBill).collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                    draftIdLogIdMap = draftInfoEntrys.stream().filter(this::isPayBill).collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                    logIds = draftInfoEntrys.stream().filter(this::isPayBill).map(o -> o.getLong("draftbilllogid")).collect(Collectors.toSet());
                }
            } else {
                if (EmptyUtil.isEmpty((DynamicObjectCollection)draftInfoEntrys)) {
                    HashSet draftBillSet = new HashSet();
                    DynamicObjectCollection newDrafts = payBill.getDynamicObjectCollection("draftbill");
                    newDrafts.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).forEach(o -> draftBillSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
                    DynamicObject[] draftArr = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", needLockDraftIds)});
                    draftIdDealAmountMap = Arrays.stream(draftArr).collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getBigDecimal("amount"), (o1, o2) -> o1, HashMap::new));
                    needLockDraftIds = draftBillSet;
                } else {
                    needLockDraftIds = draftInfoEntrys.stream().map(v -> v.getDynamicObject("draftbillinfo").getLong("id")).collect(Collectors.toSet());
                    draftIdDealAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                    draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                    logIds = draftInfoEntrys.stream().map(o -> o.getLong("draftbilllogid")).collect(Collectors.toSet());
                }
                DynamicObjectCollection payBillDrafts = payBill.getDynamicObjectCollection("draftbill");
                long casPayBillId = payBill.getLong("id");
                for (DynamicObject payBillDraft : payBillDrafts) {
                    HashSet<Long> draftBIllSet;
                    DynamicObject fbasedataid = payBillDraft.getDynamicObject("fbasedataid");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
                    String string = fbasedataid.getString("rptype");
                    rptypeSet.add(string);
                    long draftBillId = fbasedataid.getLong("id");
                    if ("paybill".equals(string)) {
                        if (needUpdatePayDraftBillMap.containsKey(casPayBillId)) {
                            ((Set)needUpdatePayDraftBillMap.get(casPayBillId)).add(draftBillId);
                            continue;
                        }
                        draftBIllSet = new HashSet<Long>(8);
                        draftBIllSet.add(draftBillId);
                        needUpdatePayDraftBillMap.put(casPayBillId, draftBIllSet);
                        continue;
                    }
                    if (needUpdateRecDraftBillMap.containsKey(casPayBillId)) {
                        ((Set)needUpdateRecDraftBillMap.get(casPayBillId)).add(draftBillId);
                        continue;
                    }
                    draftBIllSet = new HashSet(8);
                    draftBIllSet.add(draftBillId);
                    needUpdateRecDraftBillMap.put(casPayBillId, draftBIllSet);
                }
            }
            if (EmptyUtil.isNoEmpty(this.releatedEndorsedPayBillSet) && this.releatedEndorsedPayBillSet.size() > 0 && this.releatedEndorsedPayBillSet.contains(paybillId = payBill.getLong("id"))) continue;
            logger.info("needLockDraftIds\uff1a{}", needLockDraftIds);
            QFilter idQf = new QFilter("id", "in", logIds);
            DynamicObject[] draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus,draftid", (QFilter[])new QFilter[]{idQf});
            HashMap draftLogsMap = Arrays.stream(draftLogArr).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setSourceBillType(payBill.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(payBill.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(payBill.getLong("id")));
            ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long l : needLockDraftIds) {
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(l);
                BigDecimal dealAmount = draftIdDealAmountMap.get(l) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(l);
                draftAmountLockInfo.setDealAmount(dealAmount);
                Long billLogId = draftIdLogIdMap.get(l) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(l);
                draftAmountLockInfo.setBillLogId(billLogId);
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountLockInfo.setOperateType(LogOperateTypeEnum.CANCELCOMPLETE.getValue());
                DynamicObject draftLog = null;
                if (EmptyUtil.isNoEmpty((Long)billLogId) && billLogId > 0L) {
                    draftLog = (DynamicObject)draftLogsMap.get(billLogId);
                }
                if (draftLog != null && StringUtils.equals((CharSequence)draftLog.getString("bizstatus"), (CharSequence)"success")) {
                    draftAmountLockSubInfoList.add(draftAmountLockInfo);
                    continue;
                }
                if (!EmptyUtil.isNoEmpty(rptypeSet) || rptypeSet.size() != 1 || !rptypeSet.contains("paybill") || !EmptyUtil.isEmpty((Long)billLogId)) continue;
                draftAmountLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.RELATEDPAY.getValue());
                draftAmountLockInfo.setOperateType("");
                draftAmountLockSubInfoList.add(draftAmountLockInfo);
                allPayBillWhenPaySet.add(payBill.getLong("id"));
            }
            if (!EmptyUtil.isNoEmpty(draftAmountLockSubInfoList) || draftAmountLockSubInfoList.size() <= 0) continue;
            draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
            lockDraftAmountLockInfos.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(lockDraftAmountLockInfos) && EmptyUtil.isNoEmpty((Object)(resultList = this.draftLockServiceHelper.releaseOrLockDraft(lockDraftAmountLockInfos)))) {
            Map<Long, LockResult> payIdAndDyMap = resultList.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getSourceBillId()) && allPayBillWhenPaySet.contains(o.getSourceBillId())).collect(Collectors.toMap(LockResult::getSourceBillId, x -> x));
            List payList = payBills.stream().filter(e -> allPayBillWhenPaySet.contains(e.getLong("id"))).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(payIdAndDyMap) && payIdAndDyMap.size() > 0 && EmptyUtil.isNoEmpty((Object)payList) && payList.size() > 0) {
                HashSet<DynamicObject> needUpdateCasPayBillSet = new HashSet<DynamicObject>(8);
                Iterator checkDraft = payList.iterator();
                while (checkDraft.hasNext()) {
                    DynamicObject data = (DynamicObject)checkDraft.next();
                    long payApplyBillId = data.getLong("id");
                    LockResult lockResult = payIdAndDyMap.get(payApplyBillId);
                    DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
                    for (DynamicObject entry : entrys) {
                        Long draftBillId = entry.getDynamicObject("draftbillinfo").getLong("id");
                        if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                        Map billIdLogIdMap = lockResult.getBillIdLogIdMap();
                        boolean success = lockResult.isSuccess();
                        Long billLogId = (Long)billIdLogIdMap.get(draftBillId);
                        if (EmptyUtil.isNoEmpty((Long)billLogId) && success) {
                            entry.set("draftbilllogid", (Object)String.valueOf(billLogId));
                        }
                        needUpdateCasPayBillSet.add(data);
                    }
                }
                SaveServiceHelper.update((DynamicObject[])needUpdateCasPayBillSet.toArray(new DynamicObject[0]));
            }
        }
        if (!isFrompaydraft && !isFrombilldelete) {
            HashSet needUpdateDraftSetAll = new HashSet(8);
            HashSet needUpdateRecDraftSetAll = new HashSet(8);
            for (DynamicObject payBill : payBills) {
                String billType;
                Set needUpdateDySet;
                Long caeRecId;
                long payBillId = payBill.getLong("id");
                if (EmptyUtil.isNoEmpty(needUpdatePayDraftBillMap) && needUpdatePayDraftBillMap.size() > 0 && !isFrombilldelete) {
                    Set<Long> draftBillSet = (Set<Long>)needUpdatePayDraftBillMap.get(payBillId);
                    if ((EmptyUtil.isEmpty((Collection)draftBillSet) || draftBillSet.size() == 0) && EmptyUtil.isNoEmpty((Long)(caeRecId = this.releaIdAndPayIdMap.get(payBillId)))) {
                        draftBillSet = this.payIdAndDraftIdSetMap.get(caeRecId);
                    }
                    if (EmptyUtil.isNoEmpty((Object)draftBillSet) && draftBillSet.size() > 0 && EmptyUtil.isNoEmpty((Object)(needUpdateDySet = DraftHelper.updateDraftCasEntry((DynamicObject)payBill, draftBillSet, (String)(billType = "cdm_payablebill"), (String)"delete", (String)"")))) {
                        needUpdateDraftSetAll.addAll(needUpdateDySet);
                    }
                }
                if (!EmptyUtil.isNoEmpty(needUpdateRecDraftBillMap) || needUpdateRecDraftBillMap.size() <= 0 || isFrombilldelete) continue;
                Set<Long> draftRecBillSet = (Set<Long>)needUpdateRecDraftBillMap.get(payBillId);
                if ((EmptyUtil.isEmpty((Collection)draftRecBillSet) || draftRecBillSet.size() == 0) && EmptyUtil.isNoEmpty((Long)(caeRecId = this.releaIdAndPayIdMap.get(payBillId)))) {
                    draftRecBillSet = this.payIdAndDraftIdSetMap.get(caeRecId);
                }
                if (!EmptyUtil.isNoEmpty((Object)draftRecBillSet) || draftRecBillSet.size() <= 0 || !EmptyUtil.isNoEmpty((Object)(needUpdateDySet = DraftHelper.updateDraftCasEntry((DynamicObject)payBill, draftRecBillSet, (String)(billType = "cdm_receivablebill"), (String)"delete", (String)"")))) continue;
                needUpdateRecDraftSetAll.addAll(needUpdateDySet);
            }
            if (EmptyUtil.isNoEmpty(needUpdateDraftSetAll) || EmptyUtil.isNoEmpty(needUpdateRecDraftSetAll)) {
                try (TXHandle tx = TX.requiresNew();){
                    if (EmptyUtil.isNoEmpty(needUpdateDraftSetAll)) {
                        SaveServiceHelper.save((DynamicObject[])needUpdateDraftSetAll.toArray(new DynamicObject[0]));
                    }
                    if (EmptyUtil.isNoEmpty(needUpdateRecDraftSetAll)) {
                        SaveServiceHelper.save((DynamicObject[])needUpdateRecDraftSetAll.toArray(new DynamicObject[0]));
                    }
                }
                catch (Exception error) {
                    logger.error("update bill cas entry has error", (Throwable)error);
                }
            }
        }
        this.updatePayBillInfo(payBills);
        logger.info("deal billlog end");
    }

    private void updatePayBillInfo(List<DynamicObject> payBills) {
        if (EmptyUtil.isNoEmpty(this.releatedEndorsedPayBillSet) && this.releatedEndorsedPayBillSet.size() > 0) {
            HashSet<DynamicObject> needUpatePayDataSet = new HashSet<DynamicObject>(8);
            for (DynamicObject payBill : payBills) {
                long casPayBillId = payBill.getLong("id");
                if (!this.releatedEndorsedPayBillSet.contains(casPayBillId)) continue;
                payBill.set("draftbill", null);
                payBill.set("settletnumber", null);
                DynamicObjectCollection cas_draftinfo = payBill.getDynamicObjectCollection("cas_draftinfo");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_draftinfo)) {
                    cas_draftinfo.clear();
                }
                needUpatePayDataSet.add(payBill);
            }
            if (EmptyUtil.isNoEmpty(needUpatePayDataSet) && needUpatePayDataSet.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])needUpatePayDataSet.toArray(new DynamicObject[0]));
            }
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.draftLockServiceHelper.rollback();
    }

    private boolean isPayBill(DynamicObject draft) {
        return DraftBillUtils.isPayBill((String)draft.getDynamicObject("draftbillinfo").getString("rptype"));
    }

    private void batchCancelSettle(DynamicObject[] bills, Map<Long, DynamicObject> redPayBillMap) {
        Set<Long> payIds = redPayBillMap.keySet();
        if (EmptyUtil.isNoEmpty(payIds)) {
            for (DynamicObject bill : bills) {
                long id = bill.getLong("id");
                DynamicObject redPaybill = redPayBillMap.get(id);
                if (!EmptyUtil.isNoEmpty((DynamicObject)redPaybill)) continue;
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"payself", (String)"autoSettle", (Object[])new Object[]{new DynamicObject[]{bill}, new DynamicObject[]{redPaybill}});
                        String message = SerializationUtils.toJsonString((Object)result);
                        logger.info("payBill autoSettle result:" + message);
                    }
                    catch (Exception exc) {
                        tx.markRollback();
                        logger.error("payBill autoSettle error:", (Throwable)exc);
                    }
                }
            }
        }
    }

    private boolean isFromCdm() {
        Map paramMap = this.getOption().getVariables();
        if (paramMap.containsKey("isfrombill") && EmptyUtil.isNoEmpty((String)((String)paramMap.get("isfrombill"))) && "y".equalsIgnoreCase((String)paramMap.get("isfrombill"))) {
            logger.info("is from bill");
            return true;
        }
        logger.info("is not from bill");
        return false;
    }

    private void batchCancelPayProcess(DynamicObject[] paybills) {
        QFilter[] feeFilter;
        DynamicObjectCollection feePayBills;
        Set feeIds;
        boolean fromCdm = this.isFromCdm();
        String invalidcdm = (String)this.getOption().getVariables().get("invalidcdm");
        HashSet<Long> delRecIds = new HashSet<Long>();
        HashSet delCdmPayIds = new HashSet();
        HashSet<Long> delCdmTransIds = new HashSet<Long>();
        ArrayList<Long> cancelBookIds = new ArrayList<Long>();
        ArrayList<DynamicObject> upBills = new ArrayList<DynamicObject>();
        for (DynamicObject paybill : paybills) {
            Set<Long> cdmTransIds;
            Object draftIds;
            QFilter[] cdmFilters;
            DynamicObjectCollection draftbills;
            Set<Long> cdmPayIds;
            Set<Long> otherRecBillIdSet;
            Long id = paybill.getLong("id");
            if (EmptyUtil.isNoEmpty(this.recIdAndReleaIdMap) && this.recIdAndReleaIdMap.size() > 0 && EmptyUtil.isNoEmpty(otherRecBillIdSet = this.recIdAndReleaIdMap.get(id)) && otherRecBillIdSet.size() > 0) {
                OperateOption create = OperateOption.create();
                Map variables = this.getOption().getVariables();
                if (EmptyUtil.isNoEmpty((Object)variables)) {
                    create.getVariables().putAll(variables);
                }
                create.setVariableValue("isreleacancel", "y");
                OperateServiceHelper.execOperate((String)"cancelpay", (String)"cas_paybill", (Object[])otherRecBillIdSet.toArray(), (OperateOption)create);
            }
            String newStatus = fromCdm ? BillStatusEnum.DRAFTING.getValue() : BillStatusEnum.AUDIT.getValue();
            paybill.set("billstatus", (Object)newStatus);
            paybill.set("cashier", null);
            paybill.set("paydate", null);
            Set<Long> recIds = this.payRecMap.get(id);
            if (EmptyUtil.isNoEmpty(recIds)) {
                delRecIds.addAll(recIds);
            }
            if (EmptyUtil.isNoEmpty(cdmPayIds = this.payCdmPayMap.get(id)) && !fromCdm && EmptyUtil.isNoEmpty((DynamicObjectCollection)(draftbills = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id", (QFilter[])(cdmFilters = new QFilter[]{new QFilter("id", "in", cdmPayIds), new QFilter("source", "=", (Object)"cas")}))))) {
                paybill.set("draftbill", (Object)PaymentCancelPayOp.generateMultiPropValue());
                DynamicObjectCollection draftInfoEntries = paybill.getDynamicObjectCollection("cas_draftinfo");
                draftInfoEntries.removeIf(draftInfo -> cdmPayIds.contains(draftInfo.getDynamicObject("draftbillinfo").getLong("id")));
                draftIds = draftbills.parallelStream().map(d -> d.getLong("id")).collect(Collectors.toSet());
                delCdmPayIds.addAll(draftIds);
            }
            if (EmptyUtil.isNoEmpty(cdmTransIds = this.payCdmTransMap.get(id)) && !fromCdm) {
                DynamicObjectCollection draftTradeBillColl = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id,sourcebillid,source", (QFilter[])new QFilter[]{new QFilter("id", "in", cdmTransIds), new QFilter("source", "=", (Object)"cas"), new QFilter("sourcebillid", "=", (Object)id)});
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftTradeBillColl) && draftTradeBillColl.size() > 0) {
                    delCdmTransIds.addAll(cdmTransIds);
                } else {
                    Set<Long> releaPayIdSet;
                    TXHandle h = TX.requiresNew();
                    draftIds = null;
                    try {
                        CasBotpHelper.deleteRation((DBRoute)DBRouteConst.TMC, (String)"cdm_drafttradebill", (Long[])new Long[0], (Long)paybill.getLong("id"));
                    }
                    catch (Throwable throwable) {
                        draftIds = throwable;
                        throw throwable;
                    }
                    finally {
                        if (h != null) {
                            if (draftIds != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)draftIds).addSuppressed(throwable);
                                }
                            } else {
                                h.close();
                            }
                        }
                    }
                    this.releatedEndorsedPayBillSet.add(id);
                    this.clearDraftPayIdSet.add(id);
                    if (EmptyUtil.isNoEmpty(this.recIdAndReleaIdMap) && this.recIdAndReleaIdMap.size() > 0 && EmptyUtil.isNoEmpty(releaPayIdSet = this.recIdAndReleaIdMap.get(id)) && releaPayIdSet.size() > 0) {
                        this.releatedEndorsedPayBillSet.addAll(releaPayIdSet);
                        this.clearDraftPayIdSet.addAll(releaPayIdSet);
                    }
                }
            }
            DynamicObject settleType = paybill.getDynamicObject("settletype");
            boolean isDraftSettleType = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            boolean promDraft = BaseDataHelper.isSettleTypeProm((DynamicObject)settleType);
            if (isDraftSettleType || checkDraft || promDraft) {
                DynamicObjectCollection cas_draftinfos = paybill.getDynamicObjectCollection("cas_draftinfo");
                for (DynamicObject cas_draftinfo : cas_draftinfos) {
                    DynamicObject draftBill = cas_draftinfo.getDynamicObject("draftbillinfo");
                    String rptype = draftBill.getString("rptype");
                    long draftbilllogid = cas_draftinfo.getLong("draftbilllogid");
                    if (!"paybill".equals(rptype) || !EmptyUtil.isEmpty((Long)draftbilllogid)) continue;
                    this.releatedEndorsedPayBillSet.add(id);
                    this.clearDraftPayIdSet.add(id);
                }
            }
            if (CasHelper.isEmpty((Object)paybill.get("entrustorg"))) {
                cancelBookIds.add(id);
            }
            if (!EmptyUtil.isNoEmpty((String)paybill.getString("sourcebilltype"))) continue;
            upBills.add(paybill);
        }
        if (delRecIds.size() > 0) {
            OperateServiceHelper.execOperate((String)"delete", (String)"cas_recbill", (Object[])delRecIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        }
        if (delCdmPayIds.size() > 0) {
            OperateOption delOp = OperateOption.create();
            if (Objects.nonNull(invalidcdm)) {
                delOp.setVariableValue("invalidcdm", "invalidcdm");
            }
            OperateServiceHelper.execOperate((String)"casdel", (String)"cdm_payablebill", (Object[])delCdmPayIds.toArray(new Long[0]), (OperateOption)delOp, (boolean)true);
        }
        if (delCdmTransIds.size() > 0) {
            OperateServiceHelper.execOperate((String)"casdel", (String)"cdm_drafttradebill", (Object[])delCdmTransIds.toArray(new Long[0]), (OperateOption)OperateOption.create(), (boolean)true);
        }
        if (cancelBookIds.size() > 0) {
            this.journalServiceAdapter.cancelBooks(cancelBookIds);
        }
        if (EmptyUtil.isNoEmpty(feeIds = Arrays.stream(paybills).filter(d -> d.getBoolean("singlestream")).map(d -> d.getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(feePayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])(feeFilter = new QFilter[]{new QFilter("sourcebillid", "in", feeIds), new QFilter("sourcebilltype", "=", (Object)"cas_paybill"), new QFilter("feepay", "=", (Object)true)}))))) {
            Object[] delFeeIds = (Long[])feePayBills.parallelStream().map(d -> d.getLong("id")).toArray(Long[]::new);
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("feepaydelete", "1");
            OperationResult result = OperateServiceHelper.execOperate((String)"delete", (String)"cas_paybill", (Object[])delFeeIds, (OperateOption)operate);
            if (!result.isSuccess()) {
                List allErrorInfo = this.operationResult.getAllErrorInfo();
                allErrorInfo.addAll(result.getAllErrorInfo());
                this.operationResult.setAllErrorInfo(allErrorInfo);
            }
        }
        SaveServiceHelper.save((DynamicObject[])paybills);
        if (EmptyUtil.isNoEmpty(upBills)) {
            ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(upBills.size());
            for (DynamicObject upbill : upBills) {
                WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
                taskInfo.setBillId((Long)upbill.getPkValue());
                taskInfo.setDataEntity(upbill.getDataEntityType().getName());
                taskInfo.setSourceEntity(upbill.getString("sourcebilltype"));
                HashMap<String, Set<Long>> param = new HashMap<String, Set<Long>>(8);
                param.put("clearDraftPayIdSet", this.clearDraftPayIdSet);
                taskInfo.setParam(param);
                taskInfos.add(taskInfo);
            }
            WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.CANCELPAY, PaymentDisposeConsumer.class);
        }
    }

    private void dealFeePayBills(DynamicObject[] paybills) {
        Set feeIds = Arrays.stream(paybills).filter(d -> d.getBoolean("singlestream")).map(d -> d.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(feeIds)) {
            return;
        }
        QFilter[] feeFilter = new QFilter[]{new QFilter("sourcebillid", "in", feeIds), new QFilter("sourcebilltype", "=", (Object)"cas_paybill"), new QFilter("feepay", "=", (Object)true)};
        DynamicObjectCollection feePayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus,sourcebillid", (QFilter[])feeFilter);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)feePayBills)) {
            Map<String, Set<Object>> billStatusIdMap = feePayBills.stream().collect(Collectors.groupingBy(s -> s.getString("billstatus"), Collectors.mapping(s -> s.get("id"), Collectors.toSet())));
            ArrayList<OperateErrorInfo> allErrorInfo = new ArrayList<OperateErrorInfo>(feePayBills.size());
            allErrorInfo.addAll(this.execFeePayOperate(billStatusIdMap, "cancelpay", BillStatusEnum.PAY.getValue(), BillStatusEnum.AUDIT.getValue()));
            allErrorInfo.addAll(this.execFeePayOperate(billStatusIdMap, "unaudit", BillStatusEnum.AUDIT.getValue(), BillStatusEnum.SAVE.getValue()));
            allErrorInfo.addAll(this.execFeePayOperate(billStatusIdMap, "unsubmit", BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.SAVE.getValue()));
            if (EmptyUtil.isNoEmpty(allErrorInfo)) {
                allErrorInfo.addAll(this.operationResult.getAllErrorInfo());
                this.operationResult.setAllErrorInfo(allErrorInfo);
            }
        }
    }

    private List<OperateErrorInfo> execFeePayOperate(Map<String, Set<Object>> billStatusIdMap, String opKey, String thisStatus, String nextStatus) {
        Set<Object> ids;
        List<Object> thisErrorInfo = new ArrayList<OperateErrorInfo>(10);
        if (billStatusIdMap.containsKey(thisStatus) && EmptyUtil.isNoEmpty(ids = billStatusIdMap.get(thisStatus))) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    OperateOption operate = OperateOption.create();
                    operate.setVariableValue("islock", "true");
                    OperationResult result = OperateServiceHelper.execOperate((String)opKey, (String)"cas_paybill", (Object[])ids.toArray(), (OperateOption)operate);
                    if (!billStatusIdMap.containsKey(nextStatus)) {
                        billStatusIdMap.put(nextStatus, new HashSet());
                    }
                    if (result.isSuccess()) {
                        billStatusIdMap.get(nextStatus).addAll(ids);
                    } else {
                        billStatusIdMap.get(nextStatus).addAll(result.getSuccessPkIds());
                        thisErrorInfo = result.getAllErrorInfo();
                    }
                }
                catch (Exception e) {
                    logger.error("execFeePayOperate:" + e);
                    tx.markRollback();
                    throw e;
                }
            }
        }
        return thisErrorInfo;
    }

    private void batchCancelSrcPayProcess(DynamicObject[] srcPayBills) {
        boolean isInvalidcdm;
        if (CasHelper.isEmpty((DynamicObject[])srcPayBills)) {
            return;
        }
        boolean isfromCdm = this.isFromCdm();
        String isfromCdmValue = null;
        isfromCdmValue = isfromCdm ? "y" : "n";
        OperateOption create = OperateOption.create();
        create.setVariableValue("isfrombill", isfromCdmValue);
        Map paramMap = this.getOption().getVariables();
        boolean isFrombilldelete = StringUtils.isNotEmpty((CharSequence)((CharSequence)paramMap.get("isfrombilldelete")));
        if (isFrombilldelete) {
            create.setVariableValue("isfrombilldelete", "y");
        }
        if (isInvalidcdm = StringUtils.isNotEmpty((CharSequence)((CharSequence)paramMap.get("invalidcdm")))) {
            create.setVariableValue("invalidcdm", "invalidcdm");
        }
        create.setVariableValue("app", "cas");
        OperateServiceHelper.execOperate((String)"cancelpay", (String)"cas_paybill", (DynamicObject[])srcPayBills, (OperateOption)create);
    }

    public static DynamicObjectCollection generateMultiPropValue() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_paybill");
        DynamicCollectionProperty prop = (DynamicCollectionProperty)entityType.getProperty("draftbill");
        DynamicObjectCollection collection = new DynamicObjectCollection(prop.getDynamicCollectionItemPropertyType(), (Object)"cas_paybill");
        return collection;
    }
}

