/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.validator.AgentPaymentChargeBackValidator;

public class PaymentChargeBackWriteOp
extends AbstractOperationServicePlugIn {
    private String operate = "op_chargebackwrite";
    private DynamicObject backPayMent;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AgentPaymentChargeBackValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebilltype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String billid = this.getOption().getVariableValue("billid");
        String reason = this.getOption().getVariableValue("reason");
        String entityName = this.getOption().getVariableValue("entityname");
        ArrayList requestIds = new ArrayList();
        MutexServiceHelper.batchRequest(Collections.singletonList(billid), (String)entityName, (String)this.operate);
        try {
            this.chargeBackWrite(billid, reason, entityName);
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)entityName, (String)this.operate);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.backPayMent != null && "cas_agentpaybill".equals(this.backPayMent.getDataEntityType().getName())) {
            OperateServiceHelper.execOperate((String)"synctrigger", (String)this.backPayMent.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{this.backPayMent}, (OperateOption)OperateOption.create());
        }
    }

    public void chargeBackWrite(String billid, String reason, String entityName) {
        if (CasHelper.isEmpty((Object)billid)) {
            return;
        }
        DynamicObject billMent = this.sourceBillSave(billid, entityName, reason);
        String billStatus = billMent.getString("billstatus");
        OperateOption create = OperateOption.create();
        create.setVariableValue("ishasright", "true");
        if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            OperateServiceHelper.execOperate((String)"unsubmit", (String)billMent.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{billMent}, (OperateOption)create);
        } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            OperateServiceHelper.execOperate((String)"unaudit", (String)billMent.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{billMent}, (OperateOption)create);
        }
        if ("cas_agentpaybill".equals(entityName)) {
            DynamicObjectCollection entrys = billMent.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                entry.set("e_issuccess", (Object)false);
            }
        }
        billMent.set("billstatus", (Object)BillStatusEnum.CHARGEBANK.getValue());
        OperateServiceHelper.execOperate((String)"chargebacksave", (String)billMent.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{billMent}, (OperateOption)create);
        this.doDelOp(billMent);
    }

    private void doDelOp(DynamicObject info) {
        if ("cas_agentpaybill".equals(info.getDataEntityType().getName())) {
            String sourceBillType = info.getString("sourcebilltype");
            if (!CasHelper.isEmpty((Object)sourceBillType)) {
                ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(10);
                bills.add(info);
                if ("hsas_agencypaybill".equalsIgnoreCase(sourceBillType)) {
                    WriteBackServiceImpl.getInstance().batchWrite(bills, WriteBackOperateEnum.REBACK, AgentWriteBackConsumer.class);
                } else {
                    WriteBackServiceImpl.getInstance().batchWrite(bills, WriteBackOperateEnum.CHARGEBACK, AgentWriteBackConsumer.class);
                }
            }
            this.updateEntrustSourceAgentBill(info);
        }
    }

    private void updateEntrustSourceAgentBill(DynamicObject targetBill) {
        String sourceBillNo;
        QFilter qFilter;
        DynamicObject entrustSourceBill;
        if ("repay".equals(targetBill.getString("sourcebilltype")) && targetBill.get("applyorg") != null && (entrustSourceBill = BusinessDataServiceHelper.loadSingle((String)"cas_agentpaybill", (String)"id,reason,dpamt,entrustamt", (QFilter[])(qFilter = new QFilter("billno", "=", (Object)(sourceBillNo = targetBill.getString("sourcebillnumber")))).toArray())) != null) {
            String backReason = targetBill.getString("reason");
            String reasonFmt = ResManager.loadKDString((String)"[%1$s]\u53d1\u751f\u9000\u5355\uff1a%2$s", (String)"PaymentChargeBackWriteOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            String newReason = String.format(reasonFmt, targetBill.getString("billno"), backReason);
            entrustSourceBill.set("reason", (Object)StringUtils.substring((String)newReason, (int)0, (int)255));
            entrustSourceBill.set("entrustamt", (Object)BigDecimal.ZERO);
            SaveServiceHelper.update((DynamicObject)entrustSourceBill);
        }
    }

    public DynamicObject sourceBillSave(String billid, String entityName, String reason) {
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)entityName);
        sourceBill.set("reason", (Object)reason);
        sourceBill.set("backuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
        sourceBill.set("backdate", (Object)new Date());
        this.backPayMent = sourceBill;
        return sourceBill;
    }
}

