/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.helper.RecClaimBillHelper;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntrustHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.PayBillWriteValidator;
import kd.fi.cas.validator.PaymentBillDeleteValidator;
import kd.fi.cas.validator.common.TxLockValidator;

public class PaymentDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PaymentDeleteOp.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        try {
            DynamicObject[] payBills = e.getDataEntities();
            Object[] sourceIds = (Long[])((Stream)Arrays.stream(payBills).parallel()).filter(bill -> Objects.nonNull(bill.getDynamicObject("paymenttype")) && bill.getDynamicObject("paymenttype").getBoolean("ispartpayment") && HotAccountEnum.HOTBILL.getValue().equals(bill.getString("hotaccount"))).map(bill -> bill.getLong("sourcebillid")).toArray(Long[]::new);
            if (!CasHelper.isEmpty((Object)sourceIds)) {
                DynamicObject[] sourceBills;
                for (DynamicObject bill2 : sourceBills = BusinessDataServiceHelper.load((Object[])sourceIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_payapplybill"))) {
                    WriteBackTaskHelper.addRealtimeTask((DynamicObject)bill2, (String)"ap_settle", (WriteBackOperateEnum)WriteBackOperateEnum.CANCELPAY, PaymentDisposeConsumer.class);
                }
            }
            Map<Long, Long> payAndFeeBillMap = Arrays.stream(payBills).filter(dynamicObject -> dynamicObject.getString("sourcebilltype").equals("cfm_feebill")).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("sourcebillid")));
            PaymentDeleteOp.updateFeeBillsByPayBills(payAndFeeBillMap);
            DynamicObject[] applyPayBills = (DynamicObject[])Arrays.stream(payBills).filter(dy -> "ap_payapply".equals(dy.getString("sourcebilltype"))).toArray(DynamicObject[]::new);
            if (applyPayBills.length > 0) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ApPayApplyCloseService", (String)"disposePayApplySrcBill", (Object[])new Object[]{applyPayBills});
            }
        }
        catch (Exception ee) {
            logger.error((Throwable)ee);
        }
    }

    private static void updateFeeBillsByPayBills(Map<Long, Long> payAndFeeBillMap) {
        if (EmptyUtil.isNoEmpty(payAndFeeBillMap)) {
            QFilter payFilter = new QFilter("id", "not in", payAndFeeBillMap.keySet()).and("sourcebillid", "in", payAndFeeBillMap.values());
            DynamicObjectCollection latestPayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,sourcebillid,createtime", (QFilter[])payFilter.toArray());
            Map<Long, List> latestPayBillMap = latestPayBills.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("sourcebillid"), Collectors.collectingAndThen(Collectors.toList(), groups -> groups.stream().sorted(Comparator.comparing(pay -> ((DynamicObject)pay).getDate("createtime")).reversed()).collect(Collectors.toList()))));
            QFilter feeFilter = new QFilter("id", "in", payAndFeeBillMap.values());
            DynamicObject[] feeBills = BusinessDataServiceHelper.load((String)"cfm_feebill", (String)"id, paybill", (QFilter[])feeFilter.toArray());
            ArrayList<DynamicObject> updateFeeBills = new ArrayList<DynamicObject>(feeBills.length);
            for (DynamicObject feeBill : feeBills) {
                long feeBillLong = feeBill.getLong("id");
                List pays = latestPayBillMap.get(feeBillLong);
                if (!EmptyUtil.isNoEmpty((Object)pays)) continue;
                feeBill.set("paybill", (Object)((DynamicObject)pays.get(0)).getLong("id"));
                updateFeeBills.add(feeBill);
            }
            if (EmptyUtil.isEmpty(updateFeeBills)) {
                return;
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])updateFeeBills.toArray(new DynamicObject[0]));
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            this.doProcess_PaymentDeleteImpl(info);
        }
        List<DynamicObject> list = Arrays.stream(e.getDataEntities()).filter(o -> "cas_claimcenterbill".equals(o.getString("sourcebilltype"))).collect(Collectors.toList());
        if (!list.isEmpty()) {
            List<String> strings = list.stream().map(s -> s.getString("sourcebillid")).collect(Collectors.toList());
            RecClaimBillHelper.writeBackByClaimBatch((DynamicObject[])list.toArray(new DynamicObject[list.size()]), (Boolean)false);
            RecClaimBillHelper.claimCancelAccount((String[])strings.toArray(new String[list.size()]), (String)"cas_claimcenterbill", (String[])new String[0]);
        }
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(10);
        for (DynamicObject info : e.getDataEntities()) {
            if ("cas_payapplybill".equals(info.getString("sourcebilltype"))) {
                PayBillHepler.payApplyBillWriteBackArrival((DynamicObject)info, (WriteBackOperateEnum)WriteBackOperateEnum.DELETE, PaymentDisposeConsumer.class);
            } else {
                bills.add(info);
            }
            EntrustHelper.delEntrustRelation((Long)((Long)info.getPkValue()), (String)"cas_paybill");
        }
        WriteBackServiceImpl.getInstance().batchWrite(bills, WriteBackOperateEnum.DELETE, PaymentDisposeConsumer.class);
        PayBillHepler.writeBackLetterCredit((String)"delete", (boolean)true, (OperateOption)this.getOption(), (DynamicObject[])e.getDataEntities());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PaymentBillDeleteValidator());
        e.getValidators().add(new TxLockValidator());
        e.addValidator((AbstractValidator)new PayBillWriteValidator(WriteBackOperateEnum.DELETEVALIDATE));
    }

    private void doProcess_PaymentDeleteImpl(DynamicObject info) {
        Map param = this.getOption().getVariables();
        String sourceBillType = info.getString("sourcebilltype");
        Object ignoreValidator = param.get("cdm_drafttradebill_ignore");
        Object dealbypsdValidator = param.get("dealbypsd");
        if (ignoreValidator == null && "cdm_drafttradebill".equals(sourceBillType)) {
            Long draftTradeBillId = info.getLong("sourcebillid");
            HashSet<Long> draftTradeBillIdSet = new HashSet<Long>();
            draftTradeBillIdSet.add(draftTradeBillId);
            PayBillHepler.callCancleDraw(draftTradeBillIdSet, (dealbypsdValidator != null && "y".equals(dealbypsdValidator.toString()) ? 1 : 0) != 0);
            param.put("isdelbydraft", "1");
            param.put("cdm_drafttradebill_ignore", "1");
        }
        String hotAccount = info.getString("hotaccount");
        if (HotAccountEnum.HOTBILL.getValue().equals(hotAccount)) {
            RecBillHepler.checkJournal((DynamicObject)info);
            return;
        }
        DynamicObjectCollection draftbillColl = info.getDynamicObjectCollection("draftbill");
        BigDecimal actpayamt = info.getBigDecimal("actpayamt");
        if (draftbillColl.size() > 0) {
            List draftBillIds = draftbillColl.stream().filter(v -> v.getDynamicObject("fbasedataid") != null).map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            BigDecimal amount = BigDecimal.ZERO;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryDraftBill", (String)"cdm_draftbillf7", (String)"amount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)}, null);){
                for (Row row : ds) {
                    amount = amount.add(row.getBigDecimal("amount"));
                }
            }
            if (actpayamt.compareTo(amount) < 0) {
                CasBotpHelper.deleteRation((Object)info.getPkValue(), (String[])new String[]{"cas_recbill"});
            }
        }
        if ("cas_payapplybill".equals(sourceBillType) || "cas_transferapply".equals(sourceBillType) || "lc_arrival".equals(sourceBillType) || "tm_businessbill".equals(sourceBillType) || "fr_glreim_paybill".equals(sourceBillType)) {
            HashMap paramMap = new HashMap(4);
            if (param.containsKey("isPayScheBack")) {
                paramMap.put("isPayScheBack", param.get("isPayScheBack"));
                paramMap.put("payScheOPType", param.get("payScheOPType"));
                paramMap.put("payScheRelease", param.get("payScheRelease"));
                paramMap.put("delPayApplyBillIds", param.get("delPayApplyBillIds"));
            }
            WriteBackTaskHelper.addRealtimeTask((DynamicObject)info, (String)info.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.DELETE, PaymentDisposeConsumer.class, paramMap);
        }
    }
}

