/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.helper.AutoMatchHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.PaymentFillPropHelper;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.business.opservice.impl.BillPropertyValueHandle;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.PaymentSaveOrSubmitWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.PayAndRecFillTypeHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.AccountFreezeSubmitValidator;
import kd.fi.cas.validator.MainTransferValidator;
import kd.fi.cas.validator.OrgFinishinitValidator;
import kd.fi.cas.validator.PayBillWriteValidator;
import kd.fi.cas.validator.PaymentBeforeSubmitValidator;
import kd.fi.cas.validator.PaymentBeiValidator;
import kd.fi.cas.validator.PaymentBillEndorseSaveValidator;
import kd.fi.cas.validator.PaymentBillIsFreezeValidator;
import kd.fi.cas.validator.PaymentBillSubmitValidator;
import kd.fi.cas.validator.PaymentCashSubmitValidator;
import kd.fi.cas.validator.PaymentCrossSubmitValidator;
import kd.fi.cas.validator.PaymentDynamicValidator;
import kd.fi.cas.validator.PaymentSynSaveValidator;
import kd.fi.cas.validator.QuotationOpPayOrAgentValidator;
import kd.fi.cas.validator.common.TxLockValidator;
import kd.fi.cas.validator.pay.PayAccountCashValidator;
import kd.fi.cas.validator.pay.PayBillScmcValidator;
import kd.fi.cas.validator.pay.PaymentDcepSubmitValidator;
import kd.fi.cas.validator.paymentbill.PaymentCrossTranValidator;
import kd.fi.cas.validator.paymentbill.PaymentDiffPayEmptyValidator;
import kd.fi.cas.validator.paymentbill.PaymentLCOpenValidator;
import kd.fi.cas.validator.paymentbill.PaymentSaveValidator;
import kd.fi.cas.validator.paymentbill.PaymentTypeValidator;

public class PaymentSubmitOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PaymentSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        PaymentServiceHelper.addFieldKeys((List)e.getFieldKeys());
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("totalrefundedamt");
        fieldKeys.add("totalremainrefundamt");
        fieldKeys.add("localrefundedamt");
        fieldKeys.add("localremainrefundamt");
        fieldKeys.add("payquotation");
        fieldKeys.add("exchangerate");
        fieldKeys.add("entry.e_encryptamount");
        fieldKeys.add("entry.e_refundamt");
        fieldKeys.add("entry.e_remainrefundamt");
        fieldKeys.add("entry.e_dpamt");
        fieldKeys.add("auditparam");
        fieldKeys.add("iscrosspay");
        fieldKeys.add("payeetype");
        fieldKeys.add("declaretype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AccountFreezeSubmitValidator());
        e.addValidator((AbstractValidator)new PaymentBeforeSubmitValidator());
        e.addValidator((AbstractValidator)new PaymentLCOpenValidator());
        e.getValidators().add(new PaymentDiffPayEmptyValidator());
        e.addValidator((AbstractValidator)new PaymentSaveValidator());
        e.addValidator((AbstractValidator)new PaymentBillSubmitValidator());
        e.addValidator((AbstractValidator)new PaymentBillEndorseSaveValidator());
        e.addValidator((AbstractValidator)new PaymentCrossTranValidator());
        e.getValidators().add(new PaymentDynamicValidator());
        e.getValidators().add(new PaymentCrossSubmitValidator());
        e.getValidators().add(new PaymentCashSubmitValidator());
        e.getValidators().add(new PaymentSynSaveValidator());
        e.getValidators().add(new OrgFinishinitValidator());
        e.getValidators().add(new PaymentBeiValidator());
        e.getValidators().add(new QuotationOpPayOrAgentValidator());
        e.getValidators().add(new PaymentTypeValidator());
        e.addValidator((AbstractValidator)new PaymentBillIsFreezeValidator());
        e.addValidator((AbstractValidator)new PayBillWriteValidator(WriteBackOperateEnum.SUBMITVALIDATE));
        e.getValidators().add(new TxLockValidator());
        e.getValidators().add(new MainTransferValidator());
        e.getValidators().add(new PaymentDcepSubmitValidator());
        e.getValidators().add(new PayAccountCashValidator());
        e.getValidators().add(new PayBillScmcValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] payBills;
        super.beforeExecuteOperationTransaction(e);
        RefundHelper.setSomeRefundAmtFields((DynamicObject[])e.getDataEntities(), (String)"cas_paybill");
        for (DynamicObject payBill : payBills = e.getDataEntities()) {
            PaymentPayHelper.updateEntryDpAmt((DynamicObject)payBill);
            String payType = payBill.getString("payeetype");
            if (!"bd_supplier".equalsIgnoreCase(payType)) continue;
            PaymentPayHelper.updateAuditParam((DynamicObject)payBill);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<String, List<DynamicObject>> dataGroup = ((Stream)Arrays.stream(dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((String)d.getString("sourcebilltype"))).collect(Collectors.groupingBy(d -> d.getString("sourcebilltype")));
        Arrays.stream(dataEntities).forEach(paybill -> this.commonProcess((DynamicObject)paybill));
        for (DynamicObject info : dataEntities) {
            PayAndRecFillTypeHelper.fillpayMentBillEntryType((DynamicObject)info);
        }
        PaymentFillPropHelper.setDefaultProvinceAndCity((DynamicObject[])dataEntities);
        if (EmptyUtil.isNoEmpty(dataGroup)) {
            for (Map.Entry entry : dataGroup.entrySet()) {
                this.specialProcess((String)entry.getKey(), (List)entry.getValue());
            }
        }
        PayBillHepler.writeBackLetterCredit((String)"submit", (boolean)true, (OperateOption)this.getOption(), (DynamicObject[])dataEntities);
        PayBillHepler.writeBackArrival((OperateOption)this.getOption(), (DynamicObject[])dataEntities);
    }

    private void commonProcess(DynamicObject payBill) {
        String sourcebillnumber;
        DynamicObjectCollection entryColl = payBill.getDynamicObjectCollection("entry");
        BigDecimal exchangeRate = payBill.getBigDecimal("exchangerate");
        BigDecimal settledamt = BigDecimal.ZERO;
        BigDecimal settledlocalamt = BigDecimal.ZERO;
        BigDecimal unsettledamt = BigDecimal.ZERO;
        BigDecimal unsettledlocalamtAll = BigDecimal.ZERO;
        int round = payBill.getDynamicObject("basecurrency").getInt("amtprecision");
        String quotation = payBill.getString("payquotation");
        for (DynamicObject entry : entryColl) {
            BigDecimal ePayableAmt = entry.getBigDecimal("e_payableamt");
            BigDecimal eLockamt = entry.getBigDecimal("e_lockamt");
            BigDecimal eSettledamt = entry.getBigDecimal("e_settledamt");
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unlockAmt", (Object)ePayableAmt.subtract(eLockamt));
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unsettledamt", (Object)ePayableAmt.subtract(eSettledamt));
            BigDecimal unsettledlocalamt = QuotationHelper.callToCurrency((BigDecimal)ePayableAmt.subtract(eSettledamt), (BigDecimal)exchangeRate, (String)quotation, (int)round);
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unsettledlocalamt", (Object)unsettledlocalamt);
            settledamt = settledamt.add(entry.getBigDecimal("e_settledamt"));
            settledlocalamt = settledlocalamt.add(entry.getBigDecimal("e_settledlocalamt"));
            unsettledamt = unsettledamt.add(ePayableAmt.subtract(eSettledamt));
            unsettledlocalamtAll = unsettledlocalamtAll.add(unsettledlocalamt);
        }
        payBill.set("settleamount", (Object)settledamt);
        payBill.set("settleamountbase", (Object)settledlocalamt);
        payBill.set("unsettleamount", (Object)unsettledamt);
        payBill.set("unsettleamountbase", (Object)unsettledlocalamtAll);
        if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) == 0) {
            payBill.set("settlestatus", (Object)"settled");
        }
        if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) > 0) {
            payBill.set("settlestatus", (Object)"partsettle");
        }
        if (settledamt.compareTo(BigDecimal.ZERO) == 0 && unsettledamt.compareTo(BigDecimal.ZERO) > 0) {
            payBill.set("settlestatus", (Object)"unsettle");
        }
        if (StringUtils.isNotEmpty((CharSequence)(sourcebillnumber = payBill.getString("sourcebillnumber"))) && sourcebillnumber.length() > 255) {
            sourcebillnumber = sourcebillnumber.substring(0, 252) + "...";
            payBill.set("sourcebillnumber", (Object)sourcebillnumber);
        }
        new BillPropertyValueHandle(payBill);
        this.dealMatchInfo(payBill);
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)payBill.getDynamicObject("settletype"));
        if (isCash) {
            payBill.set("feeactbank", null);
        }
    }

    private void specialProcess(String sourceBillType, List<DynamicObject> bills) {
        switch (sourceBillType) {
            case "ar_finarbill": {
                this.lockEntryAmtForArBill(bills);
                this.writeBackSourceBill(sourceBillType, bills);
                break;
            }
            case "cas_payapplybill": 
            case "cas_transferapply": 
            case "lc_arrival": {
                this.writeBackSourceBill(sourceBillType, bills);
                break;
            }
            case "ap_finapbill": {
                PayBillHepler.lockEntryAmtForApBill(bills);
            }
            case "fr_glreim_paybill": {
                break;
            }
            default: {
                PayBillHepler.lockEntryAmt((String)sourceBillType, bills);
                WriteBackServiceImpl.getInstance().batchWrite(bills, WriteBackOperateEnum.SUBMIT, PaymentSaveOrSubmitWriteBackConsumer.class);
            }
        }
    }

    private void writeBackSourceBill(String sourceBillType, List<DynamicObject> bills) {
        block3: {
            block2: {
                if (!"cas_payapplybill".equals(sourceBillType)) break block2;
                HashMap<String, DynamicObject[]> param = new HashMap<String, DynamicObject[]>();
                DynamicObject[] billArrary = bills.toArray(new DynamicObject[0]);
                param.put("infos", billArrary);
                WriteBackTaskHelper.batchAddRealtimeTask((DynamicObject[])billArrary, (String)"cas_payapplybill", (WriteBackOperateEnum)WriteBackOperateEnum.SUBMIT, PaymentSaveOrSubmitWriteBackConsumer.class, param);
                for (DynamicObject info : bills) {
                    PayBillHepler.payApplyBillWriteBackArrival((DynamicObject)info, (WriteBackOperateEnum)WriteBackOperateEnum.SUBMIT, PaymentSaveOrSubmitWriteBackConsumer.class);
                }
                break block3;
            }
            if ("ar_finarbill".equals(sourceBillType)) break block3;
            for (DynamicObject info : bills) {
                HashMap<String, DynamicObject> param = new HashMap<String, DynamicObject>(1);
                param.put("info", info);
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)info, (String)sourceBillType, (WriteBackOperateEnum)WriteBackOperateEnum.SUBMIT, PaymentSaveOrSubmitWriteBackConsumer.class, param);
            }
        }
    }

    private void lockEntryAmtForArBill(List<DynamicObject> bills) {
        logger.info("ar_finarbill is disposed!");
        for (DynamicObject info : bills) {
            DynamicObjectCollection entryColl = info.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entry.set("e_lockAmt", (Object)entry.getBigDecimal("e_payableAmt"));
                entry.set("e_unlockAmt", (Object)BigDecimal.ZERO);
            }
        }
    }

    private void dealMatchInfo(DynamicObject paymentBill) {
        String sourceBillType;
        BigDecimal matchAmtRec;
        String payeeType = paymentBill.getString("payeetype");
        Long payerId = paymentBill.getDynamicObject("org").getLong("id");
        Long payeeId = paymentBill.getLong("payee");
        if ("bos_org".equals(payeeType) && payeeId.compareTo(payerId) == 0) {
            boolean cs1047 = SystemParameterHelper.getParameterBoolean((long)paymentBill.getDynamicObject("org").getLong("id"), (String)"cs1047");
            paymentBill.set("relateotherflow", (Object)cs1047);
        } else {
            paymentBill.set("relateotherflow", (Object)Boolean.FALSE);
        }
        if (AsstActTypeEnum.OTHER.getValue().equals(payeeType)) {
            paymentBill.set("payeeacctbank", null);
        }
        if (BigDecimal.ZERO.compareTo(matchAmtRec = paymentBill.getBigDecimal("matchamountrec")) == 0) {
            paymentBill.set("matchamountrec", (Object)BigDecimal.ZERO);
            paymentBill.set("unmatchamountrec", (Object)paymentBill.getBigDecimal("dpamt"));
        }
        if (EmptyUtil.isNoEmpty((String)(sourceBillType = paymentBill.getString("sourcebilltype"))) && "bei_intelpay".equals(sourceBillType)) {
            paymentBill.set("matchamountpay", (Object)paymentBill.getBigDecimal("totalpayamt"));
            paymentBill.set("unmatchamountpay", (Object)BigDecimal.ZERO);
            BigDecimal unMatchAmountRec = paymentBill.getBigDecimal("unmatchamountrec");
            if (!paymentBill.getBoolean("relateotherflow")) {
                paymentBill.set("matchflag", (Object)"1");
            } else if (BigDecimal.ZERO.compareTo(unMatchAmountRec) < 0) {
                paymentBill.set("matchflag", (Object)"2");
            }
        } else if (kd.fi.cas.util.StringUtils.isEmpty((String)paymentBill.getString("matchflag")) || "0".equals(paymentBill.getString("matchflag"))) {
            paymentBill.set("matchamountpay", (Object)BigDecimal.ZERO);
            paymentBill.set("unmatchamountpay", (Object)paymentBill.getBigDecimal("totalpayamt"));
            paymentBill.set("matchflag", (Object)"0");
        }
        Map tMatchResult = AutoMatchHelper.getMatchAmount((BigDecimal)BigDecimal.ZERO, (BigDecimal)paymentBill.getBigDecimal("matchamountpay"), (BigDecimal)paymentBill.getBigDecimal("unmatchamountpay"), (Boolean)paymentBill.getBoolean("relateotherflow"), (BigDecimal)paymentBill.getBigDecimal("matchamountrec"), (BigDecimal)paymentBill.getBigDecimal("unmatchamountrec"));
        AutoMatchHelper.initMatchAmount((DynamicObject)paymentBill, (Map)tMatchResult, (String)"matchamountpay", (String)"unmatchamountpay", (String)"matchflag", (String)"matchflagmsg");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject paymentBill : e.getDataEntities()) {
            String sourceBillType = paymentBill.getString("sourcebilltype");
            if (!"fr_glreim_paybill".equals(sourceBillType)) continue;
            WriteBackTaskHelper.addRealtimeTask((DynamicObject)paymentBill, (String)sourceBillType, (WriteBackOperateEnum)WriteBackOperateEnum.SUBMIT, PaymentDisposeConsumer.class);
        }
    }
}

