/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.ar.ArWriteBackHelper;
import kd.fi.cas.business.writeback.ar.bean.RefundAndRenoteOrCancelParam;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.validator.ReceivingBillRefundPayAPValidator;

public class RecBillRefundPayWriteBackOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RecBillRefundPayWriteBackOp.class);
    private static final String[] selProps0 = new String[]{"id", "refundbillid"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("isrefund");
        lst.add("isfullrefund");
        lst.add("actrecamt");
        lst.add("e_settledamt");
        lst.add("fee");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        validators.add(new ReceivingBillRefundPayAPValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List recIds = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("refundbillid", "in", recIds);
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)String.join((CharSequence)",", selProps0), (QFilter[])new QFilter[]{filter});
        Map<Long, DynamicObject> idToPayBillMap = Arrays.stream(payBills).collect(Collectors.toMap(o -> o.getLong("refundbillid"), o -> o, (a, b) -> a));
        for (DynamicObject recBill : dataEntities) {
            Long recId = recBill.getLong("id");
            DynamicObject payBill = idToPayBillMap.get(recId);
            if (payBill == null) continue;
            DynamicObject allFieldsPayBill = BusinessDataServiceHelper.loadSingle((Object)payBill.getPkValue(), (String)"cas_paybill");
            this.payWriteBack(allFieldsPayBill, recBill);
        }
    }

    private void payWriteBack(DynamicObject payBill, DynamicObject recBill) {
        WriteBackOperateEnum writeBackOperateEnum = BillStatusEnum.REFUND.getValue().equals(payBill.getString("billstatus")) ? WriteBackOperateEnum.REFUND : WriteBackOperateEnum.RENOTE;
        String sourcebilltype = payBill.getString("sourcebilltype");
        RefundAndRenoteOrCancelParam arParam = ArWriteBackHelper.buildRefundRenoteParam((DynamicObject)payBill, (Long)recBill.getLong("id"), (WriteBackOperateEnum)writeBackOperateEnum);
        ArWriteBackHelper.writerBackAP((RefundAndRenoteOrCancelParam)arParam, (String)"RefundAndRenoteECService");
        if (!ArWriteBackHelper.isArApSourceType((String)sourcebilltype)) {
            BigDecimal refundAmt = recBill.getBigDecimal("actrecamt");
            BigDecimal actRecAmtFee = refundAmt.add(recBill.getBigDecimal("fee"));
            BigDecimal actpayamt = payBill.getBigDecimal("actpayamt");
            Boolean isfullrefund = Boolean.TRUE;
            if (actRecAmtFee.compareTo(actpayamt) != 0) {
                isfullrefund = Boolean.FALSE;
            }
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("isfullrefund", isfullrefund);
            WriteBackTaskHelper.addRealtimeTask((DynamicObject)payBill, (String)sourcebilltype, (WriteBackOperateEnum)writeBackOperateEnum, PaymentDisposeConsumer.class, params);
        }
        OperateServiceHelper.execOperate((String)"delpurpay", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBill}, (OperateOption)OperateOption.create());
    }
}

