/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.helper.VoucherCheckHepler;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.opservice.helper.RecSaleServiceHelper;
import kd.fi.cas.business.opservice.helper.ReceServiceHelper;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.business.pojo.RecParam;
import kd.fi.cas.business.service.oplog.OpLogFactory;
import kd.fi.cas.business.service.oplog.recoplog.IRecBillOpLog;
import kd.fi.cas.business.writeback.RecWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.pojo.BotpBackValue;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.RecBillCancelRecForIfmValidator;
import kd.fi.cas.validator.RecBillCancelRecValidator;

public class ReceivCancelRecOp
extends AbstractOperationServicePlugIn {
    public static final String PARA_VOUCHERIDS = "voucherIds:";
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private static final Log logger = LogFactory.getLog(ReceivCancelRecOp.class);
    private DraftLockServiceHelper draftLockServiceHelper;
    private Map<Long, Set<Long>> recIdAndReleaIdMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Long> releaIdAndrecIdMap = new HashMap<Long, Long>(16);
    private Map<Long, Set<Long>> recIdAndDraftIdSetMap = new HashMap<Long, Set<Long>>(8);
    private Set<Long> dealReleRecIdSet = new HashSet<Long>(16);
    private DynamicObject[] dbRecBills = null;

    public ReceivCancelRecOp() {
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("billno");
        lst.add("biztype");
        lst.add("bizdate");
        lst.add("billstatus");
        lst.add("txt_description");
        lst.add("receivingtype");
        lst.add("payertype");
        lst.add("org");
        lst.add("accountbank");
        lst.add("payeebank");
        lst.add("payer");
        lst.add("payerformid");
        lst.add("payeracctbank");
        lst.add("payeraccformid");
        lst.add("payername");
        lst.add("payeracctbanknum");
        lst.add("f7_payerbank");
        lst.add("cashier");
        lst.add("payeedate");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("isagent");
        lst.add("isrefund");
        lst.add("accountcash");
        lst.add("actrecamt");
        lst.add("currency");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("isvoucher");
        lst.add("confirmlogo");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("realreccompany");
        lst.add("e_sourcebillid");
        lst.add("e_sourcebillentryid");
        lst.add("confirmlogo");
        lst.add("sourcetype");
        lst.add("e_settleorg");
        lst.add("e_dividestatus");
        lst.add("recorg");
        lst.add("e_orgsdividebatch");
        lst.add("issupplecontract");
        lst.add("isorgsdivide");
        lst.add("openorg");
        lst.add("draftbill");
        lst.add("hotaccount");
        lst.add("isused");
        lst.add(String.join((CharSequence)".", "draftbill", "fbasedataid", "id"));
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry"));
        lst.add("acctstatus");
        lst.add("sourcebilltype");
        lst.add("txt_description");
        lst.add("txt_description_tag");
        lst.add("cas_draftinfo");
        lst.add("transamount");
        lst.add("draftbillinfo");
        lst.add("draftbilllogid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        validators.add(new RecBillCancelRecValidator(this.journalServiceAdapter));
        validators.add(new RecBillCancelRecForIfmValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject info : e.getDataEntities()) {
            if (!info.getDynamicObject("receivingtype").get("biztype").equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue())) continue;
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"InnerAcctCancelRecService", (String)"cancelRec", (Object[])new Object[]{info.getPkValue()});
        }
        List recBillIds = Stream.of(e.getDataEntities()).map(o -> o.getPkValue()).collect(Collectors.toList());
        this.dbRecBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"draftbill,settleType,cas_draftinfo,cas_draftinfo.draftbillinfo,cas_draftinfo.draftbilllogid", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillIds)});
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String string;
        super.beginOperationTransaction(e);
        String voucheridstr = (String)this.getOption().getVariables().get(PARA_VOUCHERIDS);
        HashSet<Long> voucherIds = new HashSet<Long>(SerializationUtils.fromJsonStringToList((String)voucheridstr, Long.class));
        ArrayList<DynamicObject> recDtList = new ArrayList<DynamicObject>(10);
        this.cancelRecReverseVoucher(voucherIds);
        ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(e.getDataEntities().length);
        ArrayList<WriteBackTaskInfo> taskInfos2 = new ArrayList<WriteBackTaskInfo>(e.getDataEntities().length);
        Map variables = this.getOption().getVariables();
        if (EmptyUtil.isNoEmpty((Object)variables) && variables.size() > 0 && EmptyUtil.isEmpty((String)(string = (String)variables.get("isreleacancel")))) {
            this.recIdAndReleaIdMap = DraftHelper.getBatchDealCasBillId((DynamicObject[])e.getDataEntities(), this.dealReleRecIdSet, this.releaIdAndrecIdMap, new HashMap());
        }
        for (DynamicObject info : e.getDataEntities()) {
            recDtList.add(info);
            if (CasHelper.isEmpty((Object)info.getString("sourcebilltype"))) continue;
            if ("cfm_loanbill".equals(info.getString("sourcebilltype"))) {
                WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
                taskInfo.setBillId((Long)info.getPkValue());
                taskInfo.setDataEntity(info.getDataEntityType().getName());
                taskInfo.setSourceEntity(info.getString("sourcebilltype"));
                taskInfos.add(taskInfo);
                continue;
            }
            WriteBackTaskInfo taskInfo2 = new WriteBackTaskInfo();
            taskInfo2.setBillId((Long)info.getPkValue());
            taskInfo2.setDataEntity(info.getDataEntityType().getName());
            taskInfo2.setSourceEntity(info.getString("sourcebilltype"));
            taskInfos2.add(taskInfo2);
        }
        this.cancelProcess(recDtList, voucherIds);
        WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.REFUND, RecWriteBackConsumer.class);
        WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos2, (WriteBackOperateEnum)WriteBackOperateEnum.CANCELRECEIVE, RecWriteBackConsumer.class);
        try {
            IRecBillOpLog iRecBillOpLog = new OpLogFactory().getRecBillOpLogImpl("cancelRecOp");
            iRecBillOpLog.doRecOpLog((Object)e.getDataEntities());
        }
        catch (Exception exception) {
            logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)exception));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject[] reInfos = (DynamicObject[])Arrays.stream(dataEntities).filter(dy -> !CasHelper.isEmpty((Object)dy) && (!CasHelper.isEmpty((Object)dy.getString("sourcebilltype")) && "er_dailyloanbill".equals(dy.getString("sourcebilltype")) || "er_repaymentbill".equals(dy.getString("sourcebilltype")) || dy.getDynamicObjectCollection("entry").stream().anyMatch(d -> "er_repaymentbill".equals(d.getString("e_corebilltype")) && !CasHelper.isEmpty((Object)d.getString("e_sourcebillentryid"))))).toArray(DynamicObject[]::new);
        if (reInfos.length > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("dataEntities", reInfos);
            param.put("operate", operationKey);
            param.put("billType", "cas_recbill");
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"ICasBillWriteBackService", (String)"execute", (Object[])new Object[]{param});
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
        for (DynamicObject info : e.getDataEntities()) {
            try {
                if (!CasHelper.isEmpty((Object)info.getString("sourcebilltype")) && "lc_present".equals(info.getString("sourcebilltype"))) {
                    // empty if block
                }
            }
            catch (Exception error) {
                logger.error("ReceivCancelRecOp SourceBillWriteBack error : ", (Throwable)error);
            }
            if (ReceServiceHelper.isNeedWriteBack((DynamicObject)info)) {
                RecBillOverAmountHelper.getWriteBackVad((DynamicObject)info, (WriteBackOperateEnum)WriteBackOperateEnum.CANCELRECEIVE, (boolean)false);
            }
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)info.getDataEntityType().getName(), (String)"billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) continue;
            VoucherCheckHepler.doCancelCoucherCheck((DynamicObject)info);
        }
        DynamicObject[] dynamicObjectArray = this.dbRecBills;
        int n = dynamicObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicObject dbRecBill = dynamicObjectArray[n2];
            try (TXHandle tx = TX.requiresNew();){
                try {
                    DynamicObject settleType = dbRecBill.getDynamicObject("settletype");
                    boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
                    boolean isSettleTypeProm = BaseDataHelper.isSettleTypeProm((DynamicObject)settleType);
                    boolean isSettleTypeCheck = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
                    logger.info("ReceivCancelRecOp.afterExecuteOperationTransaction typeDraft = {},isSettleTypeProm = {},isSettleTypeCheck = {}", new Object[]{typeDraft, isSettleTypeProm, isSettleTypeCheck});
                    if (typeDraft || isSettleTypeProm || isSettleTypeCheck) {
                        DynamicObjectCollection draftDataColl = dbRecBill.getDynamicObjectCollection("draftbill");
                        List draftNoList = draftDataColl.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                        DynamicObject[] recDraftBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"rectype,rulename", (QFilter[])new QFilter[]{new QFilter("id", "in", draftNoList)});
                        logger.info("ReceivCancelRecOp.afterExecuteOperationTransaction draftDataColl.size = {},draftNoList.size = {},recDraftBills.length = {}", new Object[]{draftDataColl.size(), draftNoList.size(), recDraftBills.length});
                        HashSet<DynamicObject> needUpdaterecBillSet = new HashSet<DynamicObject>(8);
                        for (DynamicObject recDraftBill : recDraftBills) {
                            String rectype = recDraftBill.getString("rectype");
                            if ("3".equals(rectype) || "4".equals(rectype) || "6".equals(rectype)) continue;
                            recDraftBill.set("rectype", (Object)"");
                            recDraftBill.set("rulename", (Object)"");
                            needUpdaterecBillSet.add(recDraftBill);
                        }
                        if (EmptyUtil.isNoEmpty(needUpdaterecBillSet)) {
                            SaveServiceHelper.save((DynamicObject[])needUpdaterecBillSet.toArray(new DynamicObject[0]));
                        }
                    }
                }
                catch (Exception exception) {
                    tx.markRollback();
                    logger.error("ReceivCancelRecOp.afterExecuteOperationTransaction has Exception:", (Object)e);
                }
            }
            ++n2;
        }
        return;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        RecSaleServiceHelper.convertSaleAndContract((DynamicObject[])e.getDataEntities(), (boolean)false);
        List recIdList = Arrays.stream(e.getDataEntities()).map(o -> o.getLong("id")).collect(Collectors.toList());
        logger.info("begin RecBillListener : " + recIdList);
        RecParam param = new RecParam();
        param.setIds(recIdList);
        param.setOperate("cancelRec");
        ECGlobalSession.begin((String)"cas_batchwriteback", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
        ECGlobalSession.setBusinessType((String)"batchwrite");
        List recIdStrList = recIdList.stream().map(String::valueOf).collect(Collectors.toList());
        ECGlobalSession.setBusinessInfo(recIdStrList);
        ECGlobalSession.register((String)"fi", (String)"cas", (String)"BatchWriteRecTxService", (Param)param, (String)"ar_finarbill", (String)"");
        Map variables = this.getOption().getVariables();
        String isreleacancel = (String)variables.get("isreleacancel");
        logger.info("is from isreleacancel");
        if (EmptyUtil.isEmpty((String)isreleacancel) || !"y".equals(isreleacancel)) {
            List<DynamicObject> recDyList = Arrays.stream(e.getDataEntities()).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(this.dealReleRecIdSet) && this.dealReleRecIdSet.size() > 0) {
                DynamicObject[] releaRecBillArr = BusinessDataServiceHelper.load((Object[])this.dealReleRecIdSet.toArray(), (DynamicObjectType)recDyList.get(0).getDynamicObjectType());
                recDyList.addAll(Arrays.stream(releaRecBillArr).collect(Collectors.toList()));
            }
            this.draftBillHandle(recDyList);
        }
    }

    private List<Long> cancelRecReverseVoucher(Set<Long> voucherIds) {
        Object voucerOp = this.getOption().getVariables().get("voucerOp");
        return VoucherBookHelper.reverseVoucher(voucherIds, voucerOp);
    }

    private Map<String, Set<Long>> convert2Map(List<BotpBackValue> botpValues) {
        HashMap<String, Set<Long>> returns = new HashMap<String, Set<Long>>(botpValues.size());
        for (BotpBackValue botpValue : botpValues) {
            Set backs = returns.computeIfAbsent(botpValue.getTargetEntity(), k -> new HashSet(16));
            backs.addAll(botpValue.getTargetIds());
        }
        return returns;
    }

    private void cancelProcess(List<DynamicObject> recDtList, Set<Long> reverVouIds) {
        try {
            ArrayList<Long> recBillIdList = new ArrayList<Long>(10);
            HashSet recSet = new HashSet(10);
            HashSet paySet = new HashSet(10);
            HashSet apSet = new HashSet(10);
            ArrayList cdmRecCon = new ArrayList(10);
            Long[] recBillIds = (Long[])recDtList.stream().map(o -> o.getLong("id")).distinct().toArray(Long[]::new);
            List botpValues = CasBotpHelper.getDestBillBySrcBill((String)"cas_recbill", (Long[])recBillIds);
            Map<String, Set<Long>> map = this.convert2Map(botpValues);
            for (DynamicObject recBill : recDtList) {
                Object otherRecBillIdSet;
                long recBillRecId = recBill.getLong("id");
                if (EmptyUtil.isNoEmpty(this.recIdAndReleaIdMap) && this.recIdAndReleaIdMap.size() > 0 && EmptyUtil.isNoEmpty(otherRecBillIdSet = this.recIdAndReleaIdMap.get(recBillRecId)) && otherRecBillIdSet.size() > 0) {
                    OperateOption create = OperateOption.create();
                    Map variables = this.getOption().getVariables();
                    if (EmptyUtil.isNoEmpty((Object)variables)) {
                        create.getVariables().putAll(variables);
                    }
                    create.setVariableValue("isreleacancel", "y");
                    OperateServiceHelper.execOperate((String)"cancelRec", (String)"cas_recbill", (Object[])otherRecBillIdSet.toArray(), (OperateOption)create);
                }
                recBillIdList.add(recBillRecId);
                recBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                recBill.set("cashier", null);
                recBill.set("payeedate", null);
                otherRecBillIdSet = map.entrySet().iterator();
                while (otherRecBillIdSet.hasNext()) {
                    DynamicObjectCollection draftbills;
                    Map.Entry entry = (Map.Entry)otherRecBillIdSet.next();
                    String targetKey = (String)entry.getKey();
                    Set targetPks = (Set)entry.getValue();
                    if ("cas_recbill".equals(targetKey)) {
                        targetPks.remove(recBill.getLong("id"));
                        recSet.addAll(targetPks);
                    }
                    if ("cas_paybill".equals(targetKey)) {
                        paySet.addAll(targetPks);
                    }
                    if ("ap_finapbill".equals(targetKey)) {
                        apSet.addAll(targetPks);
                        CasBotpHelper.deleteRation((Object)recBill.getPkValue(), (String[])new String[]{targetKey});
                    }
                    if (!"cdm_receivablebill".equals(targetKey) || (draftbills = QueryServiceHelper.query((String)targetKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)targetPks).and("source", "=", (Object)"cas")})) == null || draftbills.size() <= 0) continue;
                    recBill.set("settletnumber", null);
                    recBill.set("draftbill", null);
                    cdmRecCon.addAll(targetPks);
                }
            }
            if (recSet.size() > 0) {
                OperateServiceHelper.execOperate((String)"delete", (String)"cas_recbill", (Object[])recSet.toArray(new Long[0]), (OperateOption)OperateOption.create(), (boolean)false);
            }
            if (paySet.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("delrecpay", "1");
                OperateServiceHelper.execOperate((String)"delete", (String)"cas_paybill", (Object[])paySet.toArray(new Long[0]), (OperateOption)option, (boolean)false);
            }
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"ap_finapbill"), (Object[])apSet.toArray(new Long[0]));
            Map params = this.operateOption.getVariables();
            if (cdmRecCon.size() > 0 && !params.containsKey("isfrombilldelte")) {
                OperateServiceHelper.execOperate((String)"casdel", (String)"cdm_receivablebill", (Object[])cdmRecCon.toArray(), (OperateOption)OperateOption.create(), (boolean)true);
            }
            try (TXHandle tx = TX.requiresNew();){
                for (DynamicObject recBill : recDtList) {
                    String sourcebilltype = recBill.getString("sourcebilltype");
                    if ("cdm_receivablebill".equals(sourcebilltype)) continue;
                    long recCasId = recBill.getLong("id");
                    CasBotpHelper.deleteRation((DBRoute)DBRouteConst.TMC, (String)"cdm_receivablebill", (Long[])new Long[0], (Long)recCasId);
                    DynamicObjectCollection draftDataColl = recBill.getDynamicObjectCollection("draftbill");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftDataColl)) {
                        Set draftNoList = draftDataColl.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                        if (this.recIdAndDraftIdSetMap.containsKey(recCasId)) {
                            this.recIdAndDraftIdSetMap.get(recCasId).addAll(draftNoList);
                        } else {
                            this.recIdAndDraftIdSetMap.put(recCasId, draftNoList);
                        }
                    }
                    if ("cas_claimcenterbill".equals(sourcebilltype)) continue;
                    DynamicObjectCollection draftColl = recBill.getDynamicObjectCollection("draftbill");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftColl)) {
                        recBill.set("settletnumber", null);
                    }
                    recBill.set("draftbill", null);
                    this.updateLogDeleted(recBill);
                    recBill.set("cas_draftinfo", null);
                }
            }
            this.journalServiceAdapter.cancelBooks(recBillIdList);
        }
        catch (Exception e) {
            if (reverVouIds != null && reverVouIds.size() > 0) {
                OperateServiceHelper.execOperate((String)"delete", (String)"gl_voucher", (Object[])reverVouIds.toArray(), (OperateOption)OperateOption.create());
            }
            throw new KDBizException(e.getMessage());
        }
        SaveServiceHelper.save((DynamicObject[])recDtList.toArray(new DynamicObject[0]));
    }

    private void updateLogDeleted(DynamicObject recBill) {
        DynamicObject[] draftBillLogs;
        DynamicObjectCollection draftInfo = recBill.getDynamicObjectCollection("cas_draftinfo");
        Set logIdSet = draftInfo.stream().map(v -> v.getLong("draftbilllogid")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", logIdSet);
        qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
        for (DynamicObject draftBillLog : draftBillLogs = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,deleteflag", (QFilter[])qFilter.toArray())) {
            draftBillLog.set("deleteflag", (Object)true);
        }
        SaveServiceHelper.save((DynamicObject[])draftBillLogs);
    }

    private void draftBillHandle(List<DynamicObject> recDtList) {
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>(8);
        for (DynamicObject recBillData : recDtList) {
            DynamicObject settleType = recBillData.getDynamicObject("settletype");
            String sourcebilltype = recBillData.getString("sourcebilltype");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            String txt_description = recBillData.getString("txt_description");
            boolean isAlloc = ResManager.loadKDString((String)"\u7968\u636e\u6c60\u5185\u80cc\u4e66", (String)"ReceivRecOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]).equals(txt_description);
            if (!typeDraft && !checkDraft || isFromcdm || isAlloc) {
                logger.info("is not draftType or from cdm" + recBillData.getString("billno"));
                continue;
            }
            DynamicObjectCollection draftDataColl = recBillData.getDynamicObjectCollection("draftbill");
            DynamicObjectCollection draftInfoEntrys = recBillData.getDynamicObjectCollection("cas_draftinfo");
            if (draftDataColl == null || draftDataColl.size() <= 0) continue;
            Set draftIdSet = draftDataColl.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("fbasedataid"))).map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            this.recIdAndDraftIdSetMap.put(recBillData.getLong("id"), draftIdSet);
            Set draftBillIds = draftInfoEntrys.stream().map(v -> v.getDynamicObject("draftbillinfo").getLong("id")).collect(Collectors.toSet());
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_payandrecdraft_f7", (String)"id,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)});
            HashMap draftIdAvailableAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("availableamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdTransAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            ArrayList<DraftAmountLockSubInfo> saveDraftAmountLockInfos = new ArrayList<DraftAmountLockSubInfo>(10);
            draftLockInfo.setSourceBillType(recBillData.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(recBillData.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(recBillData.getLong("id")));
            draftLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
            draftLockInfo.setOperateType(LogOperateTypeEnum.CANCELCOMPLETE.getValue());
            for (Long lockDraftId : draftBillIds) {
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(lockDraftId);
                BigDecimal availableAmount = draftIdAvailableAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(lockDraftId);
                BigDecimal transAmount = draftIdTransAmountMap.get(lockDraftId) == null ? availableAmount : (BigDecimal)draftIdTransAmountMap.get(lockDraftId);
                draftAmountLockInfo.setDealAmount(transAmount);
                Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockInfo.setBillLogId(billLogId);
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountLockInfo.setOperateType(LogOperateTypeEnum.CANCELCOMPLETE.getValue());
                if (transAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                saveDraftAmountLockInfos.add(draftAmountLockInfo);
            }
            if (!EmptyUtil.isNoEmpty(saveDraftAmountLockInfos) || saveDraftAmountLockInfos.size() <= 0) continue;
            draftLockInfo.getLockSubInfoList().addAll(saveDraftAmountLockInfos);
            lockInfoList.add(draftLockInfo);
        }
        try {
            ArrayList lockResults = new ArrayList(10);
            if (!CollectionUtils.isEmpty(lockInfoList)) {
                logger.info("ReceivCancelRecOp lockBillsByLog is start," + JSON.toJSONString(lockInfoList));
                this.draftLockServiceHelper.releaseOrLockDraft(lockInfoList);
                logger.info("ReceivCancelRecOp lockBillsByLog is end," + JSON.toJSONString(lockResults));
            }
        }
        catch (Exception e2) {
            logger.error("ReceivCancelRecOp tx-> has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e2));
            throw e2;
        }
        this.updateDraftBillCasEntry(recDtList);
    }

    private void updateDraftBillCasEntry(List<DynamicObject> recDtList) {
        String isfromdraftbill = (String)this.operateOption.getVariables().get("isfrombilldelte");
        boolean isFromRecCall = false;
        if (EmptyUtil.isNoEmpty((String)isfromdraftbill) && "y".equalsIgnoreCase(isfromdraftbill)) {
            isFromRecCall = true;
        }
        if (!isFromRecCall && EmptyUtil.isNoEmpty(this.recIdAndDraftIdSetMap) && this.recIdAndDraftIdSetMap.size() > 0) {
            HashSet needUpdateDraftSetAll = new HashSet(8);
            for (DynamicObject recBill : recDtList) {
                String billType;
                Set needUpdateDySet;
                Long caeRecId;
                long recBillId = recBill.getLong("id");
                Set<Long> draftBillSet = this.recIdAndDraftIdSetMap.get(recBillId);
                if ((EmptyUtil.isEmpty(draftBillSet) || draftBillSet.size() == 0) && EmptyUtil.isNoEmpty((Long)(caeRecId = this.releaIdAndrecIdMap.get(recBillId)))) {
                    draftBillSet = this.recIdAndDraftIdSetMap.get(caeRecId);
                }
                if (!EmptyUtil.isNoEmpty(draftBillSet) || draftBillSet.size() <= 0 || !EmptyUtil.isNoEmpty((Object)(needUpdateDySet = DraftHelper.updateDraftCasEntry((DynamicObject)recBill, draftBillSet, (String)(billType = "cdm_receivablebill"), (String)"delete", (String)"")))) continue;
                needUpdateDraftSetAll.addAll(needUpdateDySet);
            }
            if (EmptyUtil.isNoEmpty(needUpdateDraftSetAll)) {
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])needUpdateDraftSetAll.toArray(new DynamicObject[0]));
                }
                catch (Exception error) {
                    logger.error("update bill cas entry has error", (Throwable)error);
                }
            }
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        this.draftLockServiceHelper.rollback();
    }
}

