/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.refund.RefundOpHelper;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.ReceivingBillRefundValidator;

public class ReceivingBillRefundOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ReceivingBillRefundOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("sourcebilltype");
        lst.add("isrefund");
        lst.add("isfullrefund");
        lst.add("actrecamt");
        lst.add("e_settledamt");
        lst.add("fee");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        List seqList = (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("selected"), List.class);
        String rebillid = this.getOption().getVariableValue("rebillid");
        DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)rebillid, (String)"cas_recbill", (String)"id,txt_description,entry,entry.e_receivableamt");
        String description = recbill.getString("txt_description");
        DynamicObjectCollection recCol = recbill.getDynamicObjectCollection("entry");
        BigDecimal recAmtSum = recCol.stream().map(o -> o.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObjectCollection dynamicObjectCollection = dataEntities[0].getDynamicObjectCollection("entryentity");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        for (DynamicObject rowObject : dynamicObjectCollection) {
            if (seqList.contains((Integer)rowObject.get("seq") - 1)) {
                if ("cas_paybill".equals(rowObject.getString("billtype"))) {
                    DynamicObject payMent;
                    DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)rowObject.getLong("id"), (String)rowObject.getString("billtype"));
                    payBill.set("refundbillid", (Object)recbill.getLong("id"));
                    this.payRefund(payBill, recAmtSum, description);
                    logger.info("\u9000\u7968\uff0c\u4ed8\u6b3e\u5355\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)payBill));
                    if (!CasHelper.isEmpty((Object)payBill.get("applyorg")) && "cas_paybill".equals(payBill.get("sourcebilltype")) && !CasHelper.isEmpty((Object)payBill.get("sourcebillid")) && !CasHelper.isEmpty((Object)(payMent = BusinessDataServiceHelper.loadSingle((Object)payBill.get("sourcebillid"), (String)"cas_paybill")))) {
                        this.payRefund(payMent, recAmtSum, description);
                    }
                    CasBotpHelper.saveRelation((String)"cas_recbill", (Long)Long.valueOf(rebillid), (String)"cas_paybill", (Long)rowObject.getLong("id"));
                    this.saveRecBill(Long.valueOf(rebillid));
                    OperateOption create = OperateOption.create();
                    create.setVariableValue("ishasright", "true");
                    OperateServiceHelper.execOperate((String)"paywritebackap", (String)"cas_recbill", (Object[])new Object[]{Long.parseLong(rebillid)}, (OperateOption)create);
                } else if ("cas_agentpaybill".equals(rowObject.getString("billtype"))) {
                    Long entryId = rowObject.getLong("entryid");
                    filters.add(new QFilter("entry.id", "=", (Object)entryId));
                    DynamicObject billObject = BusinessDataServiceHelper.loadSingle((String)rowObject.getString("billtype"), (String)"sourcebilltype,entry.sourceentryid,entry.e_issuccess,entry.e_amount,entry.e_isrefund,entry.e_refundamt,entry.e_refunddes,entry.refundbillid,entry.refundtype", (QFilter[])filters.toArray(new QFilter[0]));
                    DynamicObject billObject1 = BusinessDataServiceHelper.loadSingle((Object)billObject.getLong("id"), (DynamicObjectType)billObject.getDynamicObjectType());
                    filters.clear();
                    Long sourceEntryId = RefundOpHelper.agentRefund((DynamicObject)billObject1, (Long)entryId, (BigDecimal)recAmtSum, (String)description, (Long)recbill.getLong("id"), (String)WriteBackOperateEnum.RENOTE.getValue(), (Boolean)false);
                    logger.info("\u9000\u7968\uff0c\u4ee3\u53d1\u5355\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)billObject));
                    if (AgentPayBillHelper.isDelegPush((DynamicObject)billObject)) {
                        Set setLongs = CasBotpHelper.getSrcBillByDestBill((Long)billObject.getLong("id"), (String)"cas_agentpaybill", (String)"cas_agentpaybill");
                        for (Long id : setLongs) {
                            DynamicObject sourceAgentBill = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)billObject.getDynamicObjectType());
                            RefundOpHelper.agentRefund((DynamicObject)sourceAgentBill, (Long)sourceEntryId, (BigDecimal)recAmtSum, (String)description, null, (String)WriteBackOperateEnum.RENOTE.getValue(), (Boolean)false);
                        }
                    }
                    CasBotpHelper.saveRelation((String)"cas_recbill", (Long)Long.valueOf(rebillid), (String)"cas_agentpaybill", (Long)rowObject.getLong("id"));
                    this.saveRecBill(Long.valueOf(rebillid));
                }
            }
            logger.info("\u9000\u7968\u6267\u884c\u5b8c\u6bd5!");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        List seqList = (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("selected"), List.class);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObjectCollection dynamicObjectCollection = dataEntities[0].getDynamicObjectCollection("entryentity");
        for (DynamicObject rowObject : dynamicObjectCollection) {
            if (!seqList.contains((Integer)rowObject.get("seq") - 1) || "cas_paybill".equals(rowObject.getString("billtype")) || !"cas_agentpaybill".equals(rowObject.getString("billtype"))) continue;
            Long entryId = rowObject.getLong("entryid");
            List<QFilter> filters = Collections.singletonList(new QFilter("entry.id", "=", (Object)entryId));
            DynamicObject billObject = BusinessDataServiceHelper.loadSingle((String)rowObject.getString("billtype"), (String)"sourcebilltype,entry.sourceentryid,entry.e_issuccess,entry.e_amount,entry.e_isrefund,entry.e_refundamt,entry.e_refunddes", (QFilter[])filters.toArray(new QFilter[0]));
            Long sourceEntryId = this.agentWriteBack(billObject, entryId);
            if (!AgentPayBillHelper.isDelegPush((DynamicObject)billObject)) continue;
            Set setLongs = CasBotpHelper.getSrcBillByDestBill((Long)billObject.getLong("id"), (String)"cas_agentpaybill", (String)"cas_agentpaybill");
            for (Long id : setLongs) {
                DynamicObject sourceAgentBill = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)billObject.getDynamicObjectType());
                this.agentWriteBack(sourceAgentBill, sourceEntryId);
            }
        }
        try {
            logger.info("\u9000\u7968\uff0cafterExecuteOperationTransaction\uff1a" + JSONUtils.toString((Object)e));
        }
        catch (IOException e1) {
            logger.info("\u9000\u7968\uff0cafterExecuteOperationTransaction\u6253\u5370\u5931\u8d25");
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        try {
            logger.info("\u9000\u7968\uff0crollbackOperation\uff1a" + JSONUtils.toString((Object)e));
        }
        catch (IOException e1) {
            logger.info("\u9000\u7968\uff0cafterExecuteOperationTransaction\u6253\u5370\u5931\u8d25");
        }
    }

    private void saveRecBill(Long rebillid) {
        DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)rebillid, (String)"cas_recbill");
        recbill.set("isrefund", (Object)true);
        recbill.set("isfullrefund", (Object)true);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recbill});
        logger.info("\u9000\u7968\uff0c\u6536\u6b3e\u5355\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)recbill));
        if (null != save) {
            logger.info("\u9000\u7968\uff0c\u6536\u6b3e\u5355\u4fe1\u606fSaveServiceHelper.save\uff1a" + SerializationUtils.toJsonString((Object)save));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        validators.add(new ReceivingBillRefundValidator());
    }

    private void payRefund(DynamicObject payBill, BigDecimal refundAmt, String description) {
        BigDecimal e_refundamt_i;
        payBill.set("billstatus", (Object)BillStatusEnum.RENOTE.getValue());
        DynamicObject feeBill = RefundOpHelper.resetPayAndFeeStatusForRefund((DynamicObject)payBill, (String)BillStatusEnum.RENOTE.getValue());
        DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
        List sortEntry = entry.stream().sorted(Comparator.comparing(dynamicObject -> dynamicObject.getBigDecimal("e_payableamt"))).collect(Collectors.toList());
        HashMap<Long, BigDecimal> regundAmtMap = new HashMap<Long, BigDecimal>(sortEntry.size());
        for (DynamicObject d : sortEntry) {
            e_refundamt_i = d.getBigDecimal("e_payableamt");
            if (e_refundamt_i.compareTo(refundAmt) <= 0) {
                refundAmt = refundAmt.subtract(e_refundamt_i);
                regundAmtMap.put(d.getLong("id"), e_refundamt_i);
                continue;
            }
            regundAmtMap.put(d.getLong("id"), refundAmt);
            break;
        }
        for (DynamicObject d : entry) {
            e_refundamt_i = (BigDecimal)regundAmtMap.get(d.getLong("id"));
            if (e_refundamt_i == null) continue;
            d.set("e_refundamt", (Object)e_refundamt_i);
            d.set("e_refunddes", (Object)description);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
        if (EmptyUtil.isNoEmpty((DynamicObject)feeBill)) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{feeBill});
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        OperateServiceHelper.execOperate((String)"confirmrefund", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, (OperateOption)OperateOption.create());
    }

    private Long agentWriteBack(DynamicObject agentBill, Long entryId) {
        Long sourceEntryId = 0L;
        if (CasHelper.isNotEmpty((Object)agentBill.getString("sourcebilltype"))) {
            DynamicObjectCollection entrys = agentBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (!entryId.equals(entry.getLong("id"))) continue;
                sourceEntryId = entry.getLong("sourceentryid");
                HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
                param.put("entryPks", Collections.singletonList(entryId));
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)agentBill, (String)agentBill.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.RENOTE, AgentWriteBackConsumer.class, param);
                break;
            }
        }
        OperateServiceHelper.execOperate((String)"synctrigger", (String)agentBill.getDataEntityType().getName(), (Object[])new Object[]{agentBill.getPkValue()}, (OperateOption)OperateOption.create());
        return sourceEntryId;
    }
}

