/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.refund.RefundOpHelper;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.ReceivingBillRefundValidator;

public class ReceivingBillReturnMoneyOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ReceivingBillReturnMoneyOp.class);
    private Map<String, Object> param = new HashMap<String, Object>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("sourcebilltype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("--\u9000\u6b3e-- ReceivingBillReturnMoneyOp.beginOperationTransaction(BeginOperationTransactionArgs)");
        Boolean isdooperate = (Boolean)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("isdooperate"), Boolean.class);
        if (isdooperate.booleanValue()) {
            List seqList = (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("selected"), List.class);
            String rebillid = this.getOption().getVariableValue("rebillid");
            DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)rebillid, (String)"cas_recbill", (String)"id,txt_description,entry,entry.e_receivableamt");
            String description = recbill.getString("txt_description");
            DynamicObjectCollection recCol = recbill.getDynamicObjectCollection("entry");
            BigDecimal recAmtSum = recCol.stream().map(o -> o.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            DynamicObject[] dataEntities = e.getDataEntities();
            DynamicObjectCollection dynamicObjectCollection = dataEntities[0].getDynamicObjectCollection("entryentity");
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            for (DynamicObject rowObject : dynamicObjectCollection) {
                if (!seqList.contains((Integer)rowObject.get("seq") - 1)) continue;
                if ("cas_paybill".equals(rowObject.getString("billtype"))) {
                    DynamicObject payMent;
                    DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)rowObject.getLong("id"), (String)rowObject.getString("billtype"));
                    payBill.set("refundbillid", (Object)recbill.getLong("id"));
                    this.payRefund(payBill, recAmtSum, description);
                    if (!CasHelper.isEmpty((Object)payBill.get("applyorg")) && "cas_paybill".equals(payBill.get("sourcebilltype")) && !CasHelper.isEmpty((Object)payBill.get("sourcebillid")) && !CasHelper.isEmpty((Object)(payMent = BusinessDataServiceHelper.loadSingle((Object)payBill.get("sourcebillid"), (String)"cas_paybill")))) {
                        this.payRefund(payMent, recAmtSum, description);
                    }
                    CasBotpHelper.saveRelation((String)"cas_recbill", (Long)Long.valueOf(rebillid), (String)"cas_paybill", (Long)rowObject.getLong("id"));
                    this.saveRecBill(Long.valueOf(rebillid));
                    OperateOption create = OperateOption.create();
                    create.setVariableValue("ishasright", "true");
                    OperateServiceHelper.execOperate((String)"paywritebackap", (String)"cas_recbill", (Object[])new Object[]{Long.parseLong(rebillid)}, (OperateOption)create);
                    continue;
                }
                if (!"cas_agentpaybill".equals(rowObject.getString("billtype"))) continue;
                Long entryId = rowObject.getLong("entryid");
                filters.add(new QFilter("entry.id", "=", (Object)entryId));
                DynamicObject billObject = BusinessDataServiceHelper.loadSingle((String)rowObject.getString("billtype"), (String)"sourcebilltype,entry.sourceentryid,entry.e_issuccess,entry.e_amount,entry.e_isrefund,entry.e_refundamt,entry.e_refunddes,entry.refundbillid,entry.refundtype", (QFilter[])filters.toArray(new QFilter[0]));
                DynamicObject billObject1 = BusinessDataServiceHelper.loadSingle((Object)billObject.getLong("id"), (DynamicObjectType)billObject.getDynamicObjectType());
                filters.clear();
                Long sourceEntryId = RefundOpHelper.agentRefund((DynamicObject)billObject1, (Long)entryId, (BigDecimal)recAmtSum, (String)description, (Long)recbill.getLong("id"), (String)WriteBackOperateEnum.REFUND.getValue(), (Boolean)false);
                if (AgentPayBillHelper.isDelegPush((DynamicObject)billObject)) {
                    Set setLongs = CasBotpHelper.getSrcBillByDestBill((Long)billObject.getLong("id"), (String)"cas_agentpaybill", (String)"cas_agentpaybill");
                    for (Long id : setLongs) {
                        DynamicObject sourceAgentBill = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)billObject.getDynamicObjectType());
                        RefundOpHelper.agentRefund((DynamicObject)sourceAgentBill, (Long)sourceEntryId, (BigDecimal)recAmtSum, (String)description, null, (String)WriteBackOperateEnum.REFUND.getValue(), (Boolean)false);
                    }
                }
                CasBotpHelper.saveRelation((String)"cas_recbill", (Long)Long.valueOf(rebillid), (String)"cas_agentpaybill", (Long)rowObject.getLong("id"));
                this.saveRecBill(Long.valueOf(rebillid));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Boolean isdooperate = (Boolean)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("isdooperate"), Boolean.class);
        if (isdooperate.booleanValue()) {
            List seqList = (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("selected"), List.class);
            DynamicObject[] dataEntities = e.getDataEntities();
            DynamicObjectCollection dynamicObjectCollection = dataEntities[0].getDynamicObjectCollection("entryentity");
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            ArrayList<WriteBackTaskInfo> list = new ArrayList<WriteBackTaskInfo>();
            for (DynamicObject rowObject : dynamicObjectCollection) {
                if (!seqList.contains((Integer)rowObject.get("seq") - 1) || !"cas_agentpaybill".equals(rowObject.getString("billtype"))) continue;
                Long entryId = rowObject.getLong("entryid");
                filters.add(new QFilter("entry.id", "=", (Object)entryId));
                DynamicObject billObject = BusinessDataServiceHelper.loadSingle((String)rowObject.getString("billtype"), (String)"sourcebilltype,entry.sourceentryid,entry.e_issuccess,entry.e_amount,entry.e_isrefund,entry.e_refundamt,entry.e_refunddes", (QFilter[])filters.toArray(new QFilter[0]));
                Long sourceEntryId = this.agentWriteBack(billObject, entryId, list);
                if (!AgentPayBillHelper.isDelegPush((DynamicObject)billObject)) continue;
                Set setLongs = CasBotpHelper.getSrcBillByDestBill((Long)billObject.getLong("id"), (String)"cas_agentpaybill", (String)"cas_agentpaybill");
                for (Long id : setLongs) {
                    DynamicObject sourceAgentBill = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)billObject.getDynamicObjectType());
                    this.agentWriteBack(sourceAgentBill, sourceEntryId, list);
                }
            }
            WriteBackTaskHelper.batchAddRealtimeTaskList(list, (WriteBackOperateEnum)WriteBackOperateEnum.REFUND, AgentWriteBackConsumer.class);
        }
    }

    private void saveRecBill(Long rebillid) {
        DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)rebillid, (String)"cas_recbill");
        recbill.set("isrefund", (Object)true);
        recbill.set("isfullrefund", (Object)true);
        BigDecimal actpayamt = (BigDecimal)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("actpayamt"), BigDecimal.class);
        BigDecimal actrecamt = recbill.getBigDecimal("actrecamt");
        BigDecimal actRecAmtFee = actrecamt.add(recbill.getBigDecimal("fee"));
        if (actRecAmtFee.compareTo(actpayamt) != 0) {
            recbill.set("isfullrefund", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recbill});
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        validators.add(new ReceivingBillRefundValidator());
    }

    private void payRefund(DynamicObject payBill, BigDecimal refundAmt, String description) {
        BigDecimal e_refundamt_i;
        BigDecimal actpayamt = payBill.getBigDecimal("actpayamt");
        this.param.put("isfullrefund", Boolean.TRUE);
        if (refundAmt.compareTo(actpayamt) != 0) {
            this.param.put("isfullrefund", Boolean.FALSE);
        }
        payBill.set("billstatus", (Object)BillStatusEnum.REFUND.getValue());
        DynamicObject feeBill = RefundOpHelper.resetPayAndFeeStatusForRefund((DynamicObject)payBill, (String)BillStatusEnum.REFUND.getValue());
        DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
        List sortEntry = entry.stream().sorted(Comparator.comparing(dynamicObject -> dynamicObject.getBigDecimal("e_payableamt"))).collect(Collectors.toList());
        HashMap<Long, BigDecimal> regundAmtMap = new HashMap<Long, BigDecimal>(sortEntry.size());
        for (DynamicObject d : sortEntry) {
            e_refundamt_i = d.getBigDecimal("e_payableamt");
            if (e_refundamt_i.compareTo(refundAmt) <= 0) {
                refundAmt = refundAmt.subtract(e_refundamt_i);
                regundAmtMap.put(d.getLong("id"), e_refundamt_i);
                continue;
            }
            regundAmtMap.put(d.getLong("id"), refundAmt);
            break;
        }
        for (DynamicObject d : entry) {
            e_refundamt_i = (BigDecimal)regundAmtMap.get(d.getLong("id"));
            if (e_refundamt_i == null) continue;
            d.set("e_refundamt", (Object)e_refundamt_i);
            d.set("e_refunddes", (Object)description);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
        if (EmptyUtil.isNoEmpty((DynamicObject)feeBill)) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{feeBill});
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        OperateServiceHelper.execOperate((String)"confirmrefund", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, (OperateOption)OperateOption.create());
    }

    private Long agentWriteBack(DynamicObject agentBill, Long entryId, ArrayList<WriteBackTaskInfo> list) {
        Long sourceEntryId = 0L;
        if (CasHelper.isNotEmpty((Object)agentBill.getString("sourcebilltype"))) {
            DynamicObjectCollection entrys = agentBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (!entryId.equals(entry.getLong("id"))) continue;
                sourceEntryId = entry.getLong("sourceentryid");
                this.param.put("entryPks", Collections.singletonList(entryId));
                WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
                taskInfo.setBillId((Long)agentBill.getPkValue());
                taskInfo.setDataEntity(agentBill.getDataEntityType().getName());
                taskInfo.setSourceEntity(agentBill.getString("sourcebilltype"));
                taskInfo.setParam(this.param);
                list.add(taskInfo);
                break;
            }
        }
        OperateServiceHelper.execOperate((String)"synctrigger", (String)agentBill.getDataEntityType().getName(), (Object[])new Object[]{agentBill.getPkValue()}, (OperateOption)OperateOption.create());
        return sourceEntryId;
    }
}

