/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.ReceivingIntegrateSaveValidator;

public class ReceivingIntegrateSaveOp
extends AbstractOperationServicePlugIn {
    private static final String IGNORE_AR_AP_JOURNAL = "ignoreArApJournal";

    public void onAddValidators(AddValidatorsEventArgs e) {
        ReceivingIntegrateSaveValidator receivingIntegrateSaveValidator = new ReceivingIntegrateSaveValidator();
        receivingIntegrateSaveValidator.setEntityKey("cas_recbill");
        e.addValidator((AbstractValidator)receivingIntegrateSaveValidator);
        super.onAddValidators(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Object[] dataEntities = e.getDataEntities();
        Map variables = this.getOption().getVariables();
        boolean ignoreArApJournal = Boolean.parseBoolean(variables.getOrDefault(IGNORE_AR_AP_JOURNAL, "false"));
        if (EmptyUtil.isNoEmpty((Object[])dataEntities) && !ignoreArApJournal) {
            List recBillIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            Map recBillMap = Collections.singletonMap("cas_recbill", recBillIds);
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"CasJournalGeneratorService", (String)"generateJournal", (Object[])new Object[]{recBillMap});
        }
    }
}

