/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.changebill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cas.business.sign.PayChgReviewExecutor;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.sign.ISignExecutor;
import kd.fi.cas.util.EmptyUtil;

public class PayInfoAutoConfirmOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PayInfoAutoConfirmOp.class);
    AtomicBoolean needSign = new AtomicBoolean(false);
    private List<String> errMsgList = new ArrayList<String>();
    public static final String KEY_ERR_MSG = "_SignHandler_KEY_ERR_MSG";
    private static final String RECCHG = "recchg";
    public static final String OP_CONFIRM = "confirm";
    public static final String KEY_SUCCESSIDLIST = "_KEY_SUCCESSIDLIST_";
    List<String> requestIds = null;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("chgtype");
        fieldKeys.add(RECCHG);
        fieldKeys.add("sourcetype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("payeracctcash");
        fieldKeys.add("entrys");
        fieldKeys.add("entrys.sourceentryid");
        fieldKeys.add("billstatus");
        fieldKeys.add("billno");
        fieldKeys.add("changestatus");
        fieldKeys.add("entrys.afterrecerbank");
        fieldKeys.add("entrys.afterrecerbankname");
        fieldKeys.add("entrys.chgpayeeaccbankid");
        fieldKeys.add("entrys.changerecacctbank");
        fieldKeys.add("entrys.chgpayeeaccbank");
        fieldKeys.add("entrys.sourceentryid");
        fieldKeys.add("entrys.chguseraccbank");
        fieldKeys.add("entrys.chgaccountname");
        fieldKeys.add("iscashconfirm");
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_paychgbill", (String)"entrys"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        OperationResult result = OperationServiceHelper.executeOperate((String)OP_CONFIRM, (String)"cas_paychgbill", (DynamicObject[])e.getDataEntities(), (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            DynamicObject[] dataList = e.getDataEntities();
            String entityName = e.getDataEntities()[0].getDataEntityType().getName();
            ArrayList<DynamicObject> filterList = new ArrayList<DynamicObject>(dataList.length);
            boolean hasData = false;
            boolean isPayApply = false;
            for (DynamicObject object : dataList) {
                if (!object.getString("chgtype").equals(RECCHG) || !object.getString("sourcetype").equals("cas_payapplybill")) {
                    filterList.add(object);
                    hasData = true;
                    continue;
                }
                isPayApply = true;
            }
            if (!hasData && isPayApply) {
                return;
            }
            ArrayList errors = new ArrayList();
            List idList = filterList.stream().map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
            Map request = MutexServiceHelper.batchRequest(idList, (String)entityName, (String)OP_CONFIRM);
            this.requestIds = MutexServiceHelper.getRequestResultList((DynamicObject[])dataList, errors, (Map)request);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        try {
            this.needSign.set(this.getHandler(true, e));
            if (!this.needSign.get()) {
                String errorMessage = this.getErrorMessage();
                if (errorMessage != null && errorMessage.length() > 0) {
                    if (e.getDataEntities().length > 1) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f, \u4f46\u6709\u90e8\u5206\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4%s", (String)"PayInfoChgCrossBillSignPlugin_1_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), errorMessage));
                    }
                    throw new KDBizException(errorMessage);
                }
                return;
            }
        }
        catch (Exception ex) {
            this.needSign.set(false);
            if (ex instanceof IllegalArgumentException) {
                throw new KDBizException(ex.getMessage());
            }
            throw ex;
        }
        finally {
            if (this.requestIds != null && !this.needSign.get()) {
                logger.info("requestIds:{}", (Object)this.requestIds.toString());
                MutexServiceHelper.batchRelease(this.requestIds, (String)e.getDataEntities()[0].getDataEntityType().getName(), (String)OP_CONFIRM);
            }
        }
    }

    public Boolean getHandler(boolean isInit, AfterOperationArgs e) {
        String entityName = e.getDataEntities()[0].getDataEntityType().getName();
        if (this.requestIds == null) {
            return Boolean.FALSE;
        }
        DynamicObject[] payBillArr = BusinessDataServiceHelper.load((Object[])this.requestIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        HashMap result = new HashMap(0);
        for (DynamicObject tpayBillArr : payBillArr) {
            String sourceType = tpayBillArr.getString("sourcetype");
            List tList = result.get(sourceType) == null ? new ArrayList() : (List)result.get(sourceType);
            tList.add(tpayBillArr);
            result.put(sourceType, tList);
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u6e90\u5355\u7c7b\u578b\u7684\u6570\u636e\u8fdb\u884c\u53d8\u66f4\u786e\u8ba4\u3002", (String)"PayInfoChgCrossBillSignPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        String oneSourceType = null;
        List oneDynamicObjList = null;
        for (Map.Entry entry : result.entrySet()) {
            oneSourceType = (String)entry.getKey();
            oneDynamicObjList = (List)entry.getValue();
        }
        return this.execute((ISignExecutor)new PayChgReviewExecutor(oneDynamicObjList, oneSourceType));
    }

    private Boolean execute(ISignExecutor executor) {
        boolean needSign = false;
        try {
            List waitSignBillIdList = executor.prepareSignData();
            if (waitSignBillIdList.isEmpty()) {
                needSign = false;
                logger.info(executor.getErrorMessage());
                Boolean bl = needSign;
                return bl;
            }
            logger.info("prepareSignData\u6267\u884c\u6210\u529f\uff0cwaitSignBillIdList: {}", (Object)waitSignBillIdList);
            OperationResult signResult = executor.doSignOperation(waitSignBillIdList, OperateOption.create());
            if (signResult.isSuccess()) {
                logger.info("doSignOperation\u6267\u884c\u6210\u529f\u3002");
                List successPkIds = signResult.getSuccessPkIds();
                if (successPkIds != null && !successPkIds.isEmpty()) {
                    executor.doSignOperateSuccess(successPkIds);
                    logger.info("doSignOperateSuccess\u6267\u884c\u6210\u529f\u3002successPkIds: {}", (Object)successPkIds);
                }
            } else {
                needSign = true;
                logger.info(OperateServiceHelper.decodeErrorMsg((OperationResult)signResult));
            }
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u786e\u8ba4\u5f02\u5e38\u3002", (Throwable)e);
            executor.doSignOperateFailed(e);
            throw e;
        }
        finally {
            String errMsg = executor.getErrorMessage();
            if (EmptyUtil.isNotEmpty((String)errMsg)) {
                this.errMsgList.add(errMsg);
            }
        }
        return needSign;
    }

    public String getErrorMessage() {
        StringBuilder sb = new StringBuilder();
        for (String errMsg : this.errMsgList) {
            sb.append(errMsg).append('\n');
        }
        return sb.length() > 0 ? sb.toString() : null;
    }
}

