/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.changebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.ChangeStatusEnum;
import kd.fi.cas.validator.changebill.PayInfoChgConfirmValidator;

public class PaySureRecChgOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PaySureRecChgOp.class);
    private static final String RECCHG = "recchg";
    private static final String SQL_UPDATE_AGPAYBILL = "update t_cas_agentpaybill_e set fchangestatus = ? where fid = ? and fchangestatus ='changing'";
    private static final String SQL_UPDATE_PAYMENTBILL = "update t_cas_paymentbill_e set fchangestatus = ? where fid = ? and fchangestatus ='changing'";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("chgtype");
        fieldKeys.add("sourcetype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("entrys");
        fieldKeys.add("entrys.sourceentryid");
        fieldKeys.add("entrys.afterrecerbank");
        fieldKeys.add("entrys.chguseraccbank");
        fieldKeys.add("entrys.changerecacctbank");
        fieldKeys.add("entrys.chgpayeeaccbankid");
        fieldKeys.add("entrys.chgpayeeaccbank");
        fieldKeys.add("entrys.chgaccountname");
        fieldKeys.add("iscashconfirm");
        fieldKeys.add("entrys.afterrecerbankname");
        fieldKeys.add("billstatus");
        fieldKeys.add("iscashconfirm");
        fieldKeys.add("billno");
        fieldKeys.add("changestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        PayInfoChgConfirmValidator validator = new PayInfoChgConfirmValidator();
        e.addValidator((AbstractValidator)validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String changeStaus = ChangeStatusEnum.CHANGED.getValue();
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObjectCollection entrys;
            String entrustOrgKey;
            int result;
            String sourcetype = dynamicObject.getString("sourcetype");
            Long sourcebillid = dynamicObject.getLong("sourcebillid");
            DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)sourcetype);
            Long payBillId = payBill.getLong("id");
            if (!"cas_paybill".equals(sourcetype) && !"cas_agentpaybill".equals(sourcetype)) continue;
            if ("cas_agentpaybill".equals(sourcetype)) {
                result = DB.update((DBRoute)DBRouteConst.cas, (String)SQL_UPDATE_AGPAYBILL, (Object[])new Object[]{changeStaus, payBillId});
                if (result < 1) {
                    logger.error("update agpaybill sql fail,billId:" + payBillId + "");
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u4ee3\u53d1\u5355\u3010%1$s\u3011\u66f4\u65b0\u53d8\u66f4\u72b6\u6001\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PaySureRecChgOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), payBill.getString("billno")));
                }
                logger.info("update agpaybill sql succusse,billId:" + payBillId + "");
                entrustOrgKey = "delegorg";
            } else {
                result = DB.update((DBRoute)DBRouteConst.cas, (String)SQL_UPDATE_PAYMENTBILL, (Object[])new Object[]{changeStaus, payBillId});
                if (result < 1) {
                    logger.error("update agpaybill sql fail,billId:" + payBillId + "");
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u4ee3\u53d1\u5355\u3010%1$s\u3011\u66f4\u65b0\u53d8\u66f4\u72b6\u6001\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PaySureRecChgOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), payBill.getString("billno")));
                }
                logger.info("update agpaybill sql succusse,billId:" + payBillId + "");
                entrustOrgKey = "entrustorg";
            }
            payBill.set("changestatus", (Object)ChangeStatusEnum.CHANGED.getValue());
            if (dynamicObject.getString("chgtype").equals(RECCHG) && "cas_paybill".equals(dynamicObject.getString("sourcetype")) && (entrys = (DynamicObjectCollection)dynamicObject.get("entrys")) != null && entrys.size() > 0) {
                DynamicObject dynamicObjectCH = (DynamicObject)entrys.get(0);
                if (payBill != null) {
                    DynamicObject bank = dynamicObjectCH.getDynamicObject("afterrecerbank");
                    String bankName = dynamicObjectCH.getString("afterrecerbankname");
                    Long changBankID = dynamicObjectCH.getLong("chgpayeeaccbankid");
                    if (bank != null) {
                        payBill.set("payeebank", (Object)bank);
                    }
                    if (changBankID != null) {
                        payBill.set("payeeacctbank", (Object)changBankID);
                    }
                    if (bankName != null && !"".equals(bankName)) {
                        payBill.set("payeebankname", (Object)bankName);
                    }
                }
            }
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            if ("paychg".equals(dynamicObject.getString("chgtype")) && payBill.get(entrustOrgKey) != null) {
                payBill.set("reason", null);
            }
            SaveServiceHelper.update((DynamicObject)payBill);
        }
    }
}

