/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.exchange;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class ExchangeCancelMarkNoNeedMatchOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("matchflag");
        fieldKeys.add("buymatchflag");
        fieldKeys.add("sellmatchflag");
        fieldKeys.add("handmarknomatch");
        fieldKeys.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bizBill = dataEntity.getDataEntity();
                    String matchFlag = bizBill.getString("matchflag");
                    String billStatus = bizBill.getString("billstatus");
                    if (AutoMatchFlagEnum.NONEED.getValue().equals(matchFlag) && !StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue()})) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5339\u914d\u6807\u8bc6\u4e3a\u65e0\u9700\u5339\u914d\u4e14\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u4f5c\u5e9f\u6216\u9000\u5355\u624d\u5141\u8bb8\u8be5\u64cd\u4f5c\u3002", (String)"BizBillCancelMarkNoNeedMatchOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject bizBill : dataEntities = e.getDataEntities()) {
            bizBill.set("matchflag", (Object)AutoMatchFlagEnum.NONE.getValue());
            bizBill.set("buymatchflag", (Object)AutoMatchFlagEnum.NONE.getValue());
            bizBill.set("sellmatchflag", (Object)AutoMatchFlagEnum.NONE.getValue());
            bizBill.set("handmarknomatch", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

