/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.journal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.journal.BankJournalDownloadService;
import kd.fi.cas.exception.BankJournalDownIException;
import kd.fi.cas.pojo.BankJournalDownload;
import kd.fi.cas.util.DateUtils;

public class BankJournalDownloadOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BankJournalDownloadOp.class);
    private static final Integer GET_ARRAY_INDEX = 2;
    private static final Integer INITIAL_CAPACITY = 10;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Object object;
        super.beginOperationTransaction(e);
        DynamicObject data = e.getDataEntities()[0];
        DynamicObjectCollection orgColl = data.getDynamicObjectCollection("org");
        List orgIds = orgColl.stream().map(org -> org.getLong("fbasedataid_id")).collect(Collectors.toList());
        DynamicObjectCollection accounts = data.getDynamicObjectCollection("accountbank");
        List accountIds = accounts.stream().map(account -> account.getLong(GET_ARRAY_INDEX.intValue())).collect(Collectors.toList());
        Date beginDate = data.getDate("begindate");
        Date endDate = DateUtils.getDataFormat((Date)data.getDate("enddate"), (boolean)false);
        ArrayList<Object> ids = new ArrayList<Object>(INITIAL_CAPACITY);
        BankJournalDownload bjd = new BankJournalDownload().setOrgIds(orgIds).setAcctIds(accountIds).setBeginDate(beginDate).setEndDate(endDate);
        try {
            ids.addAll(BankJournalDownloadService.getInstance().download(bjd));
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        if (this.checkPeriod(data, ids, beginDate).booleanValue()) {
            return;
        }
        if (ids.isEmpty()) {
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u5185\u6ca1\u6709\u4ea4\u6613\u660e\u7ec6\u53ef\u4e0b\u8f7d\u4e3a\u5bf9\u94f6\u884c\u65e5\u8bb0\u8d26\u3002", (String)"BankJournalDownloadOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
            return;
        }
        if (ids.size() == 1 && (object = ids.get(0)) instanceof BankJournalDownIException) {
            BankJournalDownIException bankJournalDownIException = (BankJournalDownIException)object;
            this.operationResult.setMessage(bankJournalDownIException.getDescription());
            this.operationResult.setSuccess(false);
            return;
        }
        this.operationResult.setSuccess(true);
        this.operationResult.setSuccessPkIds(ids);
    }

    private Boolean checkPeriod(DynamicObject data, List<Object> ids, Date beginDate) {
        if (!ids.isEmpty()) {
            return false;
        }
        DynamicObjectCollection orgColl = data.getDynamicObjectCollection("org");
        List orgIds = orgColl.stream().map(org -> org.getLong("fbasedataid_id")).collect(Collectors.toList());
        QFilter filter = new QFilter("org", "in", orgIds);
        DynamicObject[] initDays = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"startperiod,currentperiod,org", (QFilter[])new QFilter[]{filter});
        ArrayList<String> endPeriodOrg = new ArrayList<String>(initDays.length);
        for (DynamicObject initDay : initDays) {
            Date currentPeriodBegin = initDay.getDate("currentperiod.begindate");
            if (currentPeriodBegin == null || beginDate.compareTo(currentPeriodBegin) >= 0) continue;
            String orgName = initDay.getString("org.name");
            endPeriodOrg.add(orgName);
        }
        if (endPeriodOrg.size() > 0) {
            String error = String.format(ResManager.loadKDString((String)"%1$s\u671f\u95f4\u5df2\u7ed3\u8d26\u3002", (String)"BankJournalDownloadOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), endPeriodOrg);
            this.operationResult.setMessage(error);
            this.operationResult.setSuccess(false);
            return true;
        }
        return false;
    }
}

