/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.overdraft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.PaymentBillBookJournalBuilder;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;

public class PaymentPayJournalServiceValidator
extends AbstractValidator {
    private JournalServiceAdapter journalServiceAdapter = null;

    public PaymentPayJournalServiceValidator(JournalServiceAdapter journalServiceAdapter) {
        this.journalServiceAdapter = journalServiceAdapter;
    }

    public void validate() {
        ArrayList<DynamicObject> bizBills = new ArrayList<DynamicObject>(10);
        boolean isFromCdm = this.getOption().getVariables().containsKey("draftbillno");
        boolean cdmBook = this.getOption().getVariables().containsKey("cdmbook");
        long currUserId = RequestContext.get().getCurrUserId();
        Map isNeedBooks = PayBillHepler.isNeedBookJournal(this.getDynamicObjs());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean isPromissory;
            boolean isNeedBook;
            DynamicObject bizBill = dataEntity.getDataEntity();
            bizBill.set("cashier", (Object)currUserId);
            boolean bl = isNeedBook = CasHelper.isEmpty((Object)bizBill.get("entrustorg")) && (!isFromCdm || cdmBook);
            if ("bei".equals(bizBill.getString("paymentchannel")) && PaymentBillPluginHelper.paymentIdentify((DynamicObject)bizBill)) continue;
            DynamicObject settleType = bizBill.getDynamicObject("settletype");
            boolean bl2 = isPromissory = settleType != null ? SettleMentTypeEnum.PROMISSORY.getValue().equals(settleType.getString("settlementtype")) : false;
            if (!isFromCdm && isPromissory || !isNeedBook || !this.isNeedBook(isNeedBooks, bizBill.getLong("id"))) continue;
            bizBills.add(bizBill);
        }
        if (bizBills.size() > 0) {
            HashMap errorResult = new HashMap();
            PaymentBillBookJournalBuilder builder = new PaymentBillBookJournalBuilder();
            builder.setIsValidata(Boolean.TRUE);
            builder.setOption(this.getOption());
            this.journalServiceAdapter.validateBooks((IBookJournalBuilder)builder, bizBills, errorResult);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject info = dataEntity.getDataEntity();
                Exception bookException = (Exception)errorResult.get(info.getLong("id"));
                if (null == bookException) continue;
                this.addMessage(dataEntity, bookException.getMessage(), ErrorLevel.Error);
            }
        }
    }

    private List<DynamicObject> getDynamicObjs() {
        ArrayList<DynamicObject> bizBills = new ArrayList<DynamicObject>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            bizBills.add(dataEntity.getDataEntity());
        }
        return bizBills;
    }

    private boolean isNeedBook(Map<Long, Boolean> isNeedBooks, Long billId) {
        return isNeedBooks.get(billId) != null && isNeedBooks.get(billId) != false;
    }
}

