/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.helper.LoggerPrintHelper;
import kd.fi.cas.validator.payapply.PayApplyCancleComfirmScheValidator;

public class PayApplyCancleComfirmScheOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PayApplyCancleComfirmScheOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("cas_businessentry");
        fieldKeys.add("cas_payapplyentry");
        fieldKeys.add("cas_payinfo");
        fieldKeys.add("payorg");
        fieldKeys.add("payeecurrency");
        fieldKeys.add("paidstatus");
        fieldKeys.add("backbillflag");
        fieldKeys.add("partpaysche");
        fieldKeys.add("partpay");
        fieldKeys.add("planpaydate");
        fieldKeys.add("scheuser");
        fieldKeys.add("billno");
        fieldKeys.add("invalidflag");
        fieldKeys.add("entry_isdosche");
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_paystatus"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_settlementtype"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_payeraccbank"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_paymentchannel"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_usage"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_isdosche"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_invalid"));
        fieldKeys.add(String.format("%s.%s", "cas_payapplyentry", "e_settlementtype"));
        fieldKeys.add(String.format("%s.%s", "cas_payapplyentry", "e_chgstatus"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PayApplyCancleComfirmScheValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.dealCancleComfirmSche(e.getDataEntities());
    }

    private void dealCancleComfirmSche(DynamicObject[] payApplyBills) {
        Set ids = Arrays.stream(payApplyBills).filter(Objects::nonNull).map(o -> o.getPkValue()).collect(Collectors.toSet());
        logger.info(String.format("\u5f00\u59cb\u8fdb\u884c\u786e\u8ba4\u6392\u6b3e\u64cd\u4f5c\uff0c\u8fdb\u884c\u6392\u6b3e\u7684 ID \u4e3a\uff1a%s", LoggerPrintHelper.printCollectionLogger(ids)));
        ArrayList<DynamicObject> updateBill = new ArrayList<DynamicObject>(payApplyBills.length);
        for (DynamicObject payApplyBill : payApplyBills) {
            DynamicObjectCollection entrys = payApplyBill.getDynamicObjectCollection("cas_payinfo");
            entrys.stream().filter(Objects::nonNull).forEach(entry -> {
                String status = entry.getString("entry_paystatus");
                if (PayStatusEnum.PAYSCHEFUND.getValue().equals(status)) {
                    entry.set("entry_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
                    entry.set("entry_isdosche", (Object)"0");
                }
            });
            DynamicObject updateObj = PayApplyBillHelper.updateHeaderInfo((DynamicObjectCollection)entrys, (DynamicObject)payApplyBill);
            updateObj.set("scheuser", null);
            updateBill.add(updateObj);
        }
        SaveServiceHelper.save((DynamicObject[])updateBill.toArray(new DynamicObject[0]));
    }
}

