/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.LoggerPrintHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.model.DoScheInfoModel;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.payapply.PayApplyComfirmScheValidator;
import kd.fi.cas.validator.payapply.PayDetailIsChangeingValidator;

public class PayApplyComfirmScheOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PayApplyComfirmScheOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("cas_businessentry");
        fieldKeys.add("cas_payapplyentry");
        fieldKeys.add("cas_payinfo");
        fieldKeys.add("payorg");
        fieldKeys.add("payeecurrency");
        fieldKeys.add("paidstatus");
        fieldKeys.add("backbillflag");
        fieldKeys.add("partpaysche");
        fieldKeys.add("partpay");
        fieldKeys.add("planpaydate");
        fieldKeys.add("scheuser");
        fieldKeys.add("billno");
        fieldKeys.add("invalidflag");
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_paystatus"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_settlementtype"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_exchangerate"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_exratetable"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_exratedate"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_paycurrency"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_payamount"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_isdiffcur"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_payeraccbank"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_paymentchannel"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_usage"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_isdosche"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_expectdate"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_payerbank"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_payeeamount"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_balance"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_lastmodifytime"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_draftbill"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_settletnumber"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_draftamttotal"));
        fieldKeys.add(String.format("%s.%s", "cas_payapplyentry", "e_settlementtype"));
        fieldKeys.add(String.format("%s.%s", "cas_payapplyentry", "e_chgstatus"));
        fieldKeys.add(String.format("%s.%s", "cas_payapplyentry", "e_payeeamount"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_quotation"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_invalid"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String isCheck = this.getOption().getVariableValue("isCheck", "1");
        if (isCheck.equals("1")) {
            e.getValidators().add(new PayApplyComfirmScheValidator());
        }
        e.getValidators().add(new PayDetailIsChangeingValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.dealComfirmSche(e.getDataEntities());
    }

    private void dealComfirmSche(DynamicObject[] payApplyBills) {
        String scheInfoStr = this.getOption().getVariableValue("doScheInfo", "");
        DoScheInfoModel doScheInfo = (DoScheInfoModel)JSON.parseObject((String)scheInfoStr, DoScheInfoModel.class);
        Set ids = Arrays.stream(payApplyBills).filter(Objects::nonNull).map(o -> o.getPkValue()).collect(Collectors.toSet());
        logger.info(String.format("\u5f00\u59cb\u8fdb\u884c\u786e\u8ba4\u6392\u6b3e\u64cd\u4f5c\uff0c\u8fdb\u884c\u6392\u6b3e\u7684 ID \u4e3a\uff1a%s", LoggerPrintHelper.printCollectionLogger(ids)));
        ArrayList<DynamicObject> updateBill = new ArrayList<DynamicObject>(payApplyBills.length);
        DynamicObject payCurrecny = null;
        DynamicObject exchangeRateTable = null;
        if (doScheInfo != null) {
            payCurrecny = BusinessDataServiceHelper.loadSingle((Object)doScheInfo.getPayCurrecnyId(), (String)"bd_currency");
            if (doScheInfo.isDiffPay()) {
                exchangeRateTable = BusinessDataServiceHelper.loadSingle((Object)doScheInfo.getExchangeRateTableId(), (String)"bd_exratetable");
            }
        }
        for (DynamicObject payApplyBill : payApplyBills) {
            DynamicObjectCollection payEntry = payApplyBill.getDynamicObjectCollection("cas_payapplyentry");
            Set settlementType = payEntry.stream().filter(Objects::nonNull).filter(entry -> EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("e_settlementtype"))).map(entry -> entry.getDynamicObject("e_settlementtype").getString("settlementtype")).collect(Collectors.toSet());
            if (settlementType.contains(SettleMentTypeEnum.DCEP.getValue())) continue;
            DynamicObject payeeCurrency = payApplyBill.getDynamicObject("payeecurrency");
            DynamicObjectCollection entrys = payApplyBill.getDynamicObjectCollection("cas_payinfo");
            for (DynamicObject entry2 : entrys) {
                String status = entry2.getString("entry_paystatus");
                if (!PayStatusEnum.NOTPAYING.getValue().equals(status) || entry2.getBoolean("entry_invalid")) continue;
                entry2.set("entry_paystatus", (Object)PayStatusEnum.PAYSCHEFUND.getValue());
                entry2.set("entry_isdosche", (Object)"1");
                if (null == doScheInfo) continue;
                if (DraftHelper.isSettle((Object)entry2.getDynamicObject("entry_settlementtype"))) {
                    entry2.set("entry_draftbill", null);
                    entry2.set("entry_settletnumber", null);
                    entry2.set("entry_draftamttotal", null);
                }
                entry2.set("entry_settlementtype", (Object)doScheInfo.getSettlementTypeId());
                entry2.set("entry_payeraccbank", (Object)doScheInfo.getPayerAcctBankId());
                entry2.set("entry_paymentchannel", (Object)doScheInfo.getPayChannel());
                entry2.set("entry_payerbank", (Object)doScheInfo.getBankId());
                entry2.set("entry_lastmodifytime", (Object)doScheInfo.getLastUpdateDate());
                Optional.ofNullable(doScheInfo.getAvd()).ifPresent(avd -> entry2.set("entry_expectdate", avd));
                Optional.ofNullable(doScheInfo.getTransferPost()).ifPresent(usage -> {
                    if (!usage.trim().isEmpty()) {
                        entry2.set("entry_usage", usage);
                    }
                });
                entry2.set("entry_balance", (Object)Optional.ofNullable(doScheInfo).map(o -> o.getBalance()).orElseGet(() -> BigDecimal.ZERO));
                entry2.set("entry_paycurrency", (Object)payCurrecny);
                boolean isDiffPay = doScheInfo.isDiffPay();
                entry2.set("entry_isdiffcur", (Object)isDiffPay);
                BigDecimal exchangeRate = BigDecimal.ONE.setScale(10);
                String quoteType = "0";
                if (isDiffPay) {
                    if (payeeCurrency != null && payCurrecny != null && exchangeRateTable != null && doScheInfo != null) {
                        Map exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)payeeCurrency.getLong("id"), (Long)payCurrecny.getLong("id"), (Long)exchangeRateTable.getLong("id"), (Date)doScheInfo.getExchangeRateDate());
                        if (exchangeRateByRules.get("exchangeRate") != null) {
                            exchangeRate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                        }
                        if (exchangeRateByRules.get("quoteType") != null && ((Boolean)exchangeRateByRules.get("quoteType")).booleanValue()) {
                            quoteType = "1";
                        }
                    }
                    entry2.set("entry_exratetable", (Object)exchangeRateTable);
                    entry2.set("entry_exratedate", (Object)doScheInfo.getExchangeRateDate());
                    entry2.set("entry_exchangerate", (Object)exchangeRate);
                } else {
                    entry2.set("entry_exratetable", null);
                    entry2.set("entry_exratedate", null);
                    entry2.set("entry_exchangerate", (Object)exchangeRate);
                }
                BigDecimal payeeAmount = entry2.getBigDecimal("entry_payeeamount");
                BigDecimal payAmount = null;
                payAmount = payCurrecny != null ? QuotationHelper.callToCurrency((BigDecimal)payeeAmount, (BigDecimal)exchangeRate, (String)quoteType, (int)payCurrecny.getInt("amtprecision")) : QuotationHelper.callToCurrency((BigDecimal)payeeAmount, (BigDecimal)exchangeRate, (String)quoteType, (int)0);
                entry2.set("entry_payamount", (Object)payAmount);
            }
            DynamicObject updateObj = PayApplyBillHelper.updateHeaderInfo((DynamicObjectCollection)entrys, (DynamicObject)payApplyBill);
            RequestContext requestContext = RequestContext.get();
            Long userId = requestContext.getCurrUserId();
            updateObj.set("scheuser", (Object)userId);
            updateBill.add(updateObj);
        }
        SaveServiceHelper.save((DynamicObject[])updateBill.toArray(new DynamicObject[0]));
    }
}

