/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.bean.LockResult;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.util.DraftBillUtils;
import kd.fi.cas.util.EmptyUtil;

public class PayApplySaveDraftOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PayApplySaveDraftOp.class);
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();
    private DynamicObject[] payApplyDb;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(String.join((CharSequence)".", "cas_payinfo", "entry_settletnumber"));
        fieldKeys.add(String.join((CharSequence)".", "cas_payinfo", "entry_draftbill"));
        fieldKeys.add(String.join((CharSequence)".", "cas_payinfo", "entry_paystatus"));
        fieldKeys.add(String.join((CharSequence)".", "cas_payinfo", "entry_invalid"));
        fieldKeys.add("cas_draftinfo");
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "srcbillindex"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "srcbillid"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "srcbilltype"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "paybillcurrency"));
        fieldKeys.add("cas_payinfo");
        fieldKeys.add("cas_payinfo.entry_draftbill");
        fieldKeys.add("cas_draftinfo.srcbillid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Set payApplyIdSet = Arrays.stream(e.getDataEntities()).map(x -> x.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] dataEntities = e.getDataEntities();
        this.fillBillDraftInfoEntry(dataEntities);
        DynamicObjectType casPayApplyType = e.getDataEntities()[0].getDynamicObjectType();
        this.payApplyDb = BusinessDataServiceHelper.load((Object[])payApplyIdSet.toArray(), (DynamicObjectType)casPayApplyType);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        ArrayList<DraftLockInfo> lockOrReleaseInfoList = new ArrayList<DraftLockInfo>(10);
        Map<Long, DynamicObject> payApplyIdAndMapDb = Arrays.stream(this.payApplyDb).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        for (DynamicObject data : e.getDataEntities()) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
            Set<Long> lockedDraftno = this.getDraftIds(data, false);
            ArrayList<Long> lockDraftIds = new ArrayList<Long>(lockedDraftno);
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            Map<Long, DynamicObject> idAndDraftMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getDynamicObject("draftbillinfo")));
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setSourceBillType(data.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(data.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(data.getLong("id")));
            for (Long lockDraftId : lockDraftIds) {
                DynamicObject draft = (DynamicObject)idAndDraftMap.get(lockDraftId);
                if (EmptyUtil.isEmpty((DynamicObject)draft)) continue;
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillId(lockDraftId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountLockSubInfo.setDealAmount(dealAmount);
                Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockSubInfo.setBillLogId(billLogId);
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                if (DraftBillUtils.isPayBill((String)draft.getString("rptype"))) {
                    draftAmountLockSubInfo.setBillTrade(LogBizTypeEnum.RELATEDPAY.getValue());
                } else {
                    draftAmountLockSubInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                }
                draftLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo);
            }
            ArrayList<Object> lockDraftIdsDB = new ArrayList(10);
            HashMap draftIdDealAmountMapDB = new HashMap(10);
            HashMap draftIdLogIdMapDB = new HashMap(10);
            Map idAndDraftMapDB = new HashMap(8);
            DynamicObject payApplyBillDB = payApplyIdAndMapDb.get(data.getLong("id"));
            if (EmptyUtil.isNoEmpty((DynamicObject)payApplyBillDB)) {
                DynamicObjectCollection entrysDB = payApplyBillDB.getDynamicObjectCollection("cas_draftinfo");
                Set<Long> lockDraftIdsSet = this.getDraftIds(payApplyBillDB, false);
                lockDraftIdsDB = new ArrayList<Long>(lockDraftIdsSet);
                draftIdDealAmountMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                draftIdLogIdMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                idAndDraftMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getDynamicObject("draftbillinfo"), (o1, o2) -> o1, HashMap::new));
            }
            ArrayList<Long> deletedLockDraftIds = new ArrayList<Long>(10);
            for (Long lockDraftIdDB : lockDraftIdsDB) {
                if (lockDraftIds.contains(lockDraftIdDB)) continue;
                deletedLockDraftIds.add(lockDraftIdDB);
            }
            for (Long deletedLockDraftId : deletedLockDraftIds) {
                DynamicObject draft = (DynamicObject)idAndDraftMapDB.get(deletedLockDraftId);
                if (EmptyUtil.isEmpty((DynamicObject)draft)) continue;
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(deletedLockDraftId);
                BigDecimal dealAmount = draftIdDealAmountMapDB.get(deletedLockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMapDB.get(deletedLockDraftId);
                draftAmountLockInfo.setDealAmount(dealAmount);
                Long draftLogId = draftIdLogIdMapDB.get(deletedLockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMapDB.get(deletedLockDraftId);
                draftAmountLockInfo.setBillLogId(draftLogId);
                if (DraftBillUtils.isPayBill((String)draft.getString("rptype"))) {
                    draftAmountLockInfo.setBillTrade(LogBizTypeEnum.RELATEDPAY.getValue());
                } else {
                    draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                }
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
                draftLockInfo.getLockSubInfoList().add(draftAmountLockInfo);
            }
            if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
            lockOrReleaseInfoList.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(lockOrReleaseInfoList)) {
            logger.info("PayApplyPayInvalidOp updateBillsByLog is start," + JSON.toJSONString(lockOrReleaseInfoList));
            List lockResults = this.draftLockServiceHelper.releaseOrLockDraft(lockOrReleaseInfoList);
            if (!EmptyUtil.isEmpty((Collection)lockResults)) {
                Map<Long, LockResult> payIdAndDyMap = lockResults.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getSourceBillId())).collect(Collectors.toMap(LockResult::getSourceBillId, x -> x));
                List<DynamicObject> payList = Arrays.stream(e.getDataEntities()).map(e1 -> e1).collect(Collectors.toList());
                for (DynamicObject data : payList) {
                    long payApplyBillId = data.getLong("id");
                    LockResult lockResult = payIdAndDyMap.get(payApplyBillId);
                    DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
                    for (DynamicObject entry : entrys) {
                        Long draftBillId = entry.getDynamicObject("draftbillinfo").getLong("id");
                        if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                        Map billIdLogIdMap = lockResult.getBillIdLogIdMap();
                        boolean success = lockResult.isSuccess();
                        Long billLogId = (Long)billIdLogIdMap.get(draftBillId);
                        if (!EmptyUtil.isNoEmpty((Long)billLogId) || !success) continue;
                        entry.set("draftbilllogid", (Object)String.valueOf(billLogId));
                    }
                }
                SaveServiceHelper.update((DynamicObject[])payList.toArray(new DynamicObject[0]));
            }
            logger.info("PayApplyPayInvalidOp updateBillsByLog is end");
        }
        HashMap<Long, Long> draftIdInfo = new HashMap<Long, Long>();
        boolean needUpdate = false;
        Set payAppIdSet = Arrays.stream(e.getDataEntities()).map(o -> o.getPkValue()).collect(Collectors.toSet());
        DynamicObject[] casPayapplybills = BusinessDataServiceHelper.load((Object[])payAppIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_payapplybill"));
        for (int i = 0; i < casPayapplybills.length; ++i) {
            DynamicObjectCollection payInfo = casPayapplybills[i].getDynamicObjectCollection("cas_payinfo");
            DynamicObjectCollection draftInfos = casPayapplybills[i].getDynamicObjectCollection("cas_draftinfo");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfos)) continue;
            for (DynamicObject info : payInfo) {
                DynamicObjectCollection draftBills = info.getDynamicObjectCollection("entry_draftbill");
                Long id = info.getLong("id");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)draftBills)) continue;
                for (DynamicObject draftBill : draftBills) {
                    Long draftid = draftBill.getDynamicObject("fbasedataid").getLong("id");
                    draftIdInfo.put(draftid, id);
                }
            }
            for (DynamicObject draftInfo : draftInfos) {
                Long draftId = draftInfo.getDynamicObject("draftbillinfo").getLong("id");
                Long entryId = (Long)draftIdInfo.get(draftId);
                Long srcBillId = draftInfo.getLong("srcbillid");
                if (srcBillId != null && srcBillId != 0L) continue;
                draftInfo.set("srcbillid", (Object)entryId);
                needUpdate = true;
            }
        }
        if (needUpdate) {
            SaveServiceHelper.update((DynamicObject[])casPayapplybills);
            logger.info("PayApplyPayInvalidOp setsrcbillid is end");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public Set<String> preparePropertys() {
                Set selectors = super.preparePropertys();
                selectors.add(String.join((CharSequence)".", "cas_payinfo", "entry_settletnumber"));
                selectors.add(String.join((CharSequence)".", "cas_payinfo", "entry_draftbill"));
                selectors.add(String.join((CharSequence)".", "cas_payinfo", "entry_paystatus"));
                return selectors;
            }

            public void validate() {
            }
        });
    }

    private Set<Long> getDraftIds(DynamicObject scheBill, boolean isClancel) {
        HashSet<Long> draftnoIds = new HashSet<Long>(0);
        if (null == scheBill) {
            return draftnoIds;
        }
        draftnoIds.addAll(PayApplyBillHelper.getDraftBillList((DynamicObjectCollection)scheBill.getDynamicObjectCollection("cas_payinfo"), (boolean)isClancel));
        return draftnoIds;
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.draftLockServiceHelper.rollback();
    }

    private void fillBillDraftInfoEntry(DynamicObject[] datas) {
        try {
            for (DynamicObject data : datas) {
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_payinfo");
                DynamicObjectCollection cas_draftinfoEntry = data.getDynamicObjectCollection("cas_draftinfo");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) || !EmptyUtil.isEmpty((DynamicObjectCollection)cas_draftinfoEntry) && cas_draftinfoEntry.size() != 0) continue;
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject payInfoData = (DynamicObject)entrys.get(i);
                    long srcbillid = payInfoData.getLong("id");
                    DynamicObjectCollection newDrafts = payInfoData.getDynamicObjectCollection("entry_draftbill");
                    if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)newDrafts) || newDrafts.size() <= 0) continue;
                    for (DynamicObject newDraft : newDrafts) {
                        DynamicObject fbasedataid = newDraft.getDynamicObject("fbasedataid");
                        if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
                        DynamicObject cas_draftinfo = cas_draftinfoEntry.addNew();
                        cas_draftinfo.set("transamount", (Object)fbasedataid.getBigDecimal("amount"));
                        cas_draftinfo.set("paybillcurrency", (Object)fbasedataid.getDynamicObject("currency").getLong("id"));
                        cas_draftinfo.set("draftbillinfo", (Object)fbasedataid);
                        cas_draftinfo.set("srcbillindex", (Object)(i + 1));
                        cas_draftinfo.set("srcbillid", (Object)srcbillid);
                        cas_draftinfo.set("srcbilltype", (Object)"cas_payapplybill");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("fillBillDraftInfoEntry has error:", (Throwable)e);
        }
    }
}

