/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payapply;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.QuotationEntryOpValidator;
import kd.fi.cas.validator.payapply.PayApplyAmountValidator;
import kd.fi.cas.validator.payapply.PayApplyEntryValidator;
import kd.fi.cas.validator.payapply.PayApplyIsFreezeValidator;
import kd.fi.cas.validator.payapply.PayApplySaveValidator;

public class PayApplySaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_quotation"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_payapplybill", (String)"cas_payapplyentry"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        String sql;
        int[] result;
        Long fid;
        super.beginOperationTransaction(e);
        Map variables = this.getOption().getVariables();
        if (variables.containsKey("entryPkValue") && (fid = (Long)DB.query((DBRoute)DBRouteConst.cas, (String)("select fid from t_cas_payinfoentry where fentryid = " + this.getOption().getVariableValue("entryPkValue")), (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong("fid");
                }
                return null;
            }
        })) != null && ((result = DB.executeBatch((DBRoute)DBRouteConst.cas, (String)(sql = "update t_cas_payinfoentry set flastmodifytime = ? where fpaystatus = 'C' and fentryid = " + this.getOption().getVariableValue("entryPkValue")), Collections.singletonList(new Object[]{new Date()}))).length < 1 || result[0] != 1)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u201c\u4ed8\u6b3e\u660e\u7ec6\u201d\u5df2\u5b8c\u6210\u201c\u6392\u6b3e\u201d\u6216\u8005\u201c\u4e0b\u63a8\u4ed8\u6b3e\u201d\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u3002", (String)"PayApplyEntryEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject info : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection payApplyEntry = info.getDynamicObjectCollection("cas_payapplyentry");
            for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
                Set ids;
                QFilter qFilter;
                DynamicObject acc;
                String ePayeeName = ((DynamicObject)payApplyEntry.get(rowIndex)).getString("e_payeename");
                String ePayeeAccBankNum = ((DynamicObject)payApplyEntry.get(rowIndex)).getString("e_payeeaccbanknum");
                if (!this.isCompany(payApplyEntry, rowIndex) || !EmptyUtil.isBlank((CharSequence)ePayeeName) || !EmptyUtil.isNotBlank((CharSequence)ePayeeAccBankNum) || (acc = BusinessDataServiceHelper.loadSingle((String)"am_accountbank", (String)"id,company", (QFilter[])new QFilter[]{qFilter = new QFilter("bankaccountnumber", "=", (Object)ePayeeAccBankNum)})) == null || (ids = AccountBankHelper.getUserAuthorityOrgs((Long)acc.getLong("id"))).size() != 1) continue;
                ((DynamicObject)payApplyEntry.get(rowIndex)).set("e_payeename", acc.get("company.name"));
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Set payAppIdSet = Arrays.stream(e.getDataEntities()).map(o -> o.getPkValue()).collect(Collectors.toSet());
        DynamicObject[] casPayapplybills = BusinessDataServiceHelper.load((Object[])payAppIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_payapplybill"));
        BigDecimal payeeamount = casPayapplybills[0].getBigDecimal("payeeamount");
        DynamicObjectCollection payEntry = casPayapplybills[0].getDynamicObjectCollection("cas_payapplyentry");
        DynamicObjectCollection payInfo = casPayapplybills[0].getDynamicObjectCollection("cas_payinfo");
        Map<String, BigDecimal> payEntryMap = payEntry.stream().collect(Collectors.groupingBy(o -> o.getString("e_splitid"), Collectors.mapping(o -> o.getBigDecimal("e_payeeamount"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<String, BigDecimal> payInfoMap = payInfo.stream().filter(item -> !PayStatusEnum.CLANCEL.getValue().equals(item.getString("entry_paystatus"))).collect(Collectors.groupingBy(o -> o.getString("entry_applyid"), Collectors.mapping(o -> o.getBigDecimal("entry_payeeamount"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        if (payEntryMap.size() != payInfoMap.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u6536\u6b3e\u603b\u989d", (String)"PayApplyEntryEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        BigDecimal e_payeeamount = payEntryMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        if (payeeamount.compareTo(e_payeeamount) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u6536\u6b3e\u603b\u989d", (String)"PayApplyEntryEdit_31", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        BigDecimal entry_payeeamount = payInfoMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        if (payeeamount.compareTo(entry_payeeamount) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u6536\u6b3e\u603b\u989d", (String)"PayApplyEntryEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PayApplySaveValidator());
        e.getValidators().add(new PayApplyAmountValidator());
        e.getValidators().add(new QuotationEntryOpValidator());
        e.getValidators().add(new PayApplyEntryValidator());
        e.getValidators().add(new PayApplyIsFreezeValidator());
    }

    private boolean isCompany(DynamicObjectCollection payApplyEntry, int rowIndex) {
        Object payeeType = ((DynamicObject)payApplyEntry.get(rowIndex)).get("e_payeetype");
        return AsstActTypeEnum.COMPANY.getValue().equals(payeeType);
    }
}

