/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payment;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.entrust.PaymentCancelEntrustPayScheValidator;
import kd.fi.cas.validator.paymentbill.PaymentPayScheCommonValidator;
import org.apache.commons.lang.StringUtils;

public class PaymentPayScheDelOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PaymentPayScheDelOp.class);
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("draftbill");
        fieldKeys.add("cas_draftinfo");
        fieldKeys.add(String.join((CharSequence)".", "entry", "e_sourcebillid"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
        fieldKeys.add("billno");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("settletype");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("deal billlog start");
        super.endOperationTransaction(e);
        String isDelByPaySche = this.operateOption.getVariables().getOrDefault("isdelbypaysche", "");
        String isdelbydraft = this.operateOption.getVariables().getOrDefault("isdelbydraft", "");
        if (EmptyUtil.isEmpty((String)isDelByPaySche) && EmptyUtil.isEmpty((String)isdelbydraft)) {
            logger.info("is not isDelByPaySche and isdelbydraft");
            DynamicObject[] infos = e.getDataEntities();
            ArrayList<DraftLockInfo> changeLockInfoList = new ArrayList<DraftLockInfo>();
            ArrayList<DraftLockInfo> lockOrReleaseInfoList = new ArrayList<DraftLockInfo>();
            for (DynamicObject info : infos) {
                Long draftLogId;
                BigDecimal dealAmount;
                DraftAmountLockSubInfo draftAmountLockInfo;
                String sourceBillType = info.getString("sourcebilltype");
                DynamicObject settleType = info.getDynamicObject("settletype");
                boolean isDraftSettleType = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
                boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
                if ("cdm_drafttradebill".equals(sourceBillType) || !isDraftSettleType && !checkDraft) {
                    logger.info("is not draftType or is from cdm" + info.getString("billno"));
                    continue;
                }
                DynamicObjectCollection draftbillColl = info.getDynamicObjectCollection("draftbill");
                DynamicObjectCollection entrys = info.getDynamicObjectCollection("cas_draftinfo");
                List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("draftbillinfo").getLong("id")).collect(Collectors.toList());
                List draftBillIds = draftbillColl.stream().filter(v -> v.getDynamicObject("fbasedataid") != null).map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                HashMap draftIdDealAmountMap = new HashMap(8);
                HashMap draftIdLogIdMap = new HashMap(8);
                if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys) || entrys.size() == 0) {
                    DynamicObject[] draftArr = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", lockDraftIds)});
                    draftIdDealAmountMap = Arrays.stream(draftArr).collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getBigDecimal("amount"), (o1, o2) -> o1, HashMap::new));
                } else {
                    draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                    draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                }
                DraftLockInfo draftLockInfo = new DraftLockInfo();
                draftLockInfo.setSourceBillId(Long.valueOf(info.getLong("id")));
                ArrayList draftLockBillIdList = new ArrayList(1);
                String sourcebilltype = info.getString("sourcebilltype");
                if ("cas_payapplybill".equals(sourcebilltype) && PayBillHepler.checkDraftAllInPayApplyBill((DynamicObject)info, draftLockBillIdList)) {
                    draftLockInfo.setTargetBillId(Long.valueOf(info.getLong("sourcebillid")));
                    draftLockInfo.setTargetBillType(sourcebilltype);
                    draftLockInfo.setSourceBillType(info.getDataEntityType().getName());
                    draftLockInfo.setBizBillNo(info.getString("billno"));
                    draftLockInfo.setSourceBillId(Long.valueOf(info.getLong("id")));
                    for (Long lockDraftId : draftBillIds) {
                        draftAmountLockInfo = new DraftAmountLockSubInfo();
                        draftAmountLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                        draftAmountLockInfo.setBillId(lockDraftId);
                        dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                        draftAmountLockInfo.setDealAmount(dealAmount);
                        draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                        draftAmountLockInfo.setBillLogId(draftLogId);
                        draftLockInfo.getLockSubInfoList().add(draftAmountLockInfo);
                    }
                    if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
                    changeLockInfoList.add(draftLockInfo);
                    continue;
                }
                for (Long lockDraftId : draftBillIds) {
                    draftAmountLockInfo = new DraftAmountLockSubInfo();
                    draftAmountLockInfo.setBillId(lockDraftId);
                    dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                    draftAmountLockInfo.setDealAmount(dealAmount);
                    draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                    draftAmountLockInfo.setBillLogId(draftLogId);
                    draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                    draftAmountLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
                    draftLockInfo.getLockSubInfoList().add(draftAmountLockInfo);
                }
                if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
                lockOrReleaseInfoList.add(draftLockInfo);
            }
            if (!CollectionUtils.isEmpty(changeLockInfoList)) {
                this.draftLockServiceHelper.changeDraftLock(changeLockInfoList);
            }
            if (!CollectionUtils.isEmpty(lockOrReleaseInfoList)) {
                this.draftLockServiceHelper.releaseOrLockDraft(lockOrReleaseInfoList);
            }
        }
        this.entrustDelScheBills(e.getDataEntities());
        logger.info("deal billlog end");
    }

    private void entrustDelScheBills(DynamicObject[] payBills) {
        String isEntrust = this.operateOption.getVariableValue("isentrust", "false");
        if (Boolean.parseBoolean(isEntrust)) {
            Set payBillIds = Arrays.stream(payBills).map(p -> (Long)p.getPkValue()).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("entrys.e_payid", "in", payBillIds).and("schedulstatus", "=", (Object)"noschedule");
            try (TXHandle tx = TX.requiresNew();){
                try {
                    DeleteServiceHelper.delete((String)"psd_schedulebill", (QFilter[])qFilter.toArray());
                }
                catch (Exception ex) {
                    logger.error("paybill cancel entrust delete payschebill error", (Throwable)ex);
                    throw new KDBizException(ex.getMessage());
                }
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PaymentPayScheCommonValidator());
        OperateOption option = this.getOption();
        String isEntrust = option.getVariableValue("isentrust", "false");
        if (Boolean.parseBoolean(isEntrust)) {
            e.addValidator((AbstractValidator)new PaymentCancelEntrustPayScheValidator());
        }
        e.addValidator(new AbstractValidator(){

            public Set<String> preparePropertys() {
                Set selectors = super.preparePropertys();
                selectors.add("iswaitsche");
                return selectors;
            }

            public void validate() {
                try {
                    Map variables = this.getOption().getVariables();
                    String isDelByPaySche = variables.getOrDefault("isdelbypaysche", "");
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        Boolean isSchePay;
                        DynamicObject payBill = dataEntity.getDataEntity();
                        boolean isWaitSche = payBill.getBoolean("iswaitsche");
                        if (isWaitSche || !StringUtils.isEmpty((String)isDelByPaySche) || !(isSchePay = (Boolean)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"psd", (String)"tmcPayScheService", (String)"isSchePayBill", (Object[])new Object[]{payBill.getLong("id")})).booleanValue()) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u76f4\u63a5\u5220\u9664\u3002", (String)"PaymentPayScheDelOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        });
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.draftLockServiceHelper.rollback();
    }
}

