/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payment;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.botp.convert.ConvertEngine;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.bean.LockResult;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.payment.PaymentPayScheduleSource;
import kd.fi.cas.util.DraftBillUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.paymentbill.PaymentPayScheSaveOrSubmitValidator;
import org.apache.commons.lang3.StringUtils;

public class PaymentPayScheSaveOrSubmitOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PaymentPayScheSaveOrSubmitOp.class);
    private static Set<String> excBills = Stream.of("fca_transdownbill", "fca_transupbill", "cas_recbill", "cas_betransdetail", "bei_transdetail_cas", "bei_intelpay", "bei_transdetail").collect(Collectors.toSet());
    private List<Object> thisOpScheids = new ArrayList<Object>();
    private List<Object> lastOpScheids = new ArrayList<Object>();
    private DynamicObject[] dbPayBills = null;
    private List<DraftLockInfo> changeLockInfoList = new ArrayList<DraftLockInfo>();
    private List<DraftLockInfo> lockOrReleaseInfoList = new ArrayList<DraftLockInfo>();
    private Map<String, Object> orgPsdMap = new HashMap<String, Object>();
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("iswaitsche");
        fieldKeys.add("result");
        fieldKeys.add("draftbill");
        fieldKeys.add("e_datafilterdesc_real_TAG");
        fieldKeys.add("description");
        fieldKeys.add("settletype");
        fieldKeys.add("billno");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("entry");
        fieldKeys.add(String.join((CharSequence)".", "entry", "e_sourcebillid"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
        fieldKeys.add(String.join((CharSequence)".", "entry", "e_scheid"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PaymentPayScheSaveOrSubmitValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List payBillIds = Stream.of(e.getDataEntities()).map(o -> o.getPkValue()).collect(Collectors.toList());
        this.dbPayBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"draftbill,settletype,cas_draftinfo,cas_draftinfo.draftbillinfo,cas_draftinfo.transamount,cas_draftinfo.draftbilllogid", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIds)});
        Set orgIds = Stream.of(e.getDataEntities()).map(d -> d.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        String psdAppId = AppMetadataCache.getAppInfo((String)"psd").getId();
        this.orgPsdMap = SystemParameterHelper.getSystemParamsByOrgIds((String)psdAppId, new ArrayList(orgIds), (String)"psd001");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String isSchePush = (String)this.getOption().getVariables().get("isSchePush");
        MainEntityType payScheEntityType = EntityMetadataCache.getDataEntityType((String)"psd_schedulebill");
        for (DynamicObject info : e.getDataEntities()) {
            Object[] schePsyBills;
            DynamicObject settleType;
            DynamicObject orgDO;
            Object sysParm;
            boolean isFromDB;
            boolean resetParam;
            DynamicObject sourceBill;
            DynamicObject billType;
            String number;
            String sourcebillId;
            DynamicObject[] sourceBills;
            String sourceBillType = info.getString("sourcebilltype");
            if ("ap_payapply".equals(sourceBillType) && (sourceBills = BusinessDataServiceHelper.load((Object[])new Object[]{sourcebillId = info.getString("sourcebillid")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourceBillType))).length > 0 && "ap_payapply_BT_manual".equals(number = (billType = (sourceBill = sourceBills[0]).getDynamicObject("billtype")).getString("number"))) {
                info.set("iswaitsche", (Object)false);
                return;
            }
            boolean isWaitSche = info.getBoolean("iswaitsche");
            if (!CasHelper.isEmpty((Object)sourceBillType) && CasHelper.isEmpty((Object)isSchePush) && !excBills.contains(sourceBillType) && (resetParam = !(isFromDB = info.getDataEntityState().getFromDatabase()) ? EmptyUtil.isNoEmpty((Object)(sysParm = this.orgPsdMap.get((orgDO = info.getDynamicObject("org")).getString("id")))) && (Boolean)sysParm != false && PaymentPayScheduleSource.getInstance().isAddScheduleSource(info) != false : isWaitSche) && !PayBillHepler.isLCSettlement((DynamicObject)(settleType = info.getDynamicObject("settletype")), (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN)) {
                info.set("iswaitsche", (Object)true);
                info.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                DynamicObjectCollection entryList = info.getDynamicObjectCollection("entry");
                long[] currPayScheIdArr = DB.genLongIds((String)payScheEntityType.getAlias(), (int)entryList.size());
                for (int i = 0; i < entryList.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryList.get(i);
                    long scheId = currPayScheIdArr[i];
                    entry.set("e_scheid", (Object)scheId);
                }
            }
            if (CasHelper.isEmpty((Object)isSchePush) && isWaitSche && EmptyUtil.isNoEmpty((Object[])(schePsyBills = BusinessDataServiceHelper.load((String)"psd_schedulebill", (String)"billno,schedulstatus", (QFilter[])new QFilter[]{new QFilter("entrys.e_payid", "in", (Object)new Object[]{info.getPkValue()})})))) {
                Object schePayBill = schePsyBills[0];
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\u5b58\u5728\u4e0b\u6e38\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"PaymentPayScheSaveOrSubmitOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), info.getString("billno"), schePayBill.getString("billno")));
            }
            this.fillBillDraftInfoEntry(info);
        }
    }

    private void endOperationTransaction(AfterOperationArgs e) {
        String isSchePush = (String)this.getOption().getVariables().get("isSchePush");
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"psd_schedulebill");
        Map payEntryIdToEntryMap = Arrays.stream(e.getDataEntities()).map(o -> o.getDynamicObjectCollection("entry")).flatMap(Collection::stream).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        for (DynamicObject paymentBill : e.getDataEntities()) {
            if (this.isAppApplyBT(paymentBill).booleanValue() || !CasHelper.isEmpty((Object)isSchePush) || !paymentBill.getBoolean("iswaitsche") || !PaymentPayScheduleSource.getInstance().isAddScheduleSource(paymentBill).booleanValue()) continue;
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("cas_paybill");
            pushArgs.setTargetEntityNumber("psd_schedulebill");
            pushArgs.setBuildConvReport(true);
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
            selectedRows.add(new ListSelectedRow(paymentBill.getPkValue()));
            pushArgs.setSelectedRows(selectedRows);
            ConvertEngine convertEngine = new ConvertEngine();
            ConvertOperationResult pushResult = convertEngine.push(pushArgs);
            if (pushResult.isSuccess()) {
                List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
                for (DynamicObject payScheBill : targetBillObjs) {
                    DynamicObjectCollection payScheEntryList = payScheBill.getDynamicObjectCollection("entrys");
                    if (payScheEntryList.size() != 1) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0b\u63a8\u7684\u6392\u7a0b\u5355\u5206\u5f55\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5BOTP\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u3002", (String)"PaymentPayScheSaveOrSubmitOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObject firstEntry = (DynamicObject)payScheEntryList.get(0);
                    long payEntryId = firstEntry.getLong("e_payentryid");
                    DynamicObject payEntry = (DynamicObject)payEntryIdToEntryMap.get(payEntryId);
                    long scheId = payEntry.getLong("e_scheid");
                    payScheBill.set("id", (Object)scheId);
                }
                try {
                    OperationResult result = OperateServiceHelper.execOperateWithoutThrow((String)"save", (String)"psd_schedulebill", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    if (!result.isSuccess()) {
                        throw new KDBizException(OperateServiceHelper.decodeErrorMsg((OperationResult)result));
                    }
                    this.thisOpScheids.addAll(result.getSuccessPkIds());
                    continue;
                }
                catch (Exception e12) {
                    logger.error((Throwable)e12);
                    throw new KDBizException(e12.getMessage());
                }
            }
            StringBuilder errMessage = new StringBuilder(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25", (String)"PaymentPayScheSaveOrSubmitOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            errMessage.append(pushResult.getMessage());
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                String billMessage = billReport.getFailMessage();
                errMessage.append(';').append(billMessage);
            }
            throw new KDBizException(errMessage.toString());
        }
        Map variables = this.getOption().getVariables();
        if (!variables.containsKey("deposit") || !Objects.equals(variables.get("deposit"), String.valueOf(Boolean.TRUE))) {
            Map<Long, LockResult> payIdAndDyMap;
            logger.info("deal billlog start");
            List<DynamicObject> payList = Arrays.stream(e.getDataEntities()).map(e1 -> e1).collect(Collectors.toList());
            List<LockResult> lockResults = this.lockOrReleaseDraft(payList);
            if (!EmptyUtil.isEmpty(lockResults) && EmptyUtil.isNoEmpty(payIdAndDyMap = lockResults.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getSourceBillId())).collect(Collectors.toMap(LockResult::getSourceBillId, x -> x)))) {
                for (DynamicObject data : e.getDataEntities()) {
                    long payBillId = data.getLong("id");
                    DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
                    for (DynamicObject entry : entrys) {
                        Long draftBillId = entry.getDynamicObject("draftbillinfo").getLong("id");
                        LockResult lockResult = payIdAndDyMap.get(payBillId);
                        if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                        Map billIdLogIdMap = lockResult.getBillIdLogIdMap();
                        boolean success = lockResult.isSuccess();
                        Long billLogId = (Long)billIdLogIdMap.get(draftBillId);
                        if (!EmptyUtil.isNoEmpty((Long)billLogId) || !success) continue;
                        entry.set("draftbilllogid", (Object)String.valueOf(billLogId));
                    }
                }
                SaveServiceHelper.update((DynamicObject[])payList.toArray(new DynamicObject[0]));
            }
            logger.info("deal billlog end");
        }
    }

    private void fillBillDraftInfoEntry(DynamicObject data) {
        try {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
            DynamicObjectCollection newDrafts = data.getDynamicObjectCollection("draftbill");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)newDrafts) && newDrafts.size() > 0 && (EmptyUtil.isEmpty((DynamicObjectCollection)entrys) || entrys.size() == 0)) {
                logger.info("fillBillDraftInfoEntry is will fill");
                for (DynamicObject newDraft : newDrafts) {
                    DynamicObject fbasedataid = newDraft.getDynamicObject("fbasedataid");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
                    DynamicObject cas_draftinfo = entrys.addNew();
                    cas_draftinfo.set("transamount", (Object)fbasedataid.getBigDecimal("amount"));
                    cas_draftinfo.set("paybillcurrency", (Object)fbasedataid.getDynamicObject("currency").getLong("id"));
                    cas_draftinfo.set("draftbillinfo", (Object)fbasedataid);
                    cas_draftinfo.set("srcbillindex", (Object)0);
                }
            }
        }
        catch (Exception e) {
            logger.error("fillBillDraftInfoEntry has error", (Throwable)e);
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.draftLockServiceHelper.rollback();
        try {
            this.deletePaySche(e.getDataEntitys(), this.thisOpScheids);
        }
        catch (Exception e1) {
            logger.error((Throwable)e1);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.endOperationTransaction(e);
        this.deletePaySche(e.getDataEntities(), this.lastOpScheids);
    }

    private void deletePaySche(DynamicObject[] objs, List<Object> scheids) {
        boolean scheOpFlag = false;
        String isSchePush = (String)this.getOption().getVariables().get("isSchePush");
        for (DynamicObject dataEntity : objs) {
            if (!CasHelper.isEmpty((Object)isSchePush) || !dataEntity.getBoolean("iswaitsche")) continue;
            scheOpFlag = true;
            break;
        }
        if (scheOpFlag) {
            try (TXHandle tx = TX.requiresNew();){
                DeleteServiceHelper.delete((String)"psd_schedulebill", (QFilter[])new QFilter[]{new QFilter("id", "in", scheids)});
            }
        }
    }

    private List<LockResult> lockOrReleaseDraft(List<DynamicObject> payBills) {
        logger.info("deal billlog start");
        List resultList = new ArrayList(8);
        String isPushAndSave = this.getOption().getVariables().getOrDefault("ispushandsave", null);
        Boolean isPushByOtherBill = false;
        Map dbPayBillMap = Stream.of(this.dbPayBills).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
        boolean isPushByScheBill = false;
        for (DynamicObject payBill : payBills) {
            DraftAmountLockSubInfo draftAmountLockSubInfo;
            List draftnoIds;
            DynamicObjectCollection draftnos;
            DraftLockInfo draftsLockInfo;
            DynamicObjectCollection entrys;
            List payShceIds;
            Object[] payShces;
            Long billLogId;
            DynamicObject settleType = payBill.getDynamicObject("settletype");
            boolean isDraftSettleType = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            boolean isPromDraft = BaseDataHelper.isSettleTypeProm((DynamicObject)settleType);
            String sourcebilltype = payBill.getString("sourcebilltype");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            boolean isDraftTypeView = isDraftSettleType || checkDraft || isPromDraft;
            Object pkValue = payBill.getPkValue();
            DynamicObject dbPayDy = (DynamicObject)dbPayBillMap.get(pkValue);
            if (null != dbPayDy) {
                DynamicObject dbSettleType = dbPayDy.getDynamicObject("settleType");
                boolean isDraftSettleTypeDb = BaseDataHelper.isSettleTypeDraft((DynamicObject)dbSettleType);
                boolean checkDraftDb = BaseDataHelper.isSettleTypeCheck((DynamicObject)dbSettleType);
                boolean isPromDraftDb = BaseDataHelper.isSettleTypeProm((DynamicObject)dbSettleType);
                boolean isDraftTypeDb = isDraftSettleTypeDb || checkDraftDb || isPromDraftDb;
                logger.info("isDraftTypeView is" + isDraftTypeView + ",and isDraftTypeDb is:" + isDraftTypeDb);
                boolean bl = isDraftTypeView = isDraftTypeView || isDraftTypeDb;
            }
            if (!isDraftTypeView || isFromcdm) {
                logger.info("is not draftType" + payBill.getString("billno"));
                continue;
            }
            isPushByScheBill = this.isPushByScheBill(payBill);
            HashSet<Long> lockedDaftIds = new HashSet<Long>();
            HashMap<Long, BigDecimal> lockIdAndAmountMapDb = new HashMap<Long, BigDecimal>(8);
            HashMap<Long, Long> lockIdAndBillLogIdMapDb = new HashMap<Long, Long>(8);
            HashSet needLockDraftIds = new HashSet();
            DynamicObjectCollection newDrafts = payBill.getDynamicObjectCollection("draftbill");
            newDrafts.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).forEach(o -> needLockDraftIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            HashMap draftIdDealAmountMap = new HashMap(8);
            HashMap draftIdLogIdMap = new HashMap(8);
            Map idAndDraftMap = new HashMap(8);
            DynamicObjectCollection draftInfoEntrys = payBill.getDynamicObjectCollection("cas_draftinfo");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfoEntrys)) {
                draftIdDealAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                idAndDraftMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getDynamicObject("draftbillinfo"), (o1, o2) -> o1, HashMap::new));
            } else {
                DynamicObject[] draftArr = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", needLockDraftIds)});
                draftIdDealAmountMap = Arrays.stream(draftArr).collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getBigDecimal("amount"), (o1, o2) -> o1, HashMap::new));
            }
            HashMap<Long, DynamicObject> idAndDraftMapDb = new HashMap<Long, DynamicObject>(8);
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            if (EmptyUtil.isEmpty((String)isPushAndSave)) {
                Object draftInfoEntrysDb;
                DynamicObject dbPayBill = (DynamicObject)dbPayBillMap.get(payBill.getPkValue());
                if (null != dbPayBill) {
                    DynamicObjectCollection dbDraftEntry = dbPayBill.getDynamicObjectCollection("draftbill");
                    for (Object dbDraft : dbDraftEntry) {
                        long draftBillId = dbDraft.getDynamicObject("fbasedataid").getLong("id");
                        lockedDaftIds.add(draftBillId);
                    }
                    draftInfoEntrysDb = dbPayBill.getDynamicObjectCollection("cas_draftinfo");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfoEntrysDb)) {
                        Object dbDraft;
                        dbDraft = draftInfoEntrysDb.iterator();
                        while (dbDraft.hasNext()) {
                            DynamicObject draftInfoEntryDb = (DynamicObject)dbDraft.next();
                            long draftBillId = draftInfoEntryDb.getDynamicObject("draftbillinfo").getLong("id");
                            BigDecimal transAmountDb = draftInfoEntryDb.getBigDecimal("transamount");
                            long billLogId2 = draftInfoEntryDb.getLong("draftbilllogid");
                            lockIdAndAmountMapDb.put(draftBillId, transAmountDb);
                            lockIdAndBillLogIdMapDb.put(draftBillId, billLogId2);
                            idAndDraftMapDb.put(draftBillId, draftInfoEntryDb.getDynamicObject("draftbillinfo"));
                        }
                    }
                    dbDraftEntry.stream().forEach(o -> lockedDaftIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
                }
                if (EmptyUtil.isEmpty((String)sourcebilltype) || !"cdm_drafttradebill".equals(sourcebilltype) && (!"cas_payapplybill".equals(sourcebilltype) || "cas_payapplybill".equals(sourcebilltype) && !PayBillHepler.checkDraftAllInPayApplyBill((DynamicObject)payBill, new ArrayList(needLockDraftIds)))) {
                    BigDecimal dealAmount;
                    DynamicObject draft;
                    Object targetDraft;
                    HashSet<Long> targetDrafts = new HashSet<Long>();
                    draftLockInfo.setSourceBillId(Long.valueOf(payBill.getLong("id")));
                    draftLockInfo.setSourceBillType(payBill.getDataEntityType().getName());
                    draftLockInfo.setBizBillNo(payBill.getString("billno"));
                    targetDrafts.addAll(lockedDaftIds);
                    targetDrafts.removeAll(needLockDraftIds);
                    if (!CollectionUtils.isEmpty(targetDrafts)) {
                        draftInfoEntrysDb = targetDrafts.iterator();
                        while (draftInfoEntrysDb.hasNext()) {
                            targetDraft = draftInfoEntrysDb.next();
                            Long releaseDraftId = Long.valueOf(targetDraft.toString());
                            DraftAmountLockSubInfo draftAmountLockSubInfo2 = new DraftAmountLockSubInfo();
                            draft = (DynamicObject)idAndDraftMapDb.get(releaseDraftId);
                            if (EmptyUtil.isNoEmpty((DynamicObject)draft) && DraftBillUtils.isPayBill((String)draft.getString("rptype"))) {
                                draftAmountLockSubInfo2.setBillTrade(LogBizTypeEnum.RELATEDPAY.getValue());
                            } else {
                                draftAmountLockSubInfo2.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                            }
                            dealAmount = (BigDecimal)draftIdDealAmountMap.get(releaseDraftId);
                            if (EmptyUtil.isEmpty((BigDecimal)dealAmount) || BigDecimal.ZERO.compareTo(dealAmount) == 0) {
                                dealAmount = lockIdAndAmountMapDb.get(releaseDraftId) == null ? BigDecimal.ZERO : (BigDecimal)lockIdAndAmountMapDb.get(releaseDraftId);
                            }
                            draftAmountLockSubInfo2.setDealAmount(dealAmount);
                            Long billLogId3 = lockIdAndBillLogIdMapDb.get(releaseDraftId) == null ? Long.valueOf(0L) : (Long)lockIdAndBillLogIdMapDb.get(releaseDraftId);
                            draftAmountLockSubInfo2.setBillLogId(billLogId3);
                            draftAmountLockSubInfo2.setOperateType(LogOperateTypeEnum.DELETE.getValue());
                            draftAmountLockSubInfo2.setBillId(releaseDraftId);
                            draftLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo2);
                        }
                    }
                    targetDrafts.clear();
                    targetDrafts.addAll(needLockDraftIds);
                    if (!CollectionUtils.isEmpty((Collection)targetDrafts)) {
                        draftInfoEntrysDb = targetDrafts.iterator();
                        while (draftInfoEntrysDb.hasNext()) {
                            targetDraft = draftInfoEntrysDb.next();
                            Long lockeDraftId = Long.valueOf(targetDraft.toString());
                            DraftAmountLockSubInfo draftAmountLockSubInfo3 = new DraftAmountLockSubInfo();
                            draft = (DynamicObject)idAndDraftMap.get(lockeDraftId);
                            if (EmptyUtil.isNoEmpty((DynamicObject)draft) && DraftBillUtils.isPayBill((String)draft.getString("rptype"))) {
                                draftAmountLockSubInfo3.setBillTrade(LogBizTypeEnum.RELATEDPAY.getValue());
                            } else {
                                draftAmountLockSubInfo3.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                            }
                            draftAmountLockSubInfo3.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                            dealAmount = draftIdDealAmountMap.get(lockeDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockeDraftId);
                            BigDecimal transAmountDb = (BigDecimal)lockIdAndAmountMapDb.get(lockeDraftId);
                            boolean isTransAmountEquals = EmptyUtil.isNoEmpty((BigDecimal)transAmountDb) && dealAmount.compareTo(transAmountDb) == 0;
                            Long billLogIdDb = (Long)lockIdAndBillLogIdMapDb.get(lockeDraftId);
                            boolean hasBillLogId = EmptyUtil.isNoEmpty((Long)billLogIdDb);
                            if (isTransAmountEquals && hasBillLogId) continue;
                            draftAmountLockSubInfo3.setDealAmount(dealAmount);
                            billLogId = draftIdLogIdMap.get(lockeDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockeDraftId);
                            draftAmountLockSubInfo3.setBillLogId(billLogId);
                            draftAmountLockSubInfo3.setBillId(lockeDraftId);
                            draftLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo3);
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
                    this.lockOrReleaseInfoList.add(draftLockInfo);
                    continue;
                }
                isPushByOtherBill = true;
                draftLockInfo.setSourceBillId(Long.valueOf(payBill.getLong("sourcebillid")));
                draftLockInfo.setSourceBillType(sourcebilltype);
                draftLockInfo.setTargetBillId(Long.valueOf(payBill.getLong("id")));
                draftLockInfo.setTargetBillType(payBill.getDataEntityType().getName());
                for (Long draftnoId : needLockDraftIds) {
                    DraftAmountLockSubInfo draftAmountLockSubInfo4 = new DraftAmountLockSubInfo();
                    draftAmountLockSubInfo4.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                    BigDecimal dealAmount = draftIdDealAmountMap.get(draftnoId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(draftnoId);
                    draftAmountLockSubInfo4.setDealAmount(dealAmount);
                    Long billLogId4 = draftIdLogIdMap.get(draftnoId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(draftnoId);
                    draftAmountLockSubInfo4.setBillLogId(billLogId4);
                    draftAmountLockSubInfo4.setBillId(draftnoId);
                    draftLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo4);
                }
                if (CollectionUtils.isEmpty(needLockDraftIds)) continue;
                this.changeLockInfoList.add(draftLockInfo);
                continue;
            }
            if (CollectionUtils.isEmpty(needLockDraftIds) || EmptyUtil.isEmpty((Object[])(payShces = BusinessDataServiceHelper.load((Object[])(payShceIds = (entrys = payBill.getDynamicObjectCollection("entry")).stream().map(v -> v.getLong("e_scheid")).collect(Collectors.toList())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"))))) continue;
            Optional<DynamicObject> masterdata = Arrays.stream(payShces).filter(d -> d.getBoolean("ismasterdata") && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{d.getString("batchnum")})).findFirst();
            if (masterdata.isPresent()) {
                DynamicObject masterbill = masterdata.get();
                draftsLockInfo = new DraftLockInfo();
                draftnos = masterbill.getDynamicObjectCollection("draftno");
                draftnoIds = draftnos.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                lockedDaftIds.addAll(draftnoIds);
                draftsLockInfo.setSourceBillId(Long.valueOf(masterbill.getLong("id")));
                draftsLockInfo.setSourceBillType("psd_schedulebill");
                draftsLockInfo.setTargetBillId(Long.valueOf(payBill.getLong("id")));
                draftsLockInfo.setTargetBillType(payBill.getDataEntityType().getName());
                for (Long draftnoId : draftnoIds) {
                    draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                    draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                    BigDecimal dealAmount = draftIdDealAmountMap.get(draftnoId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(draftnoId);
                    draftAmountLockSubInfo.setDealAmount(dealAmount);
                    billLogId = draftIdLogIdMap.get(draftnoId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(draftnoId);
                    draftAmountLockSubInfo.setBillLogId(billLogId);
                    draftAmountLockSubInfo.setBillId(draftnoId);
                    draftsLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo);
                }
                this.changeLockInfoList.add(draftsLockInfo);
                continue;
            }
            Object payShce = payShces[0];
            draftsLockInfo = new DraftLockInfo();
            draftnos = payShce.getDynamicObjectCollection("draftno");
            draftnoIds = draftnos.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            lockedDaftIds.addAll(draftnoIds);
            draftsLockInfo.setSourceBillId(Long.valueOf(payShce.getLong("id")));
            draftsLockInfo.setSourceBillType("psd_schedulebill");
            draftsLockInfo.setTargetBillId(Long.valueOf(payBill.getLong("id")));
            draftsLockInfo.setTargetBillType(payBill.getDataEntityType().getName());
            for (Long draftnoId : draftnoIds) {
                draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                BigDecimal dealAmount = draftIdDealAmountMap.get(draftnoId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(draftnoId);
                draftAmountLockSubInfo.setDealAmount(dealAmount);
                billLogId = draftIdLogIdMap.get(draftnoId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(draftnoId);
                draftAmountLockSubInfo.setBillLogId(billLogId);
                draftAmountLockSubInfo.setBillId(draftnoId);
                draftsLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo);
            }
            this.changeLockInfoList.add(draftsLockInfo);
        }
        if (!CollectionUtils.isEmpty(this.changeLockInfoList)) {
            resultList = this.draftLockServiceHelper.changeDraftLock(this.changeLockInfoList);
        }
        logger.info("deal billlog param: isPushAndSave is:" + isPushAndSave + ",isPushByScheBill is:" + isPushByScheBill + "isPushByOtherBill is:" + isPushByOtherBill);
        if (EmptyUtil.isEmpty((String)isPushAndSave) && !isPushByScheBill && !isPushByOtherBill.booleanValue() && !CollectionUtils.isEmpty(this.lockOrReleaseInfoList)) {
            resultList = this.draftLockServiceHelper.releaseOrLockDraft(this.lockOrReleaseInfoList);
        }
        logger.info("deal billlog end");
        return resultList;
    }

    private boolean isPushByScheBill(DynamicObject payBill) {
        boolean isPushByScheBill = false;
        Long scheId = 0L;
        DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            scheId = entry.getLong("e_scheid");
            if (!EmptyUtil.isNoEmpty((Long)scheId) || scheId <= 0L) continue;
            isPushByScheBill = true;
        }
        if (isPushByScheBill && scheId > 0L) {
            DynamicObjectCollection draftInfoEntrys = payBill.getDynamicObjectCollection("cas_draftinfo");
            Set draftIds = draftInfoEntrys.stream().map(v -> v.getDynamicObject("draftbillinfo").getLong("id")).collect(Collectors.toSet());
            if (EmptyUtil.isEmpty(draftIds)) {
                return false;
            }
            for (Long draftId : draftIds) {
                QFilter qFilter = new QFilter("sourcebillid", "=", (Object)scheId);
                qFilter.and("draftid", "=", (Object)draftId);
                qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
                Object[] draftBillLogs = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,dealamount,lockedamount,availableamount,", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((Object[])draftBillLogs) && draftBillLogs.length > 0) {
                    isPushByScheBill = true;
                    continue;
                }
                isPushByScheBill = false;
            }
        }
        return isPushByScheBill;
    }

    public Boolean isAppApplyBT(DynamicObject info) {
        String sourceBillType = info.getString("sourcebilltype");
        if (!"ap_payapply".equals(sourceBillType)) {
            return false;
        }
        String sourcebillId = info.getString("sourcebillid");
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((Object[])new Object[]{sourcebillId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourceBillType));
        if (sourceBills.length <= 0) {
            return false;
        }
        DynamicObject sourceBill = sourceBills[0];
        DynamicObject billType = sourceBill.getDynamicObject("billtype");
        String number = billType.getString("number");
        if ("ap_payapply_BT_manual".equals(number)) {
            info.set("iswaitsche", (Object)false);
            return true;
        }
        return false;
    }
}

