/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.bean.LockResult;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.RecDraftSaveValidator;

public class RecDraftSaveOrSubmitOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(RecDraftSaveOrSubmitOp.class);
    private List<DynamicObject> successPayBill = new ArrayList<DynamicObject>();
    private DynamicObject[] dbRecBills = null;
    private List<DraftLockInfo> changeLockInfoList = new ArrayList<DraftLockInfo>();
    private List<DraftLockInfo> lockOrReleaseInfoList = new ArrayList<DraftLockInfo>();
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("draftbill");
        fieldKeys.add("actrecamt");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("settletype");
        fieldKeys.add("txt_description");
        fieldKeys.add("txt_description_tag");
        fieldKeys.add("billno");
        fieldKeys.add("cas_draftinfo");
        fieldKeys.add("transamount");
        fieldKeys.add("draftbillinfo");
        fieldKeys.add("draftbilllogid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new RecDraftSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List recBillIds = Stream.of(e.getDataEntities()).map(o -> o.getPkValue()).collect(Collectors.toList());
        this.dbRecBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"draftbill,settleType,cas_draftinfo,cas_draftinfo.draftbillinfo,cas_draftinfo.draftbilllogid,cas_draftinfo.transamount", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillIds)});
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        for (DynamicObject paymentBill : e.getDataEntities()) {
            this.successPayBill.add(paymentBill);
        }
        this.lockOrReleaseDraft(this.successPayBill);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ArrayList cdmRecBillRelease = new ArrayList(this.lockOrReleaseInfoList.size());
        for (DraftLockInfo draftLockInfo : this.lockOrReleaseInfoList) {
            List collect = draftLockInfo.getLockSubInfoList().stream().filter(o -> LogOperateTypeEnum.DELETE.getValue().equals(o.getOperateType())).collect(Collectors.toList());
            List collect1 = collect.stream().map(DraftAmountLockSubInfo::getBillId).collect(Collectors.toList());
            cdmRecBillRelease.addAll(collect1);
        }
        if (cdmRecBillRelease.size() > 0) {
            DynamicObject[] recReleaseDraftBills;
            for (DynamicObject recDraftBill : recReleaseDraftBills = BusinessDataServiceHelper.load((Object[])cdmRecBillRelease.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"))) {
                recDraftBill.set("rectype", (Object)"");
                recDraftBill.set("rulename", (Object)"");
            }
            SaveServiceHelper.save((DynamicObject[])recReleaseDraftBills);
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        this.draftLockServiceHelper.rollback();
    }

    private List<LockResult> lockOrReleaseDraft(List<DynamicObject> recBills) {
        logger.info("lockOrReleaseDraft is start");
        List resultList = new ArrayList(8);
        Map dbPayBillMap = Stream.of(this.dbRecBills).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
        for (DynamicObject recBill : recBills) {
            DynamicObject settleType = recBill.getDynamicObject("settletype");
            String sourcebilltype = recBill.getString("sourcebilltype");
            String txt_description = recBill.getString("txt_description");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            boolean isAlloc = ResManager.loadKDString((String)"\u7968\u636e\u6c60\u5185\u80cc\u4e66", (String)"ReceivRecOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]).equals(txt_description);
            boolean isDraftTypeView = typeDraft || checkDraft;
            Object pkValue = recBill.getPkValue();
            DynamicObject dbPayBill = (DynamicObject)dbPayBillMap.get(pkValue);
            if (null != dbPayBill) {
                DynamicObject dbSettleType = dbPayBill.getDynamicObject("settleType");
                boolean isDraftSettleTypeDb = BaseDataHelper.isSettleTypeDraft((DynamicObject)dbSettleType);
                boolean checkDraftDb = BaseDataHelper.isSettleTypeCheck((DynamicObject)dbSettleType);
                boolean isDraftTypeDb = isDraftSettleTypeDb || checkDraftDb;
                logger.info("isDraftTypeView is" + isDraftTypeView + ",and isDraftTypeDb is:" + isDraftTypeDb);
                boolean bl = isDraftTypeView = isDraftTypeView || isDraftTypeDb;
            }
            if (!isDraftTypeView || isFromcdm || isAlloc) {
                logger.info("is not draftType or is from cdm" + recBill.getString("billno"));
                continue;
            }
            HashSet lockedDaftIds = new HashSet();
            HashSet needLockDraftIds = new HashSet();
            HashMap draftIdAvailableAmountMapDB = new HashMap(10);
            HashMap draftIdLogIdMapDB = new HashMap(10);
            HashMap draftIdTranAmountAmountMapDB = new HashMap(16);
            DynamicObjectCollection newDrafts = recBill.getDynamicObjectCollection("draftbill");
            DynamicObjectCollection draftInfoEntrys = recBill.getDynamicObjectCollection("cas_draftinfo");
            newDrafts.stream().forEach(o -> needLockDraftIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_payandrecdraft_f7", (String)"id,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", needLockDraftIds)});
            HashMap draftIdAvailableAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("availableamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdTranAmountAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            if (null != dbPayBill) {
                DynamicObjectCollection dbDraftEntry = dbPayBill.getDynamicObjectCollection("draftbill");
                DynamicObjectCollection draftInfoEntrysDB = dbPayBill.getDynamicObjectCollection("cas_draftinfo");
                dbDraftEntry.stream().forEach(o -> lockedDaftIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
                DynamicObject[] lockDraftBills = BusinessDataServiceHelper.load((String)"cdm_payandrecdraft_f7", (String)"id,availableamount,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", lockedDaftIds)});
                draftIdAvailableAmountMapDB = Arrays.stream(lockDraftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("amount"), (o1, o2) -> o1, HashMap::new));
                draftIdLogIdMapDB = draftInfoEntrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                draftIdTranAmountAmountMapDB = draftInfoEntrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            }
            draftLockInfo.setSourceBillId(Long.valueOf(recBill.getLong("id")));
            draftLockInfo.setSourceBillType(recBill.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(recBill.getString("billno"));
            draftLockInfo.setBillTrade(LogBizTypeEnum.RECEIVEBILL.getValue());
            if (EmptyUtil.isEmpty((String)sourcebilltype) || !"cdm_drafttradebill".equals(sourcebilltype)) {
                BigDecimal transAmount;
                BigDecimal availableAmount;
                DraftAmountLockSubInfo draftAmountLockInfo;
                ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList;
                HashSet targetDrafts = new HashSet();
                targetDrafts.addAll(lockedDaftIds);
                targetDrafts.removeAll(needLockDraftIds);
                if (!CollectionUtils.isEmpty(targetDrafts)) {
                    draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                    for (Long deletedLockDraftId : targetDrafts) {
                        draftAmountLockInfo = new DraftAmountLockSubInfo();
                        draftAmountLockInfo.setBillId(deletedLockDraftId);
                        availableAmount = draftIdAvailableAmountMapDB.get(deletedLockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMapDB.get(deletedLockDraftId);
                        transAmount = draftIdTranAmountAmountMapDB.get(deletedLockDraftId) == null ? availableAmount : (BigDecimal)draftIdTranAmountAmountMapDB.get(deletedLockDraftId);
                        draftAmountLockInfo.setDealAmount(transAmount);
                        Long draftLogId = draftIdLogIdMapDB.get(deletedLockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMapDB.get(deletedLockDraftId);
                        draftAmountLockInfo.setBillLogId(draftLogId);
                        draftAmountLockInfo.setBillTrade(LogBizTypeEnum.RECEIVEBILL.getValue());
                        draftAmountLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
                        draftAmountLockSubInfoList.add(draftAmountLockInfo);
                    }
                    draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
                    this.lockOrReleaseInfoList.add(draftLockInfo);
                }
                targetDrafts.clear();
                targetDrafts.addAll(needLockDraftIds);
                if (CollectionUtils.isEmpty(targetDrafts)) continue;
                draftAmountLockSubInfoList = new ArrayList(8);
                for (Long lockDraftId : targetDrafts) {
                    draftAmountLockInfo = new DraftAmountLockSubInfo();
                    draftAmountLockInfo.setBillId(lockDraftId);
                    availableAmount = draftIdAvailableAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(lockDraftId);
                    transAmount = draftIdTranAmountAmountMap.get(lockDraftId) == null ? availableAmount : (BigDecimal)draftIdTranAmountAmountMap.get(lockDraftId);
                    draftAmountLockInfo.setDealAmount(transAmount);
                    Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                    draftAmountLockInfo.setBillLogId(billLogId);
                    draftAmountLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                    draftAmountLockInfo.setBillTrade(LogBizTypeEnum.RECEIVEBILL.getValue());
                    if (transAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    draftAmountLockSubInfoList.add(draftAmountLockInfo);
                }
                draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
                if (this.lockOrReleaseInfoList.contains(draftLockInfo)) continue;
                this.lockOrReleaseInfoList.add(draftLockInfo);
                continue;
            }
            draftLockInfo.setSourceBillId(Long.valueOf(recBill.getLong("sourcebillid")));
            draftLockInfo.setSourceBillType(sourcebilltype);
            draftLockInfo.setTargetBillId(Long.valueOf(recBill.getLong("id")));
            draftLockInfo.setTargetBillType(recBill.getDataEntityType().getName());
            for (Long draftnoId : needLockDraftIds) {
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                BigDecimal dealAmount = draftIdAvailableAmountMap.get(draftnoId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(draftnoId);
                BigDecimal transAmount = draftIdTranAmountAmountMap.get(draftnoId) == null ? dealAmount : (BigDecimal)draftIdTranAmountAmountMap.get(draftnoId);
                draftAmountLockSubInfo.setDealAmount(transAmount);
                Long billLogId = draftIdLogIdMap.get(draftnoId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(draftnoId);
                draftAmountLockSubInfo.setBillLogId(billLogId);
                draftAmountLockSubInfo.setBillId(draftnoId);
                draftLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo);
            }
            if (CollectionUtils.isEmpty(needLockDraftIds)) continue;
            this.changeLockInfoList.add(draftLockInfo);
        }
        logger.info("changeLockInfoList size:" + this.changeLockInfoList.size() + ";lockOrReleaseInfoList size:" + this.lockOrReleaseInfoList.size());
        if (!CollectionUtils.isEmpty(this.changeLockInfoList)) {
            resultList = this.draftLockServiceHelper.changeDraftLock(this.changeLockInfoList);
        }
        if (!CollectionUtils.isEmpty(this.lockOrReleaseInfoList)) {
            resultList = this.draftLockServiceHelper.releaseOrLockDraft(this.lockOrReleaseInfoList);
            ArrayList<LockResult> addLockResult = new ArrayList<LockResult>(8);
            for (LockResult lockResult : resultList) {
                LockResult lockResultAddNew = new LockResult();
                LockResult lockResultReleaseNew = new LockResult();
                Map billIdDiffAmountMap = lockResult.getBillIdDiffAmountMap();
                Map billIdLogIdMap = lockResult.getBillIdLogIdMap();
                Long sourceBillId = lockResult.getSourceBillId();
                boolean success = lockResult.isSuccess();
                lockResultReleaseNew.setSourceBillId(sourceBillId);
                lockResultReleaseNew.setSuccess(success);
                lockResultAddNew.setSourceBillId(sourceBillId);
                lockResultAddNew.setSuccess(success);
                lockResultAddNew.setBillIdDiffAmountMap(billIdDiffAmountMap);
                HashMap<Long, Long> addMap = new HashMap<Long, Long>(8);
                for (Map.Entry entry : billIdLogIdMap.entrySet()) {
                    Long key = (Long)entry.getKey();
                    Long value = (Long)entry.getValue();
                    BigDecimal bigDecimal = (BigDecimal)billIdDiffAmountMap.get(key);
                    if (null == bigDecimal) continue;
                    addMap.put(key, value);
                }
                if (!EmptyUtil.isNoEmpty(addMap) || addMap.size() <= 0) continue;
                lockResultAddNew.setBillIdLogIdMap(addMap);
                addLockResult.add(lockResultAddNew);
            }
            if (EmptyUtil.isNoEmpty(addLockResult)) {
                for (DynamicObject data : recBills) {
                    this.updateEntryLogIds(addLockResult, data);
                }
                SaveServiceHelper.update((DynamicObject[])recBills.toArray(new DynamicObject[0]));
            }
        }
        logger.info("deal billlog end");
        return resultList;
    }

    private void updateEntryLogIds(List<LockResult> lockResults, DynamicObject data) {
        Map<Long, LockResult> recIdAndDyMap;
        if (!EmptyUtil.isEmpty(lockResults) && EmptyUtil.isNoEmpty(recIdAndDyMap = lockResults.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getSourceBillId())).collect(Collectors.toMap(LockResult::getSourceBillId, x -> x)))) {
            long recBillId = data.getLong("id");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
            for (DynamicObject entry : entrys) {
                Long draftBillId = entry.getDynamicObject("draftbillinfo").getLong("id");
                LockResult lockResult = recIdAndDyMap.get(recBillId);
                if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                Map billIdLogIdMap = lockResult.getBillIdLogIdMap();
                boolean success = lockResult.isSuccess();
                Long billLogId = (Long)billIdLogIdMap.get(draftBillId);
                if (!EmptyUtil.isNoEmpty((Long)billLogId) || !success) continue;
                entry.set("draftbilllogid", (Object)String.valueOf(billLogId));
            }
        }
    }
}

