/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.validator.recclaim.RecClaimCancelAccountValidator;

public class RecClaimCancelAddFeeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List lst = args.getFieldKeys();
        lst.add("billno");
        lst.add("isaddfee");
        lst.add("claimstatus");
        lst.add("confirmuser");
        lst.add("entryentity");
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimcenterbill", (String)"entryentity"));
        lst.add("isunclaim");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new RecClaimCancelAccountValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObject[] claimbills;
            boolean isaddfee = info.getBoolean("isaddfee");
            if (!isaddfee) continue;
            DynamicObjectCollection entryentity = info.getDynamicObjectCollection("entryentity");
            entryentity.forEach(dy -> {
                dy.set("e_actamt", (Object)dy.getBigDecimal("e_actamt").add(dy.getBigDecimal("e_fee")));
                dy.set("e_fee", (Object)BigDecimal.ZERO);
            });
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
            QFilter billnoQf = new QFilter("claimno", "=", (Object)info.getString("billno"));
            for (DynamicObject claimbill : claimbills = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,entryentity,entryentity.e_actamt,entryentity.e_fee", (QFilter[])new QFilter[]{billnoQf})) {
                claimbill.getDynamicObjectCollection("entryentity").forEach(dy -> {
                    dy.set("e_actamt", (Object)dy.getBigDecimal("e_actamt").add(dy.getBigDecimal("e_fee")));
                    dy.set("e_fee", (Object)BigDecimal.ZERO);
                });
            }
            SaveServiceHelper.save((DynamicObject[])claimbills);
        }
    }
}

