/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recinit;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.validator.recinit.RecEdcSaveValidator;

public class RecEdcSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keyList = e.getFieldKeys();
        keyList.add("org");
        keyList.add("recperiod");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new RecEdcSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] infos;
        super.beginOperationTransaction(e);
        for (DynamicObject info : infos = e.getDataEntities()) {
            Object orgId = info.getDynamicObject("org").getPkValue();
            DynamicObject recperiod = info.getDynamicObject("recperiod");
            Date date = DateUtils.getDataFormat((Date)recperiod.getDate("begindate"), (boolean)true);
            this.updateUseStatus(orgId, date, true, true);
            this.updateUseStatus(orgId, date, true, false);
            this.updateUseStatus(orgId, date, false, true);
            this.updateUseStatus(orgId, date, false, false);
            QFilter orgFilter = new QFilter("org", "=", orgId);
            QFilter periodFilter = new QFilter("initperiod", "=", recperiod.getPkValue());
            QFilter initFilter = new QFilter("isfinishinit", "=", (Object)"1");
            boolean exists = QueryServiceHelper.exists((String)"cas_rec_init", (QFilter[])new QFilter[]{orgFilter, periodFilter, initFilter});
            if (exists) {
                this.updateOutDatas(orgId, recperiod.getPkValue(), "cas_bankstatement");
                this.updateOutDatas(orgId, recperiod.getPkValue(), "cas_bankjournal");
            }
            BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])infos, (OperateType)OperateType.ADD);
        }
    }

    private void updateUseStatus(Object orgId, Date date, Boolean isJournal, Boolean isUse) {
        QFilter oFilter = null;
        if (isJournal.booleanValue()) {
            DynamicObject[] accountObjects = AccountBankHelper.getAccountBanksByCreateOrg((Long)((Long)orgId));
            HashSet<Long> accountIds = new HashSet<Long>(accountObjects.length);
            for (DynamicObject account : accountObjects) {
                Long accountId = account.getLong("id");
                accountIds.add(accountId);
            }
            oFilter = new QFilter("accountbank", "in", accountIds);
        } else {
            oFilter = new QFilter("org", "=", orgId);
        }
        QFilter pFilter = new QFilter("period", "!=", (Object)0L);
        QFilter dateFilter = new QFilter(isJournal != false ? "bookdate" : "bizdate", isUse != false ? ">=" : "<", (Object)date);
        String dataEntity = isJournal != false ? "cas_bankjournal" : "cas_bankstatement";
        DynamicObject[] bsDatas = BusinessDataServiceHelper.load((String)dataEntity, (String)"id,isvalid", (QFilter[])new QFilter[]{oFilter, pFilter, dateFilter});
        if (bsDatas != null && bsDatas.length > 0) {
            for (DynamicObject bsData : bsDatas) {
                bsData.set("isvalid", (Object)(isUse != false ? "1" : "0"));
            }
            SaveServiceHelper.save((DynamicObject[])bsDatas);
        }
    }

    private void updateOutDatas(Object orgId, Object initPeriodId, String outDataEntity) {
        QFilter recperiodFilter;
        QFilter oFilter = new QFilter("org", "=", orgId);
        QFilter pFilter = new QFilter("period", "=", (Object)0L);
        DynamicObject[] outDatas = BusinessDataServiceHelper.load((String)outDataEntity, (String)"id,isvalid", (QFilter[])new QFilter[]{oFilter, pFilter, recperiodFilter = new QFilter("recinitperiod", "=", initPeriodId)});
        if (outDatas != null && outDatas.length > 0) {
            for (DynamicObject outData : outDatas) {
                outData.set("isvalid", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])outDatas);
        }
    }
}

