/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recinit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.opplugin.recinit.AbstractRecIniUnreachableImport;

public class RecInitCompanyUnreachableImportDataOp
extends AbstractRecIniUnreachableImport {
    @Override
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        return super.save(rowdatas, logger);
    }

    @Override
    protected String businessType() {
        return "company";
    }

    @Override
    protected List<String> saveData(AbstractRecIniUnreachableImport.SaveParameter saveParameter) {
        Map<String, Object> unReachData = saveParameter.getUnReachData();
        Map<String, DynamicObject> numberRelateOrg = saveParameter.getNumberRelateOrg();
        Map<String, DynamicObject> numberRelateBank = saveParameter.getNumberRelateBank();
        Map<String, DynamicObject> numberRelateCurrency = saveParameter.getNumberRelateCurrency();
        Map<Long, DynamicObject> orgRelateRecInit = saveParameter.getOrgRelateRecInit();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement");
        ArrayList<DynamicObject> statementInfos = new ArrayList<DynamicObject>(COLLECTION_CAPACITY);
        ArrayList<String> successOrgNumber = new ArrayList<String>(unReachData.size());
        for (Map.Entry<String, Object> data : unReachData.entrySet()) {
            String message;
            String orgNumber = data.getKey();
            DynamicObject org = numberRelateOrg.get(orgNumber);
            long orgid = org.getLong("id");
            List entries = (List)data.getValue();
            Boolean isBreak = false;
            Boolean isAfterDay = false;
            for (Map entry : entries) {
                String bankNumber = (String)entry.get("bankNumber");
                DynamicObject accountbank = numberRelateBank.get(bankNumber);
                String currencyNumber = (String)entry.get("currencyNumber");
                DynamicObject currency = numberRelateCurrency.get(currencyNumber);
                DynamicObject recInit = orgRelateRecInit.get(orgid);
                if (recInit == null) {
                    isBreak = true;
                    break;
                }
                DynamicObject recinitperiod = recInit.getDynamicObject("initperiod");
                DynamicObject startPeriod = PeriodHelper.getPeriodById((long)recinitperiod.getLong("id"));
                Date firstDay = startPeriod.getDate("begindate");
                Date bizDate = (Date)entry.get("bizdate");
                if (bizDate.compareTo(firstDay) >= 0) {
                    isAfterDay = true;
                    break;
                }
                String description = (String)entry.get("description");
                BigDecimal debitAmount = entry.get("debitamount") == null ? BigDecimal.ZERO : (BigDecimal)entry.get("debitamount");
                BigDecimal creditAmount = entry.get("creditamount") == null ? BigDecimal.ZERO : (BigDecimal)entry.get("creditamount");
                DynamicObject statementInfo = new DynamicObject((DynamicObjectType)entityType);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"org", (Object)org);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"isbank", (Object)"1");
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"source", (Object)"4");
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"accountbank", (Object)accountbank);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"currency", (Object)currency);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"bizdate", (Object)bizDate);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"description", (Object)description);
                if (debitAmount.compareTo(new BigDecimal("0")) > 0) {
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"debitamount", (Object)debitAmount);
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"creditamount", (Object)new BigDecimal("0.00"));
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"direction", (Object)"1");
                }
                if (creditAmount.compareTo(new BigDecimal("0")) > 0) {
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"creditamount", (Object)creditAmount);
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"debitamount", (Object)new BigDecimal("0.00"));
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"direction", (Object)"2");
                }
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"period", null);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"recinitperiod", (Object)recinitperiod);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"isvalid", (Object)"0");
                statementInfos.add(statementInfo);
            }
            if (isBreak.booleanValue()) {
                message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\uff1a\u201c%1$s\u201d\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u6216\u672a\u914d\u7f6e\u521d\u59cb\u5316\u3002", (String)"RecInitCompanyUnreachableImportDataOp_01", (String)"fi-cas-opplugin", (Object[])new Object[0]), orgNumber);
                this.addErrMessage(message);
            }
            if (isAfterDay.booleanValue()) {
                message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\uff1a\u201c%1$s\u201d\u4e1a\u52a1\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u542f\u7528\u671f\u95f4\u7b2c\u4e00\u5929\u3002", (String)"RecInitCompanyUnreachableImportDataOp_02", (String)"fi-cas-opplugin", (Object[])new Object[0]), orgNumber);
                this.addErrMessage(message);
            }
            successOrgNumber.add(orgNumber);
        }
        SaveServiceHelper.save((IDataEntityType)entityType, (Object[])statementInfos.toArray(new Object[0]));
        return successOrgNumber;
    }
}

