/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recinit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.business.helper.RecInitHepler;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.recinit.RecInitFinishInitValidator;

public class RecInitFinishInitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("isfinishinit");
        fields.add("initperiod");
        fields.add("creator");
        fields.add("createtime");
        fields.add("org");
        fields.add("cash_accountcash");
        fields.add("cash_currency");
        fields.add("cash_balance");
        fields.add("bank_accountbank");
        fields.add("bank_currency");
        fields.add("bank_statementbalance");
        fields.add("bank_statementdebit");
        fields.add("bank_statementcredit");
        fields.add("bank_journalbalance");
        fields.add("bank_journalbalanceadj");
        fields.add("bank_journalsumbalanceadj");
        fields.add("bank_statementbalanceadj");
        fields.add("bank_equal");
        fields.add("currentperiod");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        RecInitFinishInitValidator v = new RecInitFinishInitValidator();
        v.setEntityKey("cas_rec_init");
        e.addValidator((AbstractValidator)v);
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dynamicObjects;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject recInit : dynamicObjects = e.getDataEntities()) {
            DynamicObject initPeriod = recInit.getDynamicObject("initperiod");
            Object orgId = recInit.getDynamicObject("org").getPkValue();
            QFilter orgFilter = new QFilter("org", "=", orgId);
            QFilter periodFilter = new QFilter("recperiod", "=", initPeriod.getPkValue());
            boolean exists = QueryServiceHelper.exists((String)"cas_rec_edc", (QFilter[])new QFilter[]{orgFilter, periodFilter});
            if (!exists) continue;
            this.updateOutDatas(orgId, initPeriod.getPkValue(), "cas_bankstatement");
            this.updateOutDatas(orgId, initPeriod.getPkValue(), "cas_bankjournal");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] recInits = e.getDataEntities();
        HashSet<Long> orgSet = new HashSet<Long>(recInits.length);
        for (DynamicObject recInit : recInits) {
            DynamicObject org = recInit.getDynamicObject("org");
            orgSet.add(org.getLong("id"));
        }
        DynamicObject[] recStartInits = BusinessDataServiceHelper.load((String)"cas_rec_edc", (String)"id, recperiod,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgSet)});
        HashMap<Long, DynamicObject> recPeriods = new HashMap<Long, DynamicObject>(recStartInits.length);
        for (DynamicObject recStartInit : recStartInits) {
            recPeriods.put(recStartInit.getDynamicObject("org").getLong("id"), recStartInit.getDynamicObject("recperiod"));
        }
        for (DynamicObject recInit : recInits) {
            RecInitHepler.reloadData((DynamicObject)recInit);
            DynamicObject org = recInit.getDynamicObject("org");
            DynamicObject initPeriod = recInit.getDynamicObject("initperiod");
            DynamicObject recPeriod = (DynamicObject)recPeriods.get(recInit.getDynamicObject("org").getLong("id"));
            DynamicObjectCollection entryBankList = recInit.getDynamicObjectCollection("entrybank");
            ArrayList<DynamicObject> statementBalances = new ArrayList<DynamicObject>(entryBankList.size());
            ArrayList<DynamicObject> checkResults = new ArrayList<DynamicObject>(entryBankList.size());
            for (DynamicObject entrybank : entryBankList) {
                QFilter orgQFilter = new QFilter("org", "=", org.getPkValue());
                QFilter periodQFilter = new QFilter("period", "=", initPeriod.getPkValue());
                QFilter typeQFilter = new QFilter("type", "=", (Object)"3");
                QFilter currencyQFilter = new QFilter("currency", "=", entrybank.getDynamicObject("bank_currency").getPkValue());
                QFilter bankQFilter = new QFilter("accountbank", "=", entrybank.getDynamicObject("bank_accountbank").getPkValue());
                DynamicObject existJournalBalance = BusinessDataServiceHelper.loadSingle((String)"cas_journalbalance", (QFilter[])new QFilter[]{orgQFilter, periodQFilter, typeQFilter, currencyQFilter, bankQFilter});
                DynamicObject journalbalance = null;
                journalbalance = EmptyUtil.isNoEmpty((DynamicObject)existJournalBalance) ? existJournalBalance : BusinessDataServiceHelper.newDynamicObject((String)"cas_journalbalance");
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"type", (Object)"3");
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"enable", (Object)1);
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"ctrlstrategy", (Object)5);
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"creator", (Object)recInit.getDynamicObject("creator"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"createtime", (Object)recInit.getDate("createtime"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"org", (Object)recInit.getDynamicObject("org"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"period", (Object)initPeriod);
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"accountbank", (Object)entrybank.getDynamicObject("bank_accountbank"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"currency", (Object)entrybank.getDynamicObject("bank_currency"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"monthstart", (Object)entrybank.getBigDecimal("bank_statementbalance"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"monthdebit", (Object)new BigDecimal(0));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"monthcredit", (Object)new BigDecimal(0));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"monthbalance", (Object)entrybank.getBigDecimal("bank_statementbalance"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"yearstart", (Object)entrybank.getBigDecimal("bank_statementbalance").add(entrybank.getBigDecimal("bank_statementdebit")).subtract(entrybank.getBigDecimal("bank_statementcredit")));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"yeardebit", (Object)entrybank.getBigDecimal("bank_statementdebit"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"yearcredit", (Object)entrybank.getBigDecimal("bank_statementcredit"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"yearbalance", (Object)entrybank.getBigDecimal("bank_statementbalance"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"openorg", (Object)entrybank.getDynamicObject("bank_accountbank").getDynamicObject("openorg"));
                DynamicObjectHelper.setValue((DynamicObject)journalbalance, (String)"isbalanced", (Object)0);
                statementBalances.add(journalbalance);
                if (!AccountBankHelper.isAuthorityAccount((DynamicObject)entrybank.getDynamicObject("bank_accountbank"), (DynamicObject)org)) continue;
                DynamicObject checkResult = BusinessDataServiceHelper.newDynamicObject((String)"cas_checkresult");
                checkResult.set("org", (Object)org);
                checkResult.set("accountbank", (Object)entrybank.getDynamicObject("bank_accountbank"));
                checkResult.set("currency", (Object)entrybank.getDynamicObject("bank_currency"));
                checkResult.set("enddate", (Object)DateUtils.getLastDay((Date)initPeriod.getDate("begindate"), (int)1));
                checkResult.set("stmtamt", (Object)entrybank.getBigDecimal("bank_statementbalance"));
                checkResults.add(checkResult);
            }
            SaveServiceHelper.save((DynamicObject[])statementBalances.toArray(new DynamicObject[0]));
            OperateOption create = OperateOption.create();
            create.setVariableValue("billstatus", "C");
            create.setVariableValue("finishinit", "true");
            OperationResult result = OperateServiceHelper.execOperateWithoutThrow((String)"balance", (String)"cas_checkresult", (DynamicObject[])checkResults.toArray(new DynamicObject[0]), (OperateOption)create);
            if (result.isSuccess()) continue;
            String failResultMsg = CasHelper.getFailResultMsg((OperationResult)result);
            throw new KDBizException(failResultMsg);
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])e.getDataEntities(), (OperateType)OperateType.ADD);
    }

    private void updateOutDatas(Object orgId, Object initPeriodId, String outDataEntity) {
        QFilter recperiodFilter;
        QFilter oFilter = new QFilter("org", "=", orgId);
        QFilter pFilter = new QFilter("period", "=", (Object)0L);
        DynamicObject[] outDatas = BusinessDataServiceHelper.load((String)outDataEntity, (String)"id,isvalid", (QFilter[])new QFilter[]{oFilter, pFilter, recperiodFilter = new QFilter("recinitperiod", "=", initPeriodId)});
        if (outDatas != null && outDatas.length > 0) {
            for (DynamicObject outData : outDatas) {
                outData.set("isvalid", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])outDatas);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject recInit : e.getDataEntities()) {
            DynamicObjectHelper.setValue((DynamicObject)recInit, (String)"isfinishinit", (Object)"1");
        }
        SaveServiceHelper.update((DynamicObject[])e.getDataEntities());
    }
}

