/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.refund;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.Pair;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.ar.ArWriteBackHelper;
import kd.fi.cas.business.writeback.ar.bean.Result;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.refund.RefundWriteBackConsumer;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.message.MessageTemplateEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.opplugin.refund.RefundWriteBackHelper;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.refund.RevBillRefundRenoteValidator;

public class RevRefundRenoteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RevRefundRenoteOp.class);
    private final Map<String, Object> param = new HashMap<String, Object>();
    private DynamicObject[] bills;
    private DynamicObject revBill;
    private Map<Long, DynamicObject> entrustSourceBills;
    private List<DynamicObject> finalReleList = new ArrayList<DynamicObject>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("relebilltype");
        lst.add("relewithinfo");
        lst.add("revlist.revid");
        lst.add("relebilllist.id");
        lst.add("relebilllist.entryid");
        lst.add("relebilllist.currentrefundamt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject refundObj = e.getDataEntities()[0];
        DynamicObjectCollection releList = RefundHelper.filterNotZeroRelaList((List)refundObj.getDynamicObjectCollection("relebilllist"));
        String releBillType = refundObj.getString("relebilltype");
        Object[] ids = releList.stream().map(r -> r.getLong("id")).toArray();
        this.bills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)releBillType));
        this.entrustSourceBills = RefundWriteBackHelper.getEntrustSourceBills(this.bills);
        DynamicObject revObj = (DynamicObject)refundObj.getDynamicObjectCollection("revlist").get(0);
        this.revBill = BusinessDataServiceHelper.loadSingle((Object)revObj.getLong("revid"), (String)"cas_recbill", (String)"id,txt_description,isrefund,refundtype,isfullrefund,actrecamt,fee,entry.e_receivingtype,entry,entry.e_receivableamt");
        e.addValidator((AbstractValidator)new RevBillRefundRenoteValidator(this.bills, this.revBill, this.entrustSourceBills));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("--\u9000\u6b3e-- ReceivingBillReturnMoneyOp.beginOperationTransaction(BeginOperationTransactionArgs)");
        DynamicObject refundObj = e.getDataEntities()[0];
        String releBillType = refundObj.getString("relebilltype");
        boolean releWithInfo = refundObj.getBoolean("relewithinfo");
        DynamicObject revObj = (DynamicObject)refundObj.getDynamicObjectCollection("revlist").get(0);
        long revid = revObj.getLong("revid");
        String description = this.revBill.getString("txt_description");
        DynamicObjectCollection releList = RefundHelper.filterNotZeroRelaList((List)refundObj.getDynamicObjectCollection("relebilllist"));
        Map<Long, List<DynamicObject>> releInfoByBillId = releList.stream().collect(Collectors.groupingBy(r -> r.getLong("id")));
        if ("cas_paybill".equals(releBillType)) {
            for (DynamicObject payBill : this.bills) {
                Long payBillId = (Long)payBill.getPkValue();
                List<DynamicObject> reles = releInfoByBillId.get(payBillId);
                Map<DynamicObject, BigDecimal> entryRefundAmt = this.refundPayBill(payBill, reles, releWithInfo, description);
                this.saveRelation(entryRefundAmt, (Long)payBill.getPkValue(), revid, "cas_paybill", true);
                DynamicObject sourcePayBill = this.entrustSourceBills.get(payBillId);
                if (sourcePayBill == null) continue;
                Long sourcePayBillId = (Long)sourcePayBill.getPkValue();
                ArrayList<DynamicObject> refundEntryList = new ArrayList<DynamicObject>(entryRefundAmt.keySet());
                List copyReles = RefundHelper.copyReles((Long)sourcePayBillId, refundEntryList, reles, (boolean)releWithInfo, (String)"cas_paybill");
                Map<DynamicObject, BigDecimal> sourceEntryRefundAmt = this.refundPayBill(sourcePayBill, copyReles, releWithInfo, description);
                BigDecimal totalRefundAmt = sourceEntryRefundAmt.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                RefundHelper.updateEntrustAmt((DynamicObject)sourcePayBill, (BigDecimal)totalRefundAmt, (boolean)false);
                this.saveRelation(sourceEntryRefundAmt, sourcePayBillId, revid, "cas_paybill", false);
                this.finalReleList.addAll(copyReles);
            }
        } else if ("cas_agentpaybill".equals(releBillType)) {
            for (DynamicObject agentBill : this.bills) {
                Long agentId = (Long)agentBill.getPkValue();
                List<DynamicObject> reles = releInfoByBillId.get(agentId);
                Map<DynamicObject, BigDecimal> entryRefundAmt = this.refundAgentBill(agentBill, reles, releBillType, description);
                this.saveRelation(entryRefundAmt, agentId, revid, "cas_agentpaybill", true);
                DynamicObject sourceAgentBill = this.entrustSourceBills.get(agentId);
                if (sourceAgentBill == null) continue;
                Long sourceAgentId = (Long)sourceAgentBill.getPkValue();
                ArrayList<DynamicObject> refundEntryList = new ArrayList<DynamicObject>(entryRefundAmt.keySet());
                List copyReles = RefundHelper.copyReles((Long)sourceAgentId, refundEntryList, reles, (boolean)releWithInfo, (String)"cas_agentpaybill");
                Map<DynamicObject, BigDecimal> sourceEntryRefundAmt = this.refundAgentBill(sourceAgentBill, copyReles, releBillType, description);
                BigDecimal totalRefundAmt = sourceEntryRefundAmt.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                RefundHelper.updateEntrustAmt((DynamicObject)sourceAgentBill, (BigDecimal)totalRefundAmt, (boolean)false);
                this.saveRelation(sourceEntryRefundAmt, sourceAgentId, revid, "cas_agentpaybill", false);
                this.finalReleList.addAll(copyReles);
            }
        }
        this.updateRevBill(this.revBill);
        this.finalReleList.addAll((Collection<DynamicObject>)releList);
        this.param.put("revId", revid);
        this.param.put("releWithInfo", releWithInfo);
        this.param.put("releBillList", this.finalReleList);
        this.param.put("releBillType", releBillType);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operateKey = this.getOption().getVariableValue("operateKey", "refund");
        WriteBackOperateEnum operate = "refund".equals(operateKey) ? WriteBackOperateEnum.REFUND : WriteBackOperateEnum.RENOTE;
        DynamicObject refundObj = e.getDataEntities()[0];
        String releBillType = refundObj.getString("relebilltype");
        List writeBackBills = RefundHelper.replaceEntrustBills((DynamicObject[])this.bills, this.entrustSourceBills);
        Map<String, List<DynamicObject>> billsBySource = writeBackBills.stream().collect(Collectors.groupingBy(bill -> bill.getString("sourcebilltype")));
        ArrayList<RefundRenoteOrCancelParam> refundParams = new ArrayList<RefundRenoteOrCancelParam>(billsBySource.size());
        for (Map.Entry<String, List<DynamicObject>> billsEntry : billsBySource.entrySet()) {
            Object resultObj;
            String sourceBillType = billsEntry.getKey();
            List<DynamicObject> billList = billsEntry.getValue();
            HashMap<String, Object> params = new HashMap<String, Object>(this.param);
            params.put("bills", billList.toArray(new DynamicObject[0]));
            try {
                RefundWriteBackConsumer writeBackConsumer = new RefundWriteBackConsumer();
                RefundRenoteOrCancelParam invokeParams = writeBackConsumer.initInvokeParams(params, (String)params.get("releBillType"), sourceBillType, operate);
                refundParams.add(invokeParams);
                if ("cas_paybill".equals(releBillType) && ArWriteBackHelper.isArApSourceType((String)sourceBillType)) continue;
                resultObj = WriteBackTaskHelper.batchAddWriteBackTask((DynamicObject[])billList.toArray(new DynamicObject[0]), (String)sourceBillType, (WriteBackOperateEnum)operate, (WriteBackConfigInvoker)writeBackConsumer, params);
            }
            catch (Throwable ex) {
                logger.error("revbill refund error: ", ex);
                throw new KDBizException(ex.getMessage());
            }
            Result result = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)resultObj), Result.class);
            if (result == null || "0".equals(result.getCode())) continue;
            throw new KDBizException(result.getErrorInfo());
        }
        if ("cas_paybill".equals(releBillType)) {
            ArrayList<DynamicObject> allBills = new ArrayList<DynamicObject>(this.bills.length + this.entrustSourceBills.size());
            allBills.addAll(this.entrustSourceBills.values());
            Collections.addAll(allBills, this.bills);
            OperateServiceHelper.execOperate((String)"delpurpay", (String)"cas_paybill", (DynamicObject[])allBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (this.entrustSourceBills.isEmpty()) {
                ArWriteBackHelper.writerBackAP((Long)((Long)this.param.get("revId")), (WriteBackOperateEnum)operate, refundParams, (String)"RefundAndRenoteECService");
            } else {
                RefundRenoteOrCancelParam invokeParams = ArWriteBackHelper.buildApRefundParam((DynamicObject[])this.bills, this.entrustSourceBills, this.param, (WriteBackOperateEnum)operate);
                ArWriteBackHelper.writerBackAP((Long)((Long)this.param.get("revId")), (WriteBackOperateEnum)operate, Collections.singletonList(invokeParams), (String)"RefundAndRenoteECService");
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operateKey = this.getOption().getVariableValue("operateKey", "refund");
        String releBillType = e.getDataEntities()[0].getString("relebilltype");
        try {
            for (DynamicObject bill : this.bills) {
                MessageInfo messageInfo = new MessageInfo();
                long bizBillId = bill.getLong("id");
                String templateNumber = "";
                String msgTag = "";
                if ("cas_paybill".equals(releBillType)) {
                    if ("refund".equals(operateKey)) {
                        templateNumber = MessageTemplateEnum.CAS_PAYBILL_REFUND.getValue();
                        msgTag = ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u9000\u6b3e", (String)"RevRefundRenoteOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    } else if ("renote".equals(operateKey)) {
                        templateNumber = MessageTemplateEnum.CAS_PAYBILL_RENOTE.getValue();
                        msgTag = ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u9000\u7968", (String)"RevRefundRenoteOp_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    }
                } else if ("cas_agentpaybill".equals(releBillType)) {
                    if ("refund".equals(operateKey)) {
                        templateNumber = MessageTemplateEnum.CAS_AGENTPAYBILL_REFUND.getValue();
                        msgTag = ResManager.loadKDString((String)"\u4ee3\u53d1\u5904\u7406\u5355\u9000\u6b3e", (String)"RevRefundRenoteOp_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    } else if ("renote".equals(operateKey)) {
                        templateNumber = MessageTemplateEnum.CAS_AGENTPAYBILL_RENOTE.getValue();
                        msgTag = ResManager.loadKDString((String)"\u4ee3\u53d1\u5904\u7406\u5355\u9000\u7968", (String)"RevRefundRenoteOp_6", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    }
                }
                messageInfo.setBizDataId(Long.valueOf(bizBillId));
                messageInfo.setMessageTag((ILocaleString)new LocaleString(msgTag));
                messageInfo.setEntityNumber(releBillType);
                messageInfo.setTemplateNumber(templateNumber);
                DynamicObject creator = bill.getDynamicObject("creator");
                if (creator != null) {
                    messageInfo.setUserIds(Collections.singletonList(creator.getLong("id")));
                }
                messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=" + releBillType + "&pkId=" + bizBillId);
                MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            }
        }
        catch (Exception ex) {
            logger.error("refund send msg error: ", (Throwable)ex);
        }
    }

    private Map<DynamicObject, BigDecimal> refundPayBill(DynamicObject payBill, List<DynamicObject> reles, boolean releWithInfo, String description) {
        String payEntrySql;
        Pair refundEntryAndAmt = RefundHelper.getRefundEntryAndAmt((DynamicObject)payBill, reles, (boolean)releWithInfo);
        List refundEntryList = (List)refundEntryAndAmt.getKey();
        this.updateBillHead(payBill, reles, "cas_paybill");
        HashMap<DynamicObject, BigDecimal> entryRefundAmt = new HashMap<DynamicObject, BigDecimal>((int)((double)refundEntryList.size() / 0.75 + 1.0));
        Map entryIdAndRefundAmt = (Map)refundEntryAndAmt.getValue();
        ArrayList<Object[]> posParamsList = new ArrayList<Object[]>(refundEntryList.size());
        ArrayList<Object[]> negParamsList = new ArrayList<Object[]>(refundEntryList.size());
        for (DynamicObject payEntry : refundEntryList) {
            Long entryId = (Long)payEntry.getPkValue();
            BigDecimal currentReAmt = (BigDecimal)entryIdAndRefundAmt.get(entryId);
            if (currentReAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal eRefundAmt = payEntry.getBigDecimal("e_refundamt");
            BigDecimal ePayableAmt = payEntry.getBigDecimal("e_payableamt");
            BigDecimal newRefundAmt = eRefundAmt.add(currentReAmt);
            BigDecimal newRemainRefundAmt = ePayableAmt.subtract(newRefundAmt);
            Object[] entryParam = new Object[]{newRefundAmt, newRemainRefundAmt, description, entryId, payBill.getPkValue(), currentReAmt};
            entryRefundAmt.put(payEntry, currentReAmt);
            if (currentReAmt.compareTo(BigDecimal.ZERO) > 0) {
                posParamsList.add(entryParam);
            } else {
                negParamsList.add(entryParam);
            }
            payEntry.set("e_refunddes", (Object)description);
        }
        if (!posParamsList.isEmpty()) {
            payEntrySql = "update T_CAS_PAYMENTBILLENTRY set frefundamt = ?,feremainrefundamt = ?,frefunddes = ? where fentryid = ? and fid = ? and feremainrefundamt >= ?";
            this.batchExecuteUpdateEntry(payBill, posParamsList, payEntrySql);
        }
        if (!negParamsList.isEmpty()) {
            payEntrySql = "update T_CAS_PAYMENTBILLENTRY set frefundamt = ?,feremainrefundamt = ?,frefunddes = ? where fentryid = ? and fid = ? and feremainrefundamt != 0 and feremainrefundamt <= ?";
            this.batchExecuteUpdateEntry(payBill, negParamsList, payEntrySql);
        }
        this.resetPayAndFeeStatusForRefund(payBill);
        OperateServiceHelper.executeOperate((String)"confirmrefund", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, (OperateOption)OperateOption.create());
        return entryRefundAmt;
    }

    private Map<DynamicObject, BigDecimal> refundAgentBill(DynamicObject agentBill, List<DynamicObject> reles, String releBillType, String description) {
        this.updateBillHead(agentBill, reles, releBillType);
        DynamicObjectCollection entryList = agentBill.getDynamicObjectCollection("entry");
        Map<Long, BigDecimal> entryIdWithRefundAmt = reles.stream().filter(r -> BigDecimal.ZERO.compareTo(r.getBigDecimal("currentrefundamt")) != 0).collect(Collectors.toMap(r -> r.getLong("entryid"), r -> r.getBigDecimal("currentrefundamt")));
        List refundEntryList = entryList.stream().filter(entry -> entryIdWithRefundAmt.containsKey(entry.getLong("id"))).collect(Collectors.toList());
        HashMap<DynamicObject, BigDecimal> entryRefundAmt = new HashMap<DynamicObject, BigDecimal>((int)((double)refundEntryList.size() / 0.75 + 1.0));
        String operateKey = this.getOption().getVariableValue("operateKey", "refund");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(refundEntryList.size());
        ArrayList<Object[]> splitTabParamList = new ArrayList<Object[]>(refundEntryList.size());
        for (DynamicObject agentEntry : refundEntryList) {
            Long entryId = (Long)agentEntry.getPkValue();
            BigDecimal currentReAmt = entryIdWithRefundAmt.get(entryId);
            if (currentReAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal eRefundAmt = agentEntry.getBigDecimal("e_refundamt");
            BigDecimal eAmt = AgentPayBillHelper.decodeAmount((String)agentEntry.getString("e_encryptamount"));
            BigDecimal newRefundAmt = eRefundAmt.add(currentReAmt);
            BigDecimal newRemainRefundAmt = eAmt.subtract(newRefundAmt);
            Object[] entryParam = new Object[]{newRefundAmt, newRemainRefundAmt, description, Character.valueOf('1'), entryId, agentBill.getPkValue(), currentReAmt};
            paramsList.add(entryParam);
            Object[] splitTabParam = new Object[]{operateKey, entryId, agentBill.getPkValue()};
            splitTabParamList.add(splitTabParam);
            entryRefundAmt.put(agentEntry, currentReAmt);
            agentEntry.set("e_refunddes", (Object)description);
        }
        String payEntrySql = "update T_CAS_AGENTPAYBILLENTRY set frefundamt = ?,feremainrefundamt = ?,frefunddes = ?,fisrefund = ? where fentryid = ? and fid = ? and feremainrefundamt >= ?";
        this.batchExecuteUpdateEntry(agentBill, paramsList, payEntrySql);
        String splitTabSql = "update T_CAS_AGENTPAYBILLENTRY_E set frefundtype = ? where fentryid = ? and fid = ?";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)splitTabSql, splitTabParamList);
        OperateServiceHelper.executeOperate((String)"confirmrefund", (String)"cas_agentpaybill", (Object[])new Object[]{agentBill.getPkValue()}, (OperateOption)OperateOption.create());
        return entryRefundAmt;
    }

    private void updateRevBill(DynamicObject revBill) {
        String operateKey = this.getOption().getVariableValue("operateKey", "refund");
        String sql = "update T_CAS_RECEIVINGBILL_E set fisrefund = ?,frefundtype = ? where fid = ? and fisrefund = '0' and frefundtype = ?";
        Object[] params = new Object[]{Character.valueOf('1'), operateKey, revBill.getPkValue(), revBill.get("refundtype")};
        int updateCount = DB.update((DBRoute)DBRouteConst.cas, (String)sql, (Object[])params);
        if (updateCount == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u53d1\u751f\u53d8\u66f4, \u8bf7\u91cd\u65b0\u8fdb\u5165\u3002", (String)"RevRefundRenoteOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private void saveRelation(Map<DynamicObject, BigDecimal> entryRefundAmt, Long billId, long revid, String entityType, boolean saveBotp) {
        Set destIds;
        if (entryRefundAmt.isEmpty()) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(entryRefundAmt.size());
        for (Map.Entry<DynamicObject, BigDecimal> data : entryRefundAmt.entrySet()) {
            DynamicObject refundEntry = data.getKey();
            Object[] param = new Object[]{billId, DBServiceHelper.genGlobalLongId(), 1, revid, refundEntry.getPkValue(), data.getValue()};
            paramList.add(param);
        }
        String sql = "cas_paybill".equals(entityType) ? "insert into T_CAS_PAYMENTBILL_REV (fid,fentryid,fseq,frevid,fpentryid,frefundamt) values(?,?,?,?,?,?)" : "insert into T_CAS_AGENTPAYBILL_REV (fid,fentryid,fseq,frevid,fpentryid,frefundamt) values(?,?,?,?,?,?)";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, paramList);
        if (saveBotp && !(destIds = CasBotpHelper.getDestBillBySrcBill((String)entityType, (Long)billId, (String)"cas_recbill")).contains(revid)) {
            CasBotpHelper.saveRelation((String)entityType, (Long)billId, (String)"cas_recbill", (Long)revid);
        }
    }

    private void resetPayAndFeeStatusForRefund(DynamicObject payBill) {
        String paySourceBillType = payBill.getString("sourcebilltype");
        if (EmptyUtil.isNotEmpty((String)paySourceBillType) && "cfm_feebill".equals(paySourceBillType)) {
            String operateKey = this.getOption().getVariableValue("operateKey", "refund");
            BillStatusEnum billStatusEnum = "refund".equals(operateKey) ? BillStatusEnum.REFUND : BillStatusEnum.RENOTE;
            payBill.set("billstatus", (Object)billStatusEnum.getValue());
            long feeBillId = payBill.getLong("sourcebillid");
            DynamicObject feeBill = BusinessDataServiceHelper.loadSingle((Object)feeBillId, (String)"cfm_feebill");
            feeBill.set("issettle", (Object)Boolean.FALSE);
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{feeBill});
                }
                catch (Throwable ex) {
                    h.markRollback();
                    throw ex;
                }
            }
        }
    }

    private void updateBillHead(DynamicObject bill, List<DynamicObject> reles, String billType) {
        Object[] payBillParams;
        String sql;
        String billStatus;
        BigDecimal payAmtSum;
        BigDecimal totalRefundedAmt = bill.getBigDecimal("totalrefundedamt");
        BigDecimal totalRemainRefundAmt = bill.getBigDecimal("totalremainrefundamt");
        BigDecimal localRefundedAmt = bill.getBigDecimal("localrefundedamt");
        BigDecimal localRemainRefundAmt = bill.getBigDecimal("localremainrefundamt");
        BigDecimal curRefundAmtSum = reles.stream().map(re -> re.getBigDecimal("currentrefundamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        DynamicObjectCollection entryList = bill.getDynamicObjectCollection("entry");
        if ("cas_paybill".equals(billType)) {
            payAmtSum = entryList.stream().map(ent -> ent.getBigDecimal("e_payableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (bill.getBoolean("isdiffcur")) {
                curRefundAmtSum = new BigDecimal(payAmtSum.toString());
            }
        } else {
            payAmtSum = entryList.stream().filter(entry -> entry.getBoolean("e_issuccess")).map(ent -> AgentPayBillHelper.decodeAmount((String)ent.getString("e_encryptamount"))).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal eRefundAmtSum = entryList.stream().map(ent -> ent.getBigDecimal("e_refundamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        String payQuotation = bill.getString("payquotation");
        BigDecimal newTotalRefundedAmt = eRefundAmtSum.add(curRefundAmtSum);
        BigDecimal newTotalRemainRefundAmt = payAmtSum.subtract(newTotalRefundedAmt);
        BigDecimal newLocalRefundedAmt = "0".equals(payQuotation) ? newTotalRefundedAmt.multiply(exchangeRate) : newTotalRefundedAmt.divide(exchangeRate, 10, RoundingMode.DOWN);
        BigDecimal newLocalRemainRefundAmt = "0".equals(payQuotation) ? newTotalRemainRefundAmt.multiply(exchangeRate) : newTotalRemainRefundAmt.divide(exchangeRate, 10, RoundingMode.DOWN);
        String operateKey = this.getOption().getVariableValue("operateKey", "refund");
        String string = billStatus = "refund".equals(operateKey) ? BillStatusEnum.REFUND.getValue() : BillStatusEnum.RENOTE.getValue();
        if ("cas_paybill".equals(billType)) {
            sql = "update T_CAS_PAYMENTBILL set fbillstatus = ?,ftotalrefundedamt = ?,ftotalremainrefundamt = ?,flocalrefundedamt = ?,flocalremainrefundamt = ? where fid = ? and fbillstatus = ? and ftotalrefundedamt = ? and ftotalremainrefundamt = ? and flocalrefundedamt = ? and flocalremainrefundamt = ?";
            payBillParams = new Object[]{billStatus, newTotalRefundedAmt, newTotalRemainRefundAmt, newLocalRefundedAmt, newLocalRemainRefundAmt, bill.getPkValue(), bill.getString("billstatus"), totalRefundedAmt, totalRemainRefundAmt, localRefundedAmt, localRemainRefundAmt};
        } else {
            sql = "update T_CAS_AGENTPAYBILL set ftotalrefundedamt = ?,ftotalremainrefundamt = ?,flocalrefundedamt = ?,flocalremainrefundamt = ? where fid = ? and ftotalrefundedamt = ? and ftotalremainrefundamt = ? and flocalrefundedamt = ? and flocalremainrefundamt = ?";
            payBillParams = new Object[]{newTotalRefundedAmt, newTotalRemainRefundAmt, newLocalRefundedAmt, newLocalRemainRefundAmt, bill.getPkValue(), totalRefundedAmt, totalRemainRefundAmt, localRefundedAmt, localRemainRefundAmt};
        }
        int updateCount = DB.update((DBRoute)DBRouteConst.cas, (String)sql, (Object[])payBillParams);
        if (updateCount == 0) {
            String msg = ResManager.loadKDString((String)"\u5173\u8054\u7684\u5355\u636e[%s]\u5df2\u53d1\u751f\u53d8\u66f4, \u8bf7\u91cd\u65b0\u9009\u62e9\u5173\u8054\u5355\u636e\u3002", (String)"RevRefundRenoteOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(msg, bill.getString("billno")));
        }
    }

    private void batchExecuteUpdateEntry(DynamicObject bill, List<Object[]> paramsList, String sql) {
        int[] resultCounts;
        for (int resultCount : resultCounts = DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, paramsList)) {
            if (resultCount != 0) continue;
            String msg = ResManager.loadKDString((String)"\u5173\u8054\u7684\u5355\u636e[%s]\u5df2\u53d1\u751f\u53d8\u66f4, \u8bf7\u91cd\u65b0\u9009\u62e9\u5173\u8054\u5355\u636e\u3002", (String)"RevRefundRenoteOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(msg, bill.getString("billno")));
        }
    }
}

