/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.consts.DBRouteConst;

public class AcctCheckReferenceValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set selector = super.preparePropertys();
        selector.add("currency");
        return selector;
    }

    public void validate() {
        for (ExtendedDataEntity vt : this.dataEntities) {
            String operateType = this.getOperateType();
            if ("save".equals(operateType)) {
                DynamicObject accountCash = vt.getDataEntity();
                DynamicObjectCollection currencyNewCol = accountCash.getDynamicObjectCollection("currency");
                StringBuilder stringBuilder = new StringBuilder();
                String selectSql = stringBuilder.append("select fbasedataid from T_CAS_CurrencyCash where FID = '").append(accountCash.getPkValue()).append('\'').toString();
                List currencyOldCol = (List)DB.query((DBRoute)DBRouteConst.cas, (String)selectSql, null, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

                    public List<Long> handle(ResultSet rs) throws Exception {
                        ArrayList<Long> Ids = new ArrayList<Long>(10);
                        while (rs.next()) {
                            Ids.add(rs.getLong(1));
                        }
                        return Ids;
                    }
                });
                boolean isExist = true;
                for (Long currencyOld : currencyOldCol) {
                    boolean isOnlyExist = false;
                    for (DynamicObject currencyNew : currencyNewCol) {
                        if (((Long)((DataEntityBase)currencyNew.get("fbasedataid")).getPkValue()).compareTo(currencyOld) != 0) continue;
                        isOnlyExist = true;
                        break;
                    }
                    if (isOnlyExist) continue;
                    isExist = false;
                    break;
                }
                if (isExist) continue;
            }
            String opType = this.getOperateKey();
            DynamicObject d = vt.getDataEntity();
            long id = d.getLong("id");
            String objType = vt.getDataEntity().getDynamicObjectType().getName();
            if (objType.trim().equals("bd_accountbanks")) {
                this.checkInitRef(vt, id, "FAccountBankID", objType, opType);
            } else if (objType.trim().equals("cas_accountcash")) {
                this.checkInitRef(vt, id, "FAccountCashID", objType, opType);
            }
            if (this.getValidateResult().getAllErrorInfo() != null && this.getValidateResult().getAllErrorInfo().size() != 0) continue;
            this.checkBankJournalRef(vt, id, "fbankacctid", opType);
            if (this.getValidateResult().getAllErrorInfo() != null && this.getValidateResult().getAllErrorInfo().size() != 0) {
                this.getFalseDataEntities().add(vt);
                continue;
            }
            this.checkCashJournalRef(vt, id, "fcashacctid", opType);
            if (this.getValidateResult().getAllErrorInfo() != null && this.getValidateResult().getAllErrorInfo().size() != 0) continue;
            this.checkPaymentBillRef(vt, id, "FPayerAcctBankID", "FPayeeAcctBankID", objType, opType);
            if (this.getValidateResult().getAllErrorInfo() != null && this.getValidateResult().getAllErrorInfo().size() != 0) continue;
            this.checkRecBillRef(vt, id, "FPayerAcctBankID", "FPayeeAcctBankID", objType, opType);
        }
    }

    private void checkInitRef(ExtendedDataEntity vt, Long id, String fieldName, String objType, String opType) {
        String sql = "";
        sql = objType.trim().equals("bd_accountbanks") ? "select fid from T_CAS_CashMgtInitBank where " + fieldName + " = ?" : "select fid from T_CAS_CashMgtInitCash where " + fieldName + " = ?";
        List ids = (List)DB.query((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{id}, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> Ids = new ArrayList<Long>(rs.getFetchSize());
                while (rs.next()) {
                    Ids.add(rs.getLong(1));
                }
                return Ids;
            }
        });
        if (ids != null && ids.size() > 0 && opType.trim().equals("save")) {
            this.addErrorMessage(vt, ResManager.loadKDString((String)"\u5df2\u88ab\u51fa\u7eb3\u521d\u59cb\u5316\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u5df2\u4f7f\u7528\u5e01\u79cd\u3002", (String)"AcctCheckReferenceValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkBankJournalRef(ExtendedDataEntity vt, Long id, String fieldName, String opType) {
        String sql = "select fid from t_cas_bankjournal where " + fieldName + " = ?";
        List ids = (List)DB.query((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{id}, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> Ids = new ArrayList<Long>(rs.getFetchSize());
                while (rs.next()) {
                    Ids.add(rs.getLong(1));
                }
                return Ids;
            }
        });
        if (ids != null && ids.size() > 0) {
            if (opType.trim().equals("save")) {
                this.addErrorMessage(vt, ResManager.loadKDString((String)"\u5df2\u88ab\u94f6\u884c\u65e5\u8bb0\u8d26\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u5df2\u4f7f\u7528\u5e01\u79cd\u3002", (String)"AcctCheckReferenceValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            } else {
                this.addErrorMessage(vt, ResManager.loadKDString((String)"\u5df2\u88ab\u94f6\u884c\u65e5\u8bb0\u8d26\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AcctCheckReferenceValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkCashJournalRef(ExtendedDataEntity vt, Long id, String fieldName, String opType) {
        String sql = "select fid from t_cas_cashjournal where " + fieldName + " = ?";
        List ids = (List)DB.query((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{id}, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> Ids = new ArrayList<Long>(rs.getFetchSize());
                while (rs.next()) {
                    Ids.add(rs.getLong(1));
                }
                return Ids;
            }
        });
        if (ids != null && ids.size() > 0) {
            if (opType.trim().equals("save")) {
                this.addErrorMessage(vt, ResManager.loadKDString((String)"\u5df2\u88ab\u73b0\u91d1\u65e5\u8bb0\u8d26\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u5df2\u4f7f\u7528\u5e01\u79cd\u3002", (String)"AcctCheckReferenceValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            } else {
                this.addErrorMessage(vt, ResManager.loadKDString((String)"\u5df2\u88ab\u73b0\u91d1\u65e5\u8bb0\u8d26\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AcctCheckReferenceValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkPaymentBillRef(ExtendedDataEntity vt, Long id, String PayeeId, String PayerId, String objType, String opType) {
        String sql = "select fid from T_CAS_PaymentBill where FPayeeAccFormId = '" + objType + "' and (" + PayeeId + " = ? or " + PayerId + " = ? )";
        List ids = (List)DB.query((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{id, id}, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> Ids = new ArrayList<Long>(rs.getFetchSize());
                while (rs.next()) {
                    Ids.add(rs.getLong(1));
                }
                return Ids;
            }
        });
        if (ids != null && ids.size() > 0) {
            if (opType.trim().equals("save")) {
                this.addErrorMessage(vt, ResManager.loadKDString((String)"\u5df2\u88ab\u4ed8\u6b3e\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u5df2\u4f7f\u7528\u5e01\u79cd\u3002", (String)"AcctCheckReferenceValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            } else {
                this.addErrorMessage(vt, ResManager.loadKDString((String)"\u5df2\u88ab\u4ed8\u6b3e\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AcctCheckReferenceValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkRecBillRef(ExtendedDataEntity vt, Long id, String PayeeId, String PayerId, String objType, String opType) {
        String sql = "select fid from T_CAS_ReceivingBill where FPayerAccFormId = '" + objType + "' and (" + PayeeId + " = ? or " + PayerId + " = ? )";
        List ids = (List)DB.query((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{id, id}, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> Ids = new ArrayList<Long>(rs.getFetchSize());
                while (rs.next()) {
                    Ids.add(rs.getLong(1));
                }
                return Ids;
            }
        });
        if (ids != null && ids.size() > 0) {
            if (opType.trim().equals("save")) {
                this.addErrorMessage(vt, ResManager.loadKDString((String)"\u5df2\u88ab\u6536\u6b3e\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u5df2\u4f7f\u7528\u5e01\u79cd\u3002", (String)"AcctCheckReferenceValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            } else {
                this.addErrorMessage(vt, ResManager.loadKDString((String)"\u5df2\u88ab\u6536\u6b3e\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AcctCheckReferenceValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

