/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentCancelPayValidator
extends AbstractValidator {
    private JournalServiceAdapter journalServiceAdapter;

    public AgentCancelPayValidator(JournalServiceAdapter journalServiceAdapter) {
        this.journalServiceAdapter = journalServiceAdapter;
    }

    public void validate() {
        List agentIdList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getString("id")).collect(Collectors.toList());
        List agentBills = Arrays.stream(this.dataEntities).map(d -> d.getDataEntity()).collect(Collectors.toList());
        QFilter srcBillId = new QFilter("sourcebillid", "in", agentIdList);
        QFilter srcbilltype = new QFilter("sourcebilltype", "=", (Object)"cas_agentpaybill");
        DynamicObject[] arBillDts = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,sourcebillid,recorg.name,billstatus,billno", (QFilter[])new QFilter[]{srcBillId, srcbilltype});
        Map agentDtsMap = Arrays.stream(arBillDts).collect(Collectors.toMap(o -> o.get("sourcebillid"), Function.identity()));
        HashMap<Long, ExtendedDataEntity> idExtendedDataEntity = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        Map billMap = agentBills.parallelStream().collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
        HashMap errorException = new HashMap(4);
        this.journalServiceAdapter.validateCancelBooks(billMap, errorException, new HashMap(), true);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entry;
            DynamicObject otherarbill;
            DynamicObject agentPayBill = dataEntity.getDataEntity();
            Long id = agentPayBill.getLong("id");
            idExtendedDataEntity.put(id, dataEntity);
            String status = agentPayBill.getString("billstatus");
            if (!BillStatusEnum.PAY.getValue().equals(status)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u4ed8\u6b3e\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"AgentPayErrorCode_7", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            String paymentchannel = agentPayBill.getString("paymentchannel");
            if (BillStatusEnum.PAY.getValue().equals(status) && "bei".equals(paymentchannel)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u4ed8\u6b3e\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"AgentPayErrorCode_36", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject payerAcctBank = (DynamicObject)agentPayBill.get("payeracctbank");
            if (EmptyUtil.isNoEmpty((DynamicObject)payerAcctBank) && "closed".equals(payerAcctBank.getString("acctstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u72b6\u6001\u662f\u5df2\u9500\u6237\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"PaymentCancelPayValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean isCommitBE = agentPayBill.getBoolean("iscommitbe");
            if (isCommitBE) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u94f6\u4f01\u7684\u5355\u636e\u65e0\u6cd5\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"AgentPayErrorCode_27", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            if (AgentPayBillHelper.isDelegAgent((DynamicObject)agentPayBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u59d4\u6258\u5176\u4ed6\u7ec4\u7ec7\u4ed8\u6b3e\uff0c\u7531\u53d7\u7406\u65b9\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"AgentPayErrorCode_32", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            if (AgentPayBillHelper.isDelegPush((DynamicObject)agentPayBill) && (otherarbill = (DynamicObject)agentDtsMap.get(agentPayBill.getPkValue())) != null && !"A".equals(otherarbill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u4ee3\u53d1\u5355\u751f\u6210\u4e86%2$s\u7684%3$s\u5176\u4ed6\u5e94\u6536\u5355\uff0c\u76ee\u524d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u53cd\u5411\u64cd\u4f5c%s\u5176\u4ed6\u5e94\u6536\u5355\uff0c\u518d\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"AgentPayErrorCode_33", (String)"fi-cas-business", (Object[])new Object[0]), agentPayBill.getString("billno"), otherarbill.getString("recorg.name"), otherarbill.getString("billno"), otherarbill.getString("billno")));
            }
            if ((entry = agentPayBill.getDynamicObjectCollection("entry")).stream().anyMatch(d -> d.getBoolean("e_isrefund"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u9000\u6b3e\u6216\u9000\u7968\u7684\u5355\u636e\u4e0d\u80fd\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"AgentPayErrorCode_35", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (errorException.size() > 0) {
                for (Map.Entry exception : errorException.entrySet()) {
                    Long idPk = (Long)exception.getKey();
                    Exception error = (Exception)exception.getValue();
                    if (!idExtendedDataEntity.containsKey(idPk)) continue;
                    this.exceptionProcess((ExtendedDataEntity)idExtendedDataEntity.get(id), (Exception)((Object)new KDBizException(error.getMessage())), ErrorLevel.Error);
                }
            }
            try {
                WriteBackValidateHelper.writeBackValidate((DynamicObject)agentPayBill, (WriteBackOperateEnum)WriteBackOperateEnum.CANCELPAYVALIDATE, AgentWriteBackConsumer.class);
            }
            catch (Exception e) {
                this.addErrorMessage(dataEntity, e.getMessage());
            }
        }
    }

    protected void exceptionProcess(ExtendedDataEntity dataEntity, Exception e, ErrorLevel error) {
        this.addMessage(dataEntity, e.getMessage(), error);
        this.getValidateResult().setSuccess(false);
    }
}

