/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.enums.AsstActTypeEnum;

public class AgentPayBillIsFreezeValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(AgentPayBillIsFreezeValidator.class);

    public Set<String> preparePropertys() {
        Set selectors = super.preparePropertys();
        selectors.add("entry");
        selectors.add("payee");
        selectors.add("payeetype");
        selectors.add("importpayeetype");
        return selectors;
    }

    public void validate() {
        Map<Long, Set> collectMap = Arrays.stream(this.getDataEntities()).map(o -> o.getDataEntity()).filter(info -> info.getDynamicObjectCollection("entry").stream().anyMatch(o -> AsstActTypeEnum.SUPPLIER.getValue().equals(o.getString("importpayeetype")) && o.get("payee") != null && o.getDynamicObject("payee").getLong("id") != 0L)).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getDynamicObjectCollection("entry").stream().filter(o -> AsstActTypeEnum.SUPPLIER.getValue().equals(o.getString("importpayeetype")) && o.get("payee") != null && o.getDynamicObject("payee").getLong("id") != 0L).map(o -> o.getDynamicObject("payee").getLong("id")).collect(Collectors.toSet())));
        if (collectMap.size() < 1) {
            return;
        }
        QFilter tQFilter = new QFilter("id", "in", collectMap.values().stream().flatMap(o -> o.stream()).collect(Collectors.toSet()));
        tQFilter.and("payhold", "=", (Object)"1");
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])tQFilter.toArray());
        if (queryResult == null || queryResult.size() < 1) {
            return;
        }
        Map<Long, ExtendedDataEntity> billMap = Arrays.stream(this.getDataEntities()).collect(Collectors.toMap(k -> k.getDataEntity().getLong("id"), v -> v));
        Set supplierIds = queryResult.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        PaymentErrorCode paymentErrorCode = new PaymentErrorCode();
        collectMap.entrySet().forEach(entry -> {
            HashSet objects = new HashSet(((Set)entry.getValue()).size() + supplierIds.size());
            objects.addAll((Collection)entry.getValue());
            objects.addAll(supplierIds);
            if (objects.size() != ((Set)entry.getValue()).size() + supplierIds.size()) {
                this.addErrorMessage((ExtendedDataEntity)billMap.get(entry.getKey()), paymentErrorCode.CANOTDOTHISOP_WHENSUPPLIERFREEZE().getMessage());
            }
        });
    }
}

