/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentPayBillWriteValidator
extends AbstractValidator {
    private WriteBackOperateEnum op = null;

    public AgentPayBillWriteValidator(WriteBackOperateEnum op) {
        this.op = op;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            String billType = info.getString("sourcebilltype");
            if (WriteBackOperateEnum.PAYVALIDATE.getValue().equals(this.op.getValue()) && WriteBackValidateHelper.getErValidateBills().contains(billType)) continue;
            OperateOption option = this.getOption();
            WriteBackServiceImpl.getInstance().setOption(option);
            String msg = WriteBackServiceImpl.getInstance().validate(info, this.op, AgentWriteBackConsumer.class, info.getString("sourcebilltype"));
            WriteBackServiceImpl.getInstance().setOption(null);
            if (!EmptyUtil.isNoEmpty((String)msg)) continue;
            String title = this.getOperationName();
            this.addMessage(dataEntity, title, msg, ErrorLevel.FatalError);
        }
    }

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.addAll(EntityPropertyHelper.getPropertys((String)"cas_agentpaybill"));
        preparePropertys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_agentpaybill", (String)"entry"));
        return preparePropertys;
    }
}

