/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.ReceredWayEnum;

public class CancelMatchValidator
extends AbstractValidator {
    public void validate() {
        List idList = Arrays.stream(this.dataEntities).map(d -> d.getDataEntity().getPkValue()).collect(Collectors.toList());
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,receredway,recedbillentry.e_recedbillid", (QFilter[])new QFilter("recedbillentry.e_recedbillid", "in", idList).and(new QFilter("recedbillentry.e_recedbilltype", "=", (Object)this.dataEntities[0].getDataEntity().getDataEntityType().getName())).toArray());
        Map<Long, String> matchMap = transDetails.stream().collect(Collectors.toMap(e -> e.getLong("recedbillentry.e_recedbillid"), e -> e.getString("receredway"), (e1, e2) -> e1));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            if (Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.NONEED.getValue()).contains(info.getString("matchflag"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d6\u6d88\u5339\u914d\u5931\u8d25\u3002\u5339\u914d\u6807\u8bc6\u4e3a\u201c\u672a\u5339\u914d\u201d\u6216\u8005\u201c\u65e0\u9700\u5339\u914d\u201d\u7684\u5355\u636e\u65e0\u9700\u53d6\u6d88\u5339\u914d\u3002", (String)"PaymentCancelMatchValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (matchMap.containsKey(info.getLong("id"))) {
                String receredway = matchMap.get(info.getLong("id"));
                String sourcebilltype = info.getString("sourcebilltype");
                if (!"cas_claimcenterbill".equals(sourcebilltype) && Arrays.asList(ReceredWayEnum.AUTOMATCH.getValue(), ReceredWayEnum.BEIPAY.getValue(), ReceredWayEnum.HANDMATCH.getValue(), ReceredWayEnum.REVERSEMATCH.getValue(), ReceredWayEnum.DIFFERMATCH.getValue()).contains(receredway)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u662f\u901a\u8fc7\u5339\u914d\u65b9\u5f0f\u4e0e\u6d41\u6c34\u4ea7\u751f\u5173\u8054\uff0c\u4e0d\u80fd\u53d6\u6d88\u5339\u914d\u3002", (String)"PaymentCancelMatchValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u901a\u8fc7\u624b\u5de5\u5339\u914d\uff08\u5355\u8fb9\u5339\u914d\uff09\u5b8c\u6210\u5339\u914d\uff0c\u6682\u4e0d\u652f\u6301\u53d6\u6d88\u5339\u914d\uff0c\u540e\u7eed\u529f\u80fd\u656c\u8bf7\u671f\u5f85\u3002", (String)"PaymentCancelMatchValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

