/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class CashMgtInitAntiInitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject cashMgtInit = extendedDataEntity.getDataEntity();
            cashMgtInit = BusinessDataServiceHelper.loadSingle((Object)cashMgtInit.getLong("id"), (String)"cas_cashmgtinit");
            Boolean isFinish = cashMgtInit.getBoolean("isfinishinit");
            if (cashMgtInit == null || cashMgtInit.getDynamicObject("standardcurrency") == null || cashMgtInit.getDynamicObject("periodtype") == null || cashMgtInit.getDynamicObject("startperiod") == null || cashMgtInit.getDynamicObject("exratetable") == null) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\u3002", (String)"CashMgtInitAntiInitValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), cashMgtInit.getDynamicObject("org").getString("name"));
                this.addErrorMessage(extendedDataEntity, message);
                this.getValidateResult().setSuccess(false);
                continue;
            }
            if (!isFinish.booleanValue()) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\u672a\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"CashMgtInitAntiInitValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]), cashMgtInit.getDynamicObject("org").getString("name"));
                this.addErrorMessage(extendedDataEntity, message);
                this.getValidateResult().setSuccess(false);
                continue;
            }
            long orgId = cashMgtInit.getDynamicObject("org").getLong("id");
            DynamicObject casRecEdc = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            DynamicObject casRecInit = BusinessDataServiceHelper.loadSingle((String)"cas_rec_init", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId).and(new QFilter("initperiod", "=", cashMgtInit.getDynamicObject("currentperiod").getPkValue()))});
            if (EmptyUtil.isNoEmpty((DynamicObject)casRecEdc) || EmptyUtil.isNoEmpty((DynamicObject)casRecInit)) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u542f\u7528\u5bf9\u8d26\u6216\u5b58\u5728\u5bf9\u8d26\u521d\u59cb\u5316\uff0c\u5982\u9700\u7ee7\u7eed\u8bf7\u5148\u505c\u7528\u5f53\u524d\u671f\u95f4\u5bf9\u8d26\u548c\u5bf9\u8d26\u521d\u59cb\u5316\u3002", (String)"CashMgtInitAntiInitValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(extendedDataEntity, msg, ErrorLevel.Error);
                this.getValidateResult().setSuccess(false);
                continue;
            }
            DynamicObject startPeriod = cashMgtInit.getDynamicObject("startperiod");
            DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
            if (startPeriod.getLong("id") != currentPeriod.getLong("id")) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u7b49\u4e8e\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u80fd\u53cd\u521d\u59cb\u5316\u3002", (String)"CashMgtInitAntiInitValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(extendedDataEntity, msg, ErrorLevel.Error);
                this.getValidateResult().setSuccess(false);
                continue;
            }
            QFilter qfilterOne = null;
            QFilter qfilterTwo = null;
            QFilter qfilterThree = null;
            qfilterOne = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection entryBanks = cashMgtInit.getDynamicObjectCollection("entrybank");
            for (DynamicObject dyObj : entryBanks) {
                long accountbankid = dyObj.getDynamicObject("bank_accountbank").getLong("id");
                qfilterTwo = new QFilter("accountbank", "=", (Object)accountbankid);
                long currencyid = dyObj.getDynamicObject("bank_currency").getLong("id");
                qfilterThree = new QFilter("currency", "=", (Object)currencyid);
                QFilter qfilterFour = new QFilter("period", "=", (Object)0);
                QFilter qfilterFive = new QFilter("ischeck", "=", (Object)"1");
                DynamicObjectCollection bankjournalCol = QueryServiceHelper.query((String)"cas_bankjournal", (String)"id,bookdate,bizdate,description,sourcebilltype,sourcebillnumber,settlementtype,settlementnumber,debitamount,creditamount", (QFilter[])new QFilter[]{qfilterOne, qfilterTwo, qfilterThree, qfilterFour, qfilterFive}, (String)"bookdate");
                DynamicObjectCollection bankstatementCol = QueryServiceHelper.query((String)"cas_bankstatement", (String)"id,bizdate,description,settlementtype,settlementnumber,debitamount,creditamount", (QFilter[])new QFilter[]{qfilterOne, qfilterTwo, qfilterThree, qfilterFour, qfilterFive}, (String)"bizdate");
                if ((bankjournalCol == null || bankjournalCol.size() <= 0) && (bankstatementCol == null || bankstatementCol.size() <= 0)) continue;
                String msg = StringUtils.formatMessage((String)ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f55\u5165\u7684\u94f6\u884c\u8d26\u6237{0}{1}\u7684\u672a\u8fbe\u8d26\u5df2\u88ab\u52fe\u5151\uff0c\u4e0d\u5141\u8bb8\u53cd\u521d\u59cb\u5316\u3002", (String)"CashMgtInitAntiInitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), (Object[])new Object[]{dyObj.getDynamicObject("bank_accountbank").getString("name"), dyObj.getDynamicObject("bank_currency").getString("name")});
                this.addMessage(extendedDataEntity, msg, ErrorLevel.Error);
                this.getValidateResult().setSuccess(false);
            }
        }
    }
}

