/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.FinalCheckOutHelper;
import kd.fi.cas.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckOutAdjustValidator
extends AbstractValidator {
    public void validate() {
        StringBuilder sb = new StringBuilder();
        HashMap<String, Date> dataMap = new HashMap<String, Date>(this.dataEntities.length);
        boolean isClosePeriod = this.getOption().containsVariable("closeCacheKey");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject checkOut = dataEntity.getDataEntity();
            DynamicObject org = checkOut.getDynamicObject("org");
            DynamicObject period = checkOut.getDynamicObject("period");
            Date beginDate = period.getDate("begindate");
            Date endDate = period.getDate("enddate");
            dataMap.put(org.getString("id"), DateUtils.getDataFormat((Date)endDate, (boolean)true));
            Boolean checkBalance = FinalCheckOutHelper.getInstance().toCreateBalanceAdjust(checkOut, isClosePeriod);
            if (checkBalance.booleanValue()) {
                DataSet adjustsDs = QueryServiceHelper.queryDataSet((String)"", (String)"cas_balanceadjust", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()), new QFilter("bizdate", ">=", (Object)beginDate), new QFilter("bizdate", "<=", (Object)endDate)}, (String)"");
                while (adjustsDs.hasNext()) {
                    Row row = adjustsDs.next();
                    sb.append(row.getString("id"));
                    sb.append(',');
                }
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"cas_balanceadjust", (String)"org.id,bankaccount.id,currency.id,bizdate", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()), new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)true)), new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false))}, (String)"");
            ArrayList<String> adjustList = new ArrayList<String>(16);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String flag = row.getString("org.id") + '-' + row.getString("bankaccount.id") + '-' + row.getString("currency.id");
                adjustList.add(flag);
            }
            this.getOption().setVariableValue("adjustList", StringUtils.join(adjustList, (String)","));
        }
        this.getOption().setVariableValue("existdjut", sb.toString());
        this.getOption().setVariableValue("orgs", JSON.toJSONString(dataMap));
    }
}

