/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.ext.fi.operation.closeperiod.validator.AbstractClosePeriodValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.StringUtils;

public class CheckOutValidator
extends AbstractClosePeriodValidator {
    private static final String ICON = "/icons/pc/entrance/zz_pztx_48_48.png";

    public void doValidate() {
        ArrayList<DynamicObject> needUpdate = new ArrayList<DynamicObject>(this.dataEntities.length);
        boolean isClosePeriod = this.getOption().containsVariable("closeCacheKey");
        for (ExtendedDataEntity data : this.dataEntities) {
            String errMsg;
            CloseCheckItemResult closeCheckItemResult;
            DynamicObject checkOut = data.getDataEntity();
            long orgId = checkOut.getLong("org.id");
            if (checkOut.getInt("checkoutstatus") == 2) {
                String errorMsg = ResManager.loadKDString((String)"\u6b63\u5728\u7ed3\u8d26\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"FinalCheckOutCheckOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                if (isClosePeriod) {
                    closeCheckItemResult = CloseCheckItemResult.buildFailed((String)ResManager.loadKDString((String)"\u91cd\u590d\u64cd\u4f5c", (String)"FinalCheckOutCheckOp_11", (String)"bos-ext-fi", (Object[])new Object[0]), (String)errorMsg, (String)ICON, (String)"cas_finalcheckout", null);
                    this.addCheckItemResult(data, orgId, 0L, closeCheckItemResult);
                } else {
                    this.addErrorMessage(data, errorMsg);
                }
            }
            if (checkOut.getInt("checkoutstatus") == 3) {
                String msg = StringUtils.formatMessage((String)ResManager.loadKDString((String)"{0}{1}{2}\u7ed3\u8d26\u6210\u529f\uff0c\u65e0\u6cd5\u518d\u6b21\u7ed3\u8d26\u3002", (String)"FinalCheckOutCheckOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), (Object[])new Object[]{checkOut.getDynamicObject("org").getString("number"), checkOut.getDynamicObject("org").getString("name"), checkOut.getDynamicObject("period").getString("name")});
                if (isClosePeriod) {
                    closeCheckItemResult = CloseCheckItemResult.buildFailed((String)ResManager.loadKDString((String)"\u65e0\u9700\u518d\u6b21\u7ed3\u8d26", (String)"FinalCheckOutCheckOp_12", (String)"bos-ext-fi", (Object[])new Object[0]), (String)msg, (String)ICON, (String)"cas_finalcheckout", null);
                    this.addCheckItemResult(data, orgId, 0L, closeCheckItemResult);
                }
                this.addErrorMessage(data, msg);
            }
            if ((errMsg = this.getErrMsg(data, isClosePeriod)) == null) continue;
            DynamicObject finalcheckout = BusinessDataServiceHelper.loadSingle((Object)data.getDataEntity().getLong("id"), (String)"cas_finalcheckout", (String)"checkoutstatus,checkoutmsg");
            DynamicObjectHelper.setValue((DynamicObject)finalcheckout, (String)"checkoutstatus", (Object)4);
            DynamicObjectHelper.setValue((DynamicObject)finalcheckout, (String)"checkoutmsg", (Object)errMsg);
            needUpdate.add(finalcheckout);
        }
        if (needUpdate.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdate.toArray(new DynamicObject[0]));
        }
    }

    private boolean haveUnReceiveBill(long orgId, Date start, Date end) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bizdate", ">=", (Object)start), new QFilter("bizdate", "<=", (Object)end), new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C", "E"})};
        return QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])filters);
    }

    private boolean haveUnPayBill(long orgId, Date start, Date end) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bizdate", ">=", (Object)start), new QFilter("bizdate", "<=", (Object)end), new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C", "E"})};
        return QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])filters);
    }

    private boolean haveUnPayAgentBill(long orgId, Date start, Date end) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bizdate", ">=", (Object)start), new QFilter("bizdate", "<=", (Object)end), new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C", "E"})};
        return QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])filters);
    }

    private boolean haveUnPayExchangeBill(long orgId, Date start, Date end) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("exchangedate", ">=", (Object)start), new QFilter("exchangedate", "<=", (Object)end), new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C"})};
        return QueryServiceHelper.exists((String)"cas_exchangebill", (QFilter[])filters);
    }

    private String getErrMsg(ExtendedDataEntity finalcheckout, boolean isClosePeriod) {
        DynamicObject nextPeriod;
        String msg = null;
        long orgId = finalcheckout.getDataEntity().getDynamicObject("org").getLong("id");
        DynamicObject period = finalcheckout.getDataEntity().getDynamicObject("period");
        period = PeriodHelper.getPeriodById((long)period.getLong("id"));
        Date periodStart = period.getDate("begindate");
        Date periodEnd = period.getDate("enddate");
        if (!isClosePeriod) {
            if (SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs087") && this.haveUnReceiveBill(orgId, periodStart, periodEnd)) {
                msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u672a\u6536\u6b3e\uff0c\u65e0\u6cd5\u7ed3\u8d26\u3002", (String)"FinalCheckOutCheckOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(finalcheckout, msg);
                return msg;
            }
            if (SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs092")) {
                if (this.haveUnPayBill(orgId, periodStart, periodEnd)) {
                    msg = ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u672a\u4ed8\u6b3e\uff0c\u65e0\u6cd5\u7ed3\u8d26\u3002", (String)"FinalCheckOutCheckOp_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(finalcheckout, msg);
                    return msg;
                }
                if (this.haveUnPayAgentBill(orgId, periodStart, periodEnd)) {
                    msg = ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u672a\u4ed8\u6b3e\uff0c\u65e0\u6cd5\u7ed3\u8d26\u3002", (String)"FinalCheckOutCheckOp_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(finalcheckout, msg);
                    return msg;
                }
                if (this.haveUnPayExchangeBill(orgId, periodStart, periodEnd)) {
                    msg = ResManager.loadKDString((String)"\u5916\u5e01\u5151\u6362\u5355\u672a\u5151\u6362\uff0c\u4e0d\u80fd\u7ed3\u8d26\u3002", (String)"FinalCheckOutCheck_7", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(finalcheckout, msg);
                    return msg;
                }
            }
        }
        if ((nextPeriod = PeriodHelper.getNextPeriod((long)period.getLong("id"))) == null) {
            msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u671f\u95f4\u57fa\u7840\u8d44\u6599\uff0c\u5426\u5219\u65e0\u6cd5\u8fdb\u884c\u7ed3\u8d26\u3002", (String)"FinalCheckOutCheckOp_6", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            if (isClosePeriod) {
                CloseCheckItemResult closeCheckItemResult = CloseCheckItemResult.buildFailed((String)ResManager.loadKDString((String)"\u671f\u95f4\u57fa\u7840\u8d44\u6599\u7f3a\u5931", (String)"FinalCheckOutCheckOp_13", (String)"bos-ext-fi", (Object[])new Object[0]), (String)msg, (String)ICON, (String)"cas_finalcheckout", null);
                this.addCheckItemResult(finalcheckout, orgId, 0L, closeCheckItemResult);
            }
            this.addErrorMessage(finalcheckout, msg);
        }
        return msg;
    }
}

