/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.enums.BusinessTypeEnum;
import kd.fi.cas.enums.ClaimPaymentTypeEnum;
import kd.fi.cas.helper.CoreBillSettingHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class ClaimBillSaveSubmitValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(ClaimBillSaveSubmitValidator.class);

    public void validate() {
        List orgIds = Arrays.stream(this.dataEntities).map(s -> s.getDataEntity().getDynamicObject("org").getLong("id")).distinct().collect(Collectors.toList());
        Map orgParams = SystemParameterHelper.getSystemParamsByOrgIds(orgIds);
        Map variables = this.getOption().getVariables();
        String source = (String)variables.get("source");
        logger.info("source:{}", (Object)source);
        List<String> payerTypeEnums = Arrays.asList(ClaimPaymentTypeEnum.ORG.getValue(), ClaimPaymentTypeEnum.OTHER.getValue());
        List coreBillSettings = CoreBillSettingHelper.loadCoreBillSetting((String)"cas_claimbill", (boolean)true, (boolean)false);
        HashSet<String> coreSettleTypes = new HashSet<String>(16);
        if (coreBillSettings.size() > 0) {
            coreSettleTypes.addAll(CoreBillSettingHelper.getNumberBySetting((List)coreBillSettings));
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_claimbill");
        ComboProp settleProperty = (ComboProp)entityType.getProperty("settlecorebilltype");
        ComboProp unSettleProperty = (ComboProp)entityType.getProperty("unsettlecorebilltype");
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject claimData = data.getDataEntity();
            String businessType = claimData.getString("businesstype");
            DynamicObject org = claimData.getDynamicObject("org");
            if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) {
                boolean multiPaymentType = claimData.getBoolean("multipaymenttype");
                String payeeType = claimData.getString("payeetype");
                boolean selectAllPayeeType = (Boolean)((Map)orgParams.get(String.valueOf(org.getLong("id")))).get("selectallpayeetype");
                DynamicObjectCollection entries = claimData.getDynamicObjectCollection("payentity");
                int i = 1;
                for (DynamicObject payEntry : entries) {
                    String msg;
                    DynamicObject ePaymentType = payEntry.getDynamicObject("e_paymenttype");
                    if (!(!EmptyUtil.isEmpty((DynamicObject)ePaymentType) || EmptyUtil.isNoEmpty((String)source) && "mobile".equals(source))) {
                        msg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u4ed8\u6b3e\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"ClaimBillSaveSubmitValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), i);
                        this.addMessage(data, msg, ErrorLevel.Error);
                    }
                    if (ePaymentType != null && ePaymentType.getBoolean("ispartpayment")) {
                        DynamicObject paySettleOrg;
                        if (multiPaymentType && !selectAllPayeeType && payerTypeEnums.contains(payeeType)) {
                            msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8ba4\u9886\u660e\u7ec6\u4e2d\u5b58\u5728\u53c2\u4e0e\u7ed3\u7b97\u7684\u4ed8\u6b3e\u7c7b\u578b\uff0c\u5339\u914d\u7684\u6536\u6b3e\u4eba\u7c7b\u578b\u662f\u3010\u4f9b\u5e94\u5546/\u5ba2\u6237/\u804c\u5458\u3011\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"ClaimBillSaveSubmitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), i);
                            this.addMessage(data, msg, ErrorLevel.Error);
                        }
                        if (EmptyUtil.isEmpty((DynamicObject)(paySettleOrg = payEntry.getDynamicObject("e_paysettleorg")))) {
                            String msg2 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u53c2\u4e0e\u7ed3\u7b97\u7684\u884c\uff0c\u5bf9\u5e94\u884c\u7ed3\u7b97\u7ec4\u7ec7\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"ClaimBillSaveSubmitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), i);
                            this.addMessage(data, msg2, ErrorLevel.Error);
                        }
                    }
                    ++i;
                }
                continue;
            }
            boolean multiReceivingType = claimData.getBoolean("multireceivingtype");
            Map<String, String> settleTypesMap = null;
            Map<String, String> unSettleTypesMap = null;
            if (multiReceivingType) {
                settleTypesMap = settleProperty.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, s -> s.getName().getLocaleValue()));
                unSettleTypesMap = unSettleProperty.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, s -> s.getName().getLocaleValue()));
            }
            String payerType = claimData.getString("paymenttype");
            boolean selectAllPayerType = (Boolean)((Map)orgParams.get(String.valueOf(org.getLong("id")))).get("selectallpayertype");
            DynamicObjectCollection entries = claimData.getDynamicObjectCollection("entryentity");
            int i = 1;
            for (DynamicObject recEntry : entries) {
                DynamicObject eReceivingType = recEntry.getDynamicObject("e_receivingtype");
                if (!(!EmptyUtil.isEmpty((DynamicObject)eReceivingType) || EmptyUtil.isNoEmpty((String)source) && "mobile".equals(source))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6536\u6b3e\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"ClaimBillSaveSubmitValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), i);
                    this.addMessage(data, msg, ErrorLevel.Error);
                }
                String eCoreBillType = recEntry.getString("e_corebilltype");
                if (eReceivingType != null && eReceivingType.getBoolean("ispartreceivable")) {
                    DynamicObject settleOrg;
                    if (multiReceivingType && Arrays.asList(BusinessTypeEnum.REC.getValue(), BusinessTypeEnum.RECTICKET.getValue(), BusinessTypeEnum.REC.getName(), BusinessTypeEnum.RECTICKET.getName()).contains(businessType) && !selectAllPayerType && payerTypeEnums.contains(payerType)) {
                        String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8ba4\u9886\u660e\u7ec6\u4e2d\u5b58\u5728\u53c2\u4e0e\u7ed3\u7b97\u7684\u6536\u6b3e\u7c7b\u578b\uff0c\u5339\u914d\u7684\u4ed8\u6b3e\u4eba\u7c7b\u578b\u662f\u3010\u4f9b\u5e94\u5546/\u5ba2\u6237/\u804c\u5458\u3011\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"ClaimBillSaveSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), i);
                        this.addMessage(data, msg, ErrorLevel.Error);
                    }
                    if (EmptyUtil.isEmpty((DynamicObject)(settleOrg = recEntry.getDynamicObject("e_settleorg")))) {
                        String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u53c2\u4e0e\u7ed3\u7b97\u7684\u884c\uff0c\u5bf9\u5e94\u884c\u7ed3\u7b97\u7ec4\u7ec7\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"ClaimBillSaveSubmitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), i);
                        this.addMessage(data, msg, ErrorLevel.Error);
                    }
                    if (multiReceivingType) {
                        this.showCoreBillTypeErrorMsg(data, coreBillSettings, coreSettleTypes, settleTypesMap, eCoreBillType, true, i);
                    }
                    Long orgId = org.getLong("id");
                    boolean cs118 = (Boolean)((Map)orgParams.get(String.valueOf(org.getLong("id")))).get("cs118");
                    if (cs118 && EmptyUtil.isNoEmpty((DynamicObject)settleOrg) && !orgId.equals(settleOrg.getLong("id"))) {
                        String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u672c\u5355\u6d89\u53ca\u4ee3\u7406\u6536\u6b3e\uff0c\u4e14\u5f00\u542f\u4e86\u4ee3\u7406\u6536\u6b3e\u5173\u8054\u751f\u6210\u7ed3\u7b97\u7ec4\u7ec7\u865a\u62df\u6536\u6b3e\u5355\u53c2\u6570\uff0c\u8bf7\u5c06\u4ee3\u7406\u6536\u6b3e\u884c\u6536\u6b3e\u7c7b\u578b\u5207\u6362\u4e3a\u4e0d\u53c2\u4e0e\u7ed3\u7b97\uff0c\u9632\u6b62\u4ea7\u751f\u91cd\u590d\u53ef\u7ed3\u7b97\u6570\u636e\u548c\u91cd\u590d\u5e94\u6536\u6d41\u6c34\u3002", (String)"ClaimBillSaveSubmitValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[]{i});
                        this.addMessage(data, msg, ErrorLevel.Error);
                    }
                } else if (multiReceivingType) {
                    this.showCoreBillTypeErrorMsg(data, coreBillSettings, coreSettleTypes, unSettleTypesMap, eCoreBillType, false, i);
                }
                ++i;
            }
        }
    }

    private void showCoreBillTypeErrorMsg(ExtendedDataEntity data, List<DynamicObject> coreBillSettings, Set<String> coreSettleTypes, Map<String, String> typesMap, String eCoreBillType, boolean isSettle, int i) {
        HashSet<String> coreBillSet = new HashSet<String>(16);
        coreBillSet.addAll(coreSettleTypes);
        coreBillSet.addAll(typesMap.keySet());
        if (!EmptyUtil.isBlank((CharSequence)eCoreBillType) && !coreBillSet.contains(eCoreBillType)) {
            HashSet<String> coreNameSet = new HashSet<String>(typesMap.values());
            String showName = this.getCoreBillName(coreNameSet, coreBillSettings, isSettle);
            String errorMsg = isSettle ? ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u6536\u6b3e\u7c7b\u578b\u4e0e\u6838\u5fc3\u5355\u636e\u4e0d\u5339\u914d\u3002\u6536\u6b3e\u7c7b\u578b\u53c2\u4e0e\u7ed3\u7b97\uff0c\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u53ef\u9009\u8303\u56f4\uff1a%2$s\u3002", (String)"ClaimBillSaveSubmitValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u6536\u6b3e\u7c7b\u578b\u4e0e\u6838\u5fc3\u5355\u636e\u4e0d\u5339\u914d\u3002\u6536\u6b3e\u7c7b\u578b\u4e0d\u53c2\u4e0e\u7ed3\u7b97\uff0c\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u53ef\u9009\u8303\u56f4\uff1a%2$s\u3002", (String)"ClaimBillSaveSubmitValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            this.addMessage(data, String.format(errorMsg, i, showName), ErrorLevel.Error);
        }
    }

    private String getCoreBillName(Set<String> coreNameSet, List<DynamicObject> coreBillSettings, boolean isSettle) {
        String prop;
        String string = prop = isSettle ? "settle" : "unsettle";
        if (coreBillSettings.size() > 0) {
            Set set = coreBillSettings.stream().filter(s -> s.getBoolean(prop)).map(s -> s.getString("name")).collect(Collectors.toSet());
            coreNameSet.addAll(set);
        }
        if (coreNameSet.size() > 0) {
            return String.join((CharSequence)"\u3001", coreNameSet);
        }
        return "";
    }
}

