/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.fi.cas.business.opservice.IOpService;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class CommonOpValidator
extends AbstractValidator {
    protected IOpService iservice;
    protected String entityKey;
    protected String operationName;
    protected Map<String, Boolean> requestMap;
    protected boolean bizLock;

    public CommonOpValidator() {
    }

    public CommonOpValidator(IOpService iservice) {
        this.iservice = iservice;
    }

    public CommonOpValidator(IOpService iservice, String entityKey, String operationName) {
        this.iservice = iservice;
        this.entityKey = entityKey;
        this.operationName = operationName;
    }

    @Deprecated
    public CommonOpValidator(IOpService iservice, String entityKey, String operationName, Map<String, Boolean> requestMap) {
        this.iservice = iservice;
        this.entityKey = entityKey;
        this.operationName = operationName;
        this.requestMap = requestMap;
    }

    public CommonOpValidator(IOpService iservice, String entityKey, String operationName, boolean bizLock) {
        this.iservice = iservice;
        this.entityKey = entityKey;
        this.operationName = operationName;
        this.bizLock = bizLock;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setOperationName(this.operationName);
    }

    public void validate() {
        Set orgIdList = Arrays.stream(this.dataEntities).filter(c -> c.getDataEntity().getDynamicObject("org") != null).map(c -> c.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        List isInitOrgList = SystemStatusCtrolHelper.getBatchSystemStatusControl(orgIdList);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            try {
                String operateKey;
                boolean isLocked;
                String pk = info.getPkValue().toString();
                if (this.requestMap != null ? !(isLocked = this.requestMap.get(pk).booleanValue()) : this.bizLock && this.hasLock(pk)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u88ab\u5176\u4ed6\u64cd\u4f5c\u9501\u5b9a\u3002", (String)"CommonOpValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                String entityName = info.getDynamicObjectType().getName();
                if ((entityName.equals("cas_paybill") || entityName.equals("cas_recbill") || entityName.equals("cas_agentpaybill")) && ((operateKey = super.getOperateKey()).equals("save") || operateKey.equals("submit")) && info.getDynamicObject("org") != null && !isInitOrgList.contains(info.getDynamicObject("org").getPkValue())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u7136\u540e\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"CommonOpValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                this.iservice.validate(info);
            }
            catch (KDBizException e) {
                this.exceptionProcess(dataEntity, (Exception)((Object)e), ErrorLevel.Error);
            }
            catch (KDException e) {
                this.exceptionProcess(dataEntity, (Exception)((Object)e), ErrorLevel.Error);
            }
        }
    }

    protected void exceptionProcess(ExtendedDataEntity dataEntity, Exception e, ErrorLevel error) {
        this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
        this.getValidateResult().setSuccess(false);
    }

    private boolean hasLock(String pk) {
        String querySQL = "select FID from T_BD_DataLock where FEntityKey = ? and FOperationKey = ? and FObjectID = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FEntityKey", 12, (Object)this.entityKey), new SqlParameter(":FOperationKey", 12, (Object)this.getOperateKey()), new SqlParameter(":FObjectID", 12, (Object)pk)};
        boolean result = (Boolean)DB.query((DBRoute)DBRouteConst.cas, (String)querySQL, (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                boolean found = false;
                if (rs.next()) {
                    found = true;
                }
                return found;
            }
        });
        return result;
    }
}

