/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.CasHelper;

public class MainTransferValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("paymenttype");
        preparePropertys.add("paymenttype.biztype");
        preparePropertys.add("org");
        preparePropertys.add("payeetype");
        preparePropertys.add("payee");
        preparePropertys.add("sourcebilltype");
        preparePropertys.add("applyorg");
        preparePropertys.add("feepay");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject payeeObj;
            DynamicObject paymentType;
            DynamicObject info = dataEntity.getDataEntity();
            BigDecimal sumAmt = info.getBigDecimal("actpayamt");
            if (BigDecimal.valueOf(Math.pow(10.0, 13.0)).compareTo(sumAmt) <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"MainTransferValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            BigDecimal localAmt = info.getBigDecimal("localamt");
            if (BigDecimal.valueOf(Math.pow(10.0, 13.0)).compareTo(localAmt) <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u6298\u672c\u4f4d\u5e01\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"MainTransferValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            BigDecimal totalPayAmt = info.getBigDecimal("totalpayamt");
            if (BigDecimal.valueOf(Math.pow(10.0, 13.0)).compareTo(totalPayAmt) <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d(\u542b\u624b\u7eed\u8d39)\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"MainTransferValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if ((paymentType = (DynamicObject)info.get("paymenttype")) == null) continue;
            DynamicObject paymentTypeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)paymentType.getPkValue(), (String)"cas_paymentbilltype", (String)"biztype");
            String bizType = paymentTypeObj == null ? null : paymentTypeObj.getString("biztype");
            DynamicObject org = (DynamicObject)info.get("org");
            Long orgId = (Long)org.getPkValue();
            String payeeType = (String)info.get("payeetype");
            Long payeeId = Long.parseLong(info.get("payee") == null ? "0" : info.get("payee").toString());
            Long payeeOrgId = 0L;
            List<String> list = Arrays.asList("bos_org", "bd_supplier", "bd_customer", "bos_user");
            if (CasHelper.isNotEmpty((Object)payeeType) && CasHelper.isNotEmpty((Object)payeeId) && list.contains(payeeType) && (payeeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeId, (String)payeeType, (String)"name")) != null) {
                payeeOrgId = (Long)payeeObj.getPkValue();
            }
            if (bizType != null && bizType.equals(PayAndRecBizTypeEnum.SPAN_MAIN_PART.getValue()) && orgId.equals(payeeOrgId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u4e3a\u201c\u8de8\u4e3b\u4f53\u8c03\u62e8\u201d\u65f6\uff0c\u6536\u6b3e\u4eba\u4e0d\u53ef\u9009\u62e9\u4e0e\u4ed8\u6b3e\u7ec4\u7ec7\u540c\u4e00\u7ec4\u7ec7\u3002", (String)"MainTransferValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            this.validateRecSourceType(info, dataEntity);
            this.validatePaySourceType(info, dataEntity);
            this.validateIntelSourceType(info, dataEntity);
        }
    }

    private void validateRecSourceType(DynamicObject info, ExtendedDataEntity dataEntity) {
        String sourceBillType = info.getString("sourcebilltype");
        if (!"cas_recbill".equals(sourceBillType)) {
            return;
        }
        DynamicObject paymentEntity = info.getDynamicObject("paymentidentify");
        if (paymentEntity == null) {
            return;
        }
        String type = paymentEntity.getString("type");
        if (!"1".equals(type)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u534f\u540c\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u5c5e\u5df2\u53d1\u751f\u7684\u6263\u6b3e\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u6807\u8bc6\u7c7b\u522b\u5fc5\u987b\u7f6e\u4e3a\u88ab\u52a8\uff0c\u4ee5\u514d\u91cd\u590d\u652f\u4ed8\u3002", (String)"MainTransferValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private void validatePaySourceType(DynamicObject info, ExtendedDataEntity dataEntity) {
        String sourceBillType = info.getString("sourcebilltype");
        if (!"cas_paybill".equals(sourceBillType)) {
            return;
        }
        DynamicObject applyOrg = info.getDynamicObject("applyorg");
        if (applyOrg != null) {
            return;
        }
        DynamicObject paymentEntity = info.getDynamicObject("paymentidentify");
        if (paymentEntity == null) {
            return;
        }
        if (!info.getBoolean("feepay")) {
            return;
        }
        String type = paymentEntity.getString("type");
        if (!"1".equals(type)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u624b\u7eed\u8d39\u72ec\u7acb\u6d41\u6c34\u4e0b\u63a8\u7684\u624b\u7eed\u8d39\u4ed8\u6b3e\u5355\uff0c\u5c5e\u5df2\u53d1\u751f\u7684\u6263\u6b3e\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u6807\u8bc6\u7c7b\u522b\u5fc5\u987b\u7f6e\u4e3a\u88ab\u52a8\uff0c\u4ee5\u514d\u91cd\u590d\u652f\u4ed8\u3002", (String)"MainTransferValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateIntelSourceType(DynamicObject info, ExtendedDataEntity dataEntity) {
        String sourceBillType = info.getString("sourcebilltype");
        if (!"bei_intelpay".equals(sourceBillType)) {
            return;
        }
        DynamicObject paymentEntity = info.getDynamicObject("paymentidentify");
        if (paymentEntity == null) {
            return;
        }
        String type = paymentEntity.getString("type");
        if (!"1".equals(type)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u88ab\u52a8\u4ed8\u6b3e\u5165\u8d26\u4e0b\u63a8\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u5c5e\u5df2\u53d1\u751f\u7684\u6263\u6b3e\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u6807\u8bc6\u7c7b\u522b\u5fc5\u987b\u7f6e\u4e3a\u88ab\u52a8\uff0c\u4ee5\u514d\u91cd\u590d\u652f\u4ed8\u3002", (String)"MainTransferValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

