/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.enums.AsstActTypeEnum;

public class PaymentBillIsFreezeValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("payeetype");
        preparePropertys.add("payee");
        return preparePropertys;
    }

    public void validate() {
        Map<Long, List<ExtendedDataEntity>> collect = Arrays.stream(this.dataEntities).filter(dataEntity -> {
            DynamicObject info = dataEntity.getDataEntity();
            return AsstActTypeEnum.SUPPLIER.getValue().equals(info.getString("payeetype")) && info.getLong("payee") != 0L;
        }).collect(Collectors.groupingBy(k -> k.getDataEntity().getLong("payee")));
        if (collect.size() < 1) {
            return;
        }
        QFilter tQFilter = new QFilter("id", "in", collect.keySet());
        tQFilter.and("payhold", "=", (Object)"1");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"PaymentBillIsFreezeValidator_bd_supplier", (String)"bd_supplier", (String)"id", (QFilter[])tQFilter.toArray(), null);
        while (ds.hasNext()) {
            PaymentErrorCode paymentErrorCode = new PaymentErrorCode();
            Row row = ds.next();
            collect.get(row.getLong("id")).forEach(entry -> this.addErrorMessage((ExtendedDataEntity)entry, paymentErrorCode.CANOTDOTHISOP_WHENSUPPLIERFREEZE().getMessage()));
        }
        ds.close();
    }
}

